/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.connector;

import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenProjectUtils;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ClasspathComputer;
import org.eclipse.pde.internal.core.ICoreConstants;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.project.PDEProject;

public class PDEProjectHelper {
    private static final String PDE_PLUGIN_NATURE = "org.eclipse.pde.PluginNature";
    private static AtomicBoolean isListeningForPluginModelChanges = new AtomicBoolean(false);
    private static final Set<IProject> PROJECTS_FOR_UPDATE_CLASSPATH = ConcurrentHashMap.newKeySet();
    private static final IPluginModelListener CLASSPATH_UPDATER = delta -> PROJECTS_FOR_UPDATE_CLASSPATH.removeIf(project -> {
        IPluginModelBase model = PluginRegistry.findModel((IProject)project);
        if (model != null) {
            new WorkspaceJob("Updating classpath", (IProject)project, model){
                private final /* synthetic */ IProject val$project;
                private final /* synthetic */ IPluginModelBase val$model;
                {
                    this.val$project = iProject;
                    this.val$model = iPluginModelBase;
                    super($anonymous0);
                }

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    PDEProjectHelper.setClasspath(this.val$project, this.val$model, monitor);
                    return Status.OK_STATUS;
                }
            }.schedule();
            return true;
        }
        return false;
    });

    private PDEProjectHelper() {
    }

    static void configurePDEBundleProject(IProject project, MavenProject mavenProject, IProgressMonitor monitor) throws CoreException {
        if (!project.hasNature(PDE_PLUGIN_NATURE)) {
            AbstractProjectConfigurator.addNature((IProject)project, (String)PDE_PLUGIN_NATURE, null);
        }
        if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
            AbstractProjectConfigurator.addNature((IProject)project, (String)"org.eclipse.jdt.core.javanature", null);
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        javaProject.setOutputLocation(PDEProjectHelper.getOutputLocation(project, mavenProject, monitor), monitor);
        IPluginModelBase model = PluginRegistry.findModel((IProject)project);
        if (model != null) {
            PDEProjectHelper.setClasspath(project, model, monitor);
        } else {
            PDEProjectHelper.addProjectForUpdateClasspath(project);
        }
    }

    static void configurePDEFeatureProject(IMavenProjectFacade projectFacade, IProgressMonitor monitor) throws CoreException {
        IProject project = projectFacade.getProject();
        if (project != null && !project.hasNature("org.eclipse.pde.FeatureNature")) {
            AbstractProjectConfigurator.addNature((IProject)project, (String)"org.eclipse.pde.FeatureNature", (IProgressMonitor)monitor);
        }
    }

    private static void addProjectForUpdateClasspath(IProject project) {
        PROJECTS_FOR_UPDATE_CLASSPATH.add(project);
        if (isListeningForPluginModelChanges.compareAndSet(false, true)) {
            PDECore pdeCore = PDECore.getDefault();
            pdeCore.getModelManager().addPluginModelListener(CLASSPATH_UPDATER);
        }
    }

    private static IPath getOutputLocation(IProject project, MavenProject mavenProject, IProgressMonitor m) throws CoreException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)m, (int)2);
        IPath outputFolderPath = PDEProjectHelper.getDefaultLibraryOutputFolder(project, (IProgressMonitor)monitor.split(1));
        if (outputFolderPath == null) {
            File outputDirectory = new File(mavenProject.getBuild().getOutputDirectory());
            outputDirectory.mkdirs();
            outputFolderPath = MavenProjectUtils.getProjectRelativePath((IProject)project, (String)outputDirectory.toString());
        }
        IFolder folder = project.getFolder(outputFolderPath);
        folder.refreshLocal(2, (IProgressMonitor)monitor.split(1));
        return folder.getFullPath();
    }

    private static IPath getDefaultLibraryOutputFolder(IProject project, IProgressMonitor monitor) throws CoreException {
        IFile buildProperties = PDEProject.getBuildProperties((IProject)project);
        if (buildProperties.exists()) {
            WorkspaceBuildModel model = new WorkspaceBuildModel(buildProperties);
            model.load();
            monitor.done();
            IBuildEntry entry = model.getBuild().getEntry("output..");
            if (entry != null) {
                return IPath.forPosix((String)entry.getTokens()[0]);
            }
        }
        return null;
    }

    static void addPDENature(IProject project, IPath manifestPath, IProgressMonitor monitor) throws CoreException {
        AbstractProjectConfigurator.addNature((IProject)project, (String)PDE_PLUGIN_NATURE, (IProgressMonitor)monitor);
        IProjectDescription description = project.getDescription();
        Stream<ICommand> builders = Arrays.stream(description.getBuildSpec()).filter(b -> !b.getBuilderName().startsWith("org.eclipse.pde."));
        description.setBuildSpec((ICommand[])builders.toArray(ICommand[]::new));
        project.setDescription(description, monitor);
        PDEProjectHelper.setManifestLocaton(project, manifestPath, monitor);
    }

    private static void setManifestLocaton(IProject project, IPath manifestPath, IProgressMonitor monitor) throws CoreException {
        IContainer bundleRoot = null;
        if (manifestPath != null) {
            IFile manifest;
            if (manifestPath.toFile().toPath().endsWith("META-INF")) {
                manifest = project.getFolder(manifestPath).getFile("MANIFEST.MF");
            } else if (manifestPath.toFile().toPath().endsWith(Path.of("META-INF", "MANIFEST.MF"))) {
                manifest = project.getFile(manifestPath);
            } else {
                return;
            }
            manifest.refreshLocal(0, monitor);
            bundleRoot = manifest.getParent().getParent();
        }
        PDEProject.setBundleRoot((IProject)project, bundleRoot);
    }

    private static IFile getBundleManifest(IProject project) {
        IContainer metaInf = PDEProject.getBundleRoot((IProject)project);
        return (metaInf == null || metaInf instanceof IProject ? project : metaInf).getFile(ICoreConstants.MANIFEST_PATH);
    }

    private static void setClasspath(IProject project, IPluginModelBase model, IProgressMonitor monitor) throws CoreException {
        IClasspathEntry[] entries = ClasspathComputer.getClasspath((IProject)project, (IPluginModelBase)model, null, (boolean)true, (boolean)true);
        JavaCore.create((IProject)project).setRawClasspath(entries, null);
        IFile manifest = PDEProjectHelper.getBundleManifest(project);
        if (manifest.isAccessible()) {
            manifest.touch(monitor);
        }
    }
}

