/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.widget;

import org.eclipse.draw2d.Graphics;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.provider.DimensionInfo;
import org.eclipse.jst.pagedesigner.css2.widget.AbstractWidgetProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class ImageWidgetProvider
extends AbstractWidgetProvider {
    private static final String NOPIC_IMAGE_NAME = "PD_nopic.jpg";
    private static Image _noPicImage;
    private static int _noPicWidth;
    private static int _noPicHeight;
    protected Image _image;
    protected int _imageWidth;
    protected int _imageHeight;

    public ImageWidgetProvider(Image image, ICSSStyle style) {
        super(style);
        Rectangle rect = null;
        if (image != null) {
            rect = image.getBounds();
            if (rect.width <= 0 || rect.height <= 0) {
                this.useNoPicImage();
            } else {
                this._image = image;
                this._imageWidth = rect.width;
                this._imageHeight = rect.height;
            }
        } else {
            this.useNoPicImage();
        }
    }

    private void useNoPicImage() {
        if (_noPicImage == null || _noPicImage.isDisposed()) {
            ImageDescriptor noPicImageDesc = PDPlugin.getDefault().getImageDescriptor(NOPIC_IMAGE_NAME);
            _noPicImage = noPicImageDesc.createImage();
            Rectangle rect = _noPicImage.getBounds();
            _noPicWidth = rect.width;
            _noPicHeight = rect.height;
        }
        this._image = _noPicImage;
        this._imageWidth = _noPicWidth;
        this._imageHeight = _noPicHeight;
    }

    @Override
    public DimensionInfo getPreferredDimension(int width, int height) {
        if (width <= 0 && height <= 0) {
            Rectangle a = this._image.getBounds();
            return new DimensionInfo(a.width, a.height, -1);
        }
        if (width > 0 && height > 0) {
            return new DimensionInfo(width, height, -1);
        }
        if (height > 0) {
            width = (int)((double)this._imageWidth * (double)height / (double)this._imageHeight);
            return new DimensionInfo(width, height, -1);
        }
        height = (int)((double)this._imageHeight * (double)width / (double)this._imageWidth);
        return new DimensionInfo(width, height, -1);
    }

    @Override
    public void paintFigure(Graphics g, org.eclipse.draw2d.geometry.Rectangle rect) {
        if (this._image != null) {
            g.drawImage(this._image, 0, 0, this._imageWidth, this._imageHeight, rect.x, rect.y, rect.width, rect.height);
        }
    }
}

