/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.persistence;

import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jpt.common.ui.WidgetFactory;
import org.eclipse.jpt.common.ui.internal.swt.ColumnAdapter;
import org.eclipse.jpt.common.ui.internal.swt.widgets.ControlTools;
import org.eclipse.jpt.common.ui.internal.swt.widgets.DisplayTools;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemoveTablePane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.model.event.ListAddEvent;
import org.eclipse.jpt.common.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.common.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiableCollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.ui.persistence.JptJpaUiPersistenceMessages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class PersistenceUnitPropertiesEditorPage
extends Pane<PersistenceUnit> {
    private ModifiableCollectionValueModel<PersistenceUnit.Property> selectedPropertiesModel;
    private TablePane tablePane;

    public PersistenceUnitPropertiesEditorPage(PropertyValueModel<PersistenceUnit> persistenceUnitModel, Composite parentComposite, WidgetFactory widgetFactory, ResourceManager resourceManager) {
        super(persistenceUnitModel, parentComposite, widgetFactory, resourceManager);
    }

    protected void initialize() {
        super.initialize();
        this.selectedPropertiesModel = new SimpleCollectionValueModel();
    }

    protected void initializeLayout(Composite container) {
        this.addLabel(container, JptJpaUiPersistenceMessages.PERSISTENCE_UNIT_PROPERTIES_COMPOSITE_PROPERTIES_DESCRIPTION);
        this.tablePane = new TablePane(container);
    }

    private ListValueModel<PersistenceUnit.Property> buildPropertiesListModel() {
        return new ListAspectAdapter<PersistenceUnit, PersistenceUnit.Property>(this.getSubjectHolder(), new String[]{"properties"}){

            protected ListIterable<PersistenceUnit.Property> getListIterable() {
                return ((PersistenceUnit)this.subject).getProperties();
            }

            protected int size_() {
                return ((PersistenceUnit)this.subject).getPropertiesSize();
            }
        };
    }

    private ITableLabelProvider buildPropertyLabelProvider() {
        return new TableLabelProvider();
    }

    private AddRemovePane.Adapter<PersistenceUnit.Property> buildTableAdapter() {
        return new AddRemovePane.AbstractAdapter<PersistenceUnit.Property>(){

            public PersistenceUnit.Property addNewItem() {
                PersistenceUnit.Property property = ((PersistenceUnit)PersistenceUnitPropertiesEditorPage.this.getSubject()).addProperty();
                PersistenceUnitPropertiesEditorPage.this.tablePane.getTableViewer().editElement((Object)property, 1);
                return property;
            }

            public PropertyValueModel<Boolean> buildRemoveButtonEnabledModel(CollectionValueModel<PersistenceUnit.Property> selectedItemsModel) {
                return this.buildSingleSelectedItemEnabledModel(selectedItemsModel);
            }

            public void removeSelectedItems(CollectionValueModel<PersistenceUnit.Property> selectedItemsModel) {
                PersistenceUnit.Property property = (PersistenceUnit.Property)selectedItemsModel.iterator().next();
                ((PersistenceUnit)PersistenceUnitPropertiesEditorPage.this.getSubject()).removeProperty(property);
            }
        };
    }

    private static class PropertyColumnAdapter
    implements ColumnAdapter<PersistenceUnit.Property> {
        public static final int COLUMN_COUNT = 3;
        public static final int NAME_COLUMN = 1;
        public static final int SELECTION_COLUMN = 0;
        public static final int VALUE_COLUMN = 2;

        private PropertyColumnAdapter() {
        }

        private ModifiablePropertyValueModel<String> buildNameModel(PersistenceUnit.Property subject) {
            return new PropertyAspectAdapter<PersistenceUnit.Property, String>("name", subject){

                protected String buildValue_() {
                    return ((PersistenceUnit.Property)this.subject).getName();
                }

                protected void setValue_(String value) {
                    ((PersistenceUnit.Property)this.subject).setName(value);
                }
            };
        }

        private ModifiablePropertyValueModel<String> buildValueModel(PersistenceUnit.Property subject) {
            return new PropertyAspectAdapter<PersistenceUnit.Property, String>("value", subject){

                protected String buildValue_() {
                    return ((PersistenceUnit.Property)this.subject).getValue();
                }

                protected void setValue_(String value) {
                    ((PersistenceUnit.Property)this.subject).setValue(value);
                }
            };
        }

        public ModifiablePropertyValueModel<?>[] cellModels(PersistenceUnit.Property subject) {
            ModifiablePropertyValueModel[] models = new ModifiablePropertyValueModel[]{new SimplePropertyValueModel(), this.buildNameModel(subject), this.buildValueModel(subject)};
            return models;
        }

        public int columnCount() {
            return 3;
        }

        public String columnName(int columnIndex) {
            switch (columnIndex) {
                case 1: {
                    return JptJpaUiPersistenceMessages.PERSISTENCE_UNIT_PROPERTIES_COMPOSITE_NAME_COLUMN;
                }
                case 2: {
                    return JptJpaUiPersistenceMessages.PERSISTENCE_UNIT_PROPERTIES_COMPOSITE_VALUE_COLUMN;
                }
            }
            return null;
        }
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            PersistenceUnit.Property property = (PersistenceUnit.Property)element;
            String value = null;
            switch (columnIndex) {
                case 1: {
                    value = property.getName();
                    break;
                }
                case 2: {
                    value = property.getValue();
                }
            }
            if (value == null) {
                value = "";
            }
            return value;
        }
    }

    private class TablePane
    extends AddRemoveTablePane<PersistenceUnit, PersistenceUnit.Property> {
        private final String SELECTION_COLUMN = "selection";
        private TableViewer tableViewer;

        private TablePane(Composite parent) {
            super((Pane)PersistenceUnitPropertiesEditorPage.this, parent, PersistenceUnitPropertiesEditorPage.this.buildTableAdapter(), PersistenceUnitPropertiesEditorPage.this.buildPropertiesListModel(), PersistenceUnitPropertiesEditorPage.this.selectedPropertiesModel, PersistenceUnitPropertiesEditorPage.this.buildPropertyLabelProvider());
            this.SELECTION_COLUMN = "selection";
        }

        private CellEditor[] buildCellEditors(Table table) {
            CellEditor[] cellEditorArray = new CellEditor[3];
            cellEditorArray[1] = new TextCellEditor((Composite)table);
            cellEditorArray[2] = new TextCellEditor((Composite)table);
            return cellEditorArray;
        }

        private ICellModifier buildCellModifier() {
            return new ICellModifier(){

                public boolean canModify(Object element, String property) {
                    return !"selection".equals(property);
                }

                public Object getValue(Object element, String property) {
                    PersistenceUnit.Property propertyModel = (PersistenceUnit.Property)element;
                    String value = null;
                    if (property == "name") {
                        value = propertyModel.getName();
                    } else if (property == "value") {
                        value = propertyModel.getValue();
                    }
                    if (value == null) {
                        value = "";
                    }
                    return value;
                }

                public void modify(Object element, String property, Object value) {
                    PersistenceUnit.Property propertyModel;
                    if (element instanceof TableItem) {
                        TableItem tableItem = (TableItem)element;
                        propertyModel = (PersistenceUnit.Property)tableItem.getData();
                    } else {
                        propertyModel = (PersistenceUnit.Property)element;
                    }
                    if (property == "name") {
                        propertyModel.setName(value.toString());
                    } else if (property == "value") {
                        propertyModel.setValue(value.toString());
                    }
                }
            };
        }

        protected ColumnAdapter<PersistenceUnit.Property> buildColumnAdapter() {
            return new PropertyColumnAdapter();
        }

        private String[] buildColumnProperties() {
            return new String[]{"selection", "name", "value"};
        }

        TableViewer getTableViewer() {
            return this.tableViewer;
        }

        protected void initializeMainComposite(Composite container, AddRemovePane.Adapter<PersistenceUnit.Property> adapter, ListValueModel<?> listHolder, ModifiableCollectionValueModel<PersistenceUnit.Property> selectedItemsHolder, IBaseLabelProvider labelProvider, String helpId) {
            super.initializeMainComposite(container, adapter, listHolder, selectedItemsHolder, labelProvider, helpId);
            Table table = this.getMainControl();
            table.setLayoutData((Object)new GridData(1808));
            TableColumn selectionColumn = table.getColumn(0);
            selectionColumn.setResizable(false);
            selectionColumn.setWidth(20);
            this.tableViewer = new TableViewer(table);
            this.tableViewer.setCellEditors(this.buildCellEditors(table));
            this.tableViewer.setCellModifier(this.buildCellModifier());
            this.tableViewer.setColumnProperties(this.buildColumnProperties());
        }

        protected void itemsAdded(ListAddEvent e) {
            super.itemsAdded(e);
            this.revalidateLayout();
        }

        protected void itemsRemoved(ListRemoveEvent e) {
            super.itemsRemoved(e);
            this.revalidateLayout();
        }

        protected void listChanged(ListChangeEvent e) {
            super.listChanged(e);
            this.revalidateLayout();
        }

        private void revalidateLayout() {
            DisplayTools.asyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    Table table = TablePane.this.getMainControl();
                    if (!table.isDisposed()) {
                        ControlTools.reflow((Composite)table);
                    }
                }
            });
        }
    }
}

