/*********************************************************************
* Copyright (c) 2005, 2019 SAP SE
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which is available at https://www.eclipse.org/legal/epl-2.0/
*
* Contributors:
*    SAP SE - initial API, implementation and documentation
*    mwenz - Bug 325084 - Provide documentation for Patterns
*
* SPDX-License-Identifier: EPL-2.0
**********************************************************************/
package org.eclipse.graphiti.pattern.config;

/**
 * The Interface IIndentConfiguration.
 * 
 * @experimental This API is in an experimental state and should be used by
 *               clients, as it not final and can be removed or changed without
 *               prior notice!
 * 
 * @noimplement This interface is not intended to be implemented by clients.
 * @noextend This interface is not intended to be extended by clients.
 */
public interface IIndentConfiguration extends IPatternConfiguration {

	/**
	 * Gets the outer indent bottom.
	 * 
	 * @return the outer indent bottom
	 */
	int getOuterIndentBottom();

	/**
	 * Gets the outer indent left.
	 * 
	 * @return the outer indent left
	 */
	int getOuterIndentLeft();

	/**
	 * Gets the outer indent right.
	 * 
	 * @return the outer indent right
	 */
	int getOuterIndentRight();

	/**
	 * Gets the outer indent top.
	 * 
	 * @return the outer indent top
	 */
	int getOuterIndentTop();

	/**
	 * Sets the outer indent bottom.
	 * 
	 * @param outerIndentBottom
	 *            the new outer indent bottom
	 */
	void setOuterIndentBottom(int outerIndentBottom);

	/**
	 * Sets the outer indent left.
	 * 
	 * @param outerIndentLeft
	 *            the new outer indent left
	 */
	void setOuterIndentLeft(int outerIndentLeft);

	/**
	 * Sets the outer indent right.
	 * 
	 * @param outerIndentRight
	 *            the new outer indent right
	 */
	void setOuterIndentRight(int outerIndentRight);

	/**
	 * Sets the outer indent top.
	 * 
	 * @param outerIndentTop
	 *            the new outer indent top
	 */
	void setOuterIndentTop(int outerIndentTop);

}
