/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.properties.sections.appearance;

import java.util.ArrayList;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.properties.Properties;
import org.eclipse.gmf.runtime.diagram.ui.properties.internal.l10n.DiagramUIPropertiesImages;
import org.eclipse.gmf.runtime.diagram.ui.properties.internal.l10n.DiagramUIPropertiesMessages;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.appearance.ArrowTypePopup;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.appearance.ColorsAndFontsPropertySection;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.appearance.LineTypePopup;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.appearance.LineWidthPopup;
import org.eclipse.gmf.runtime.emf.core.util.PackageUtil;
import org.eclipse.gmf.runtime.notation.ArrowType;
import org.eclipse.gmf.runtime.notation.LineStyle;
import org.eclipse.gmf.runtime.notation.LineType;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class ColoursAndFontsAndLineStylesPropertySection
extends ColorsAndFontsPropertySection {
    protected static final String LINE_WIDTH_COMMAND_NAME = DiagramUIPropertiesMessages.LineStylesPropertySection_LineWidth + " " + VALUE_CHANGED_STRING;
    protected static final String LINE_TYPE_COMMAND_NAME = DiagramUIPropertiesMessages.LineStylesPropertySection_LineType + " " + VALUE_CHANGED_STRING;
    protected static final String ARROW_TYPE_COMMAND_NAME = DiagramUIPropertiesMessages.LineStylesPropertySection_ArrowType + " " + VALUE_CHANGED_STRING;
    protected static final String SOURCE_ARROW_TYPE_COMMAND_NAME = DiagramUIPropertiesMessages.LineStylesPropertySection_SourceArrow_Type + " " + VALUE_CHANGED_STRING;
    protected static final String TARGET_ARROW_TYPE_COMMAND_NAME = DiagramUIPropertiesMessages.LineStylesPropertySection_TargetArrow_Type + " " + VALUE_CHANGED_STRING;
    protected Group lineStylesGroup;
    protected Button lineWidthButton;
    protected Button lineTypeButton;
    protected Button arrowTypeButton;

    @Override
    protected void initializeControls(Composite parent) {
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        FormLayout layout = (FormLayout)this.composite.getLayout();
        layout.spacing = 3;
        Composite groups = this.getWidgetFactory().createComposite(this.composite);
        groups.setLayout((Layout)new GridLayout(2, false));
        this.createFontsAndColorsGroups(groups);
        this.colorsAndFontsGroup.setLayoutData((Object)new GridData(2));
        this.createLineStylesGroup(groups);
        this.lineStylesGroup.setLayoutData((Object)new GridData(2));
    }

    protected void createLineStylesGroup(Composite parent) {
        this.lineStylesGroup = this.getWidgetFactory().createGroup(parent, DiagramUIPropertiesMessages.LineStylesPropertySection_LineStyles);
        GridLayout layout = new GridLayout(3, false);
        this.lineStylesGroup.setLayout((Layout)layout);
        this.lineWidthButton = new Button((Composite)this.lineStylesGroup, 8);
        this.lineWidthButton.setImage(DiagramUIPropertiesImages.get("icons/line_width.gif"));
        this.lineWidthButton.setToolTipText(DiagramUIPropertiesMessages.LineStylesPropertySection_LineWidth);
        this.lineWidthButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = DiagramUIPropertiesMessages.LineStylesPropertySection_LineWidth;
            }
        });
        this.lineWidthButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColoursAndFontsAndLineStylesPropertySection.this.changeLineWidth(ColoursAndFontsAndLineStylesPropertySection.this.lineWidthButton);
            }
        });
        this.lineTypeButton = new Button((Composite)this.lineStylesGroup, 8);
        this.lineTypeButton.setImage(DiagramUIPropertiesImages.get("icons/line_type.gif"));
        this.lineTypeButton.setToolTipText(DiagramUIPropertiesMessages.LineStylesPropertySection_LineType);
        this.lineTypeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColoursAndFontsAndLineStylesPropertySection.this.changeLineType(ColoursAndFontsAndLineStylesPropertySection.this.lineTypeButton);
            }
        });
        this.lineTypeButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = DiagramUIPropertiesMessages.LineStylesPropertySection_LineType;
            }
        });
        this.arrowTypeButton = new Button((Composite)this.lineStylesGroup, 8);
        this.arrowTypeButton.setImage(DiagramUIPropertiesImages.get("icons/arrow_type.gif"));
        this.arrowTypeButton.setToolTipText(DiagramUIPropertiesMessages.LineStylesPropertySection_ArrowType);
        this.arrowTypeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColoursAndFontsAndLineStylesPropertySection.this.changeArrowType(ColoursAndFontsAndLineStylesPropertySection.this.arrowTypeButton);
            }
        });
        this.arrowTypeButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = DiagramUIPropertiesMessages.LineStylesPropertySection_ArrowType;
            }
        });
    }

    protected void changeArrowType(Button button) {
        ArrowTypePopup popup = new ArrowTypePopup(button.getParent().getShell());
        Rectangle r = button.getBounds();
        Point location = button.getParent().toDisplay(r.x, r.y);
        popup.open(new Point(location.x, location.y + r.height));
        if (popup.getSelectedArrowTypeSource() == null) {
            return;
        }
        final ArrowType selectedArrowTypeSource = popup.getSelectedArrowTypeSource();
        final EStructuralFeature arrowTypeSourceFeature = (EStructuralFeature)PackageUtil.getElement((String)Properties.ID_ARROW_SOURCE);
        final ArrowType selectedArrowTypeTarget = popup.getSelectedArrowTypeTarget();
        final EStructuralFeature arrowTypeTargetFeature = (EStructuralFeature)PackageUtil.getElement((String)Properties.ID_ARROW_TARGET);
        ArrayList<ICommand> commands = new ArrayList<ICommand>();
        for (final IGraphicalEditPart ep : this.getInput()) {
            commands.add(this.createCommand(SOURCE_ARROW_TYPE_COMMAND_NAME, ((View)ep.getModel()).eResource(), new Runnable(){

                @Override
                public void run() {
                    ENamedElement element = PackageUtil.getElement((String)Properties.ID_ARROW_SOURCE);
                    if (element instanceof EStructuralFeature) {
                        ep.setStructuralFeatureValue(arrowTypeSourceFeature, (Object)selectedArrowTypeSource);
                    }
                }
            }));
            commands.add(this.createCommand(TARGET_ARROW_TYPE_COMMAND_NAME, ((View)ep.getModel()).eResource(), new Runnable(){

                @Override
                public void run() {
                    ENamedElement element = PackageUtil.getElement((String)Properties.ID_ARROW_TARGET);
                    if (element instanceof EStructuralFeature) {
                        ep.setStructuralFeatureValue(arrowTypeTargetFeature, (Object)selectedArrowTypeTarget);
                    }
                }
            }));
        }
        if (!commands.isEmpty()) {
            this.executeAsCompositeCommand(ARROW_TYPE_COMMAND_NAME, commands);
        }
    }

    protected void changeLineType(Button button) {
        LineTypePopup popup = new LineTypePopup(button.getParent().getShell());
        Rectangle r = button.getBounds();
        Point location = button.getParent().toDisplay(r.x, r.y);
        popup.open(new Point(location.x, location.y + r.height));
        if (popup.getSelectedLineType() == null) {
            return;
        }
        final LineType selectedLineType = popup.getSelectedLineType();
        final EStructuralFeature feature = (EStructuralFeature)PackageUtil.getElement((String)Properties.ID_LINE_TYPE);
        ArrayList<ICommand> commands = new ArrayList<ICommand>();
        for (final IGraphicalEditPart ep : this.getInput()) {
            commands.add(this.createCommand(LINE_TYPE_COMMAND_NAME, ((View)ep.getModel()).eResource(), new Runnable(){

                @Override
                public void run() {
                    ENamedElement element = PackageUtil.getElement((String)Properties.ID_LINE_TYPE);
                    if (element instanceof EStructuralFeature) {
                        ep.setStructuralFeatureValue(feature, (Object)selectedLineType);
                    }
                }
            }));
        }
        if (!commands.isEmpty()) {
            this.executeAsCompositeCommand(LINE_TYPE_COMMAND_NAME, commands);
        }
    }

    protected void changeLineWidth(Button button) {
        LineWidthPopup popup = new LineWidthPopup(button.getParent().getShell());
        Rectangle r = button.getBounds();
        Point location = button.getParent().toDisplay(r.x, r.y);
        popup.open(new Point(location.x, location.y + r.height));
        if (popup.getSelectedLineWidth() == -1) {
            return;
        }
        final int selectedLineWidth = popup.getSelectedLineWidth();
        final EStructuralFeature feature = (EStructuralFeature)PackageUtil.getElement((String)Properties.ID_LINE_WIDTH);
        ArrayList<ICommand> commands = new ArrayList<ICommand>();
        for (final IGraphicalEditPart ep : this.getInput()) {
            commands.add(this.createCommand(LINE_WIDTH_COMMAND_NAME, ((View)ep.getModel()).eResource(), new Runnable(){

                @Override
                public void run() {
                    ENamedElement element = PackageUtil.getElement((String)Properties.ID_LINE_WIDTH);
                    if (element instanceof EStructuralFeature) {
                        ep.setStructuralFeatureValue(feature, (Object)selectedLineWidth);
                    }
                }
            }));
        }
        if (!commands.isEmpty()) {
            this.executeAsCompositeCommand(LINE_WIDTH_COMMAND_NAME, commands);
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        if (!this.isDisposed()) {
            this.executeAsReadAction(new Runnable(){

                @Override
                public void run() {
                    IGraphicalEditPart graphicalEditPart = ColoursAndFontsAndLineStylesPropertySection.this.getSingleInput();
                    if (graphicalEditPart != null) {
                        boolean isReadOnly = ColoursAndFontsAndLineStylesPropertySection.this.isReadOnly();
                        LineStyle lineStyle = (LineStyle)graphicalEditPart.getNotationView().getStyle(NotationPackage.eINSTANCE.getLineStyle());
                        boolean enableLineWidth = lineStyle != null && !isReadOnly && lineStyle.getLineWidth() != -1;
                        ColoursAndFontsAndLineStylesPropertySection.this.lineWidthButton.setEnabled(enableLineWidth);
                        Style lineTypeStyle = graphicalEditPart.getNotationView().getStyle(NotationPackage.eINSTANCE.getLineTypeStyle());
                        boolean enableLineType = lineTypeStyle != null && !isReadOnly;
                        ColoursAndFontsAndLineStylesPropertySection.this.lineTypeButton.setEnabled(enableLineType);
                        Style arrowTypeStyle = graphicalEditPart.getNotationView().getStyle(NotationPackage.eINSTANCE.getArrowStyle());
                        boolean enableArrowType = arrowTypeStyle != null && !isReadOnly;
                        ColoursAndFontsAndLineStylesPropertySection.this.arrowTypeButton.setEnabled(enableArrowType);
                    }
                }
            });
        }
    }
}

