/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.operations;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import javafx.scene.Node;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.parts.IContentPart;

public class AttachToContentAnchorageOperation
extends AbstractOperation
implements ITransactionalOperation {
    private final IContentPart<? extends Node> anchored;
    private final Object contentAnchorage;
    private final String role;
    private SetMultimap<Object, String> initialContentAnchorages;

    public AttachToContentAnchorageOperation(IContentPart<? extends Node> anchored, Object contentAnchorage, String role) {
        super("Attach To Content Anchorage");
        this.anchored = anchored;
        this.contentAnchorage = contentAnchorage;
        this.initialContentAnchorages = ImmutableSetMultimap.copyOf(anchored.getContentAnchoragesUnmodifiable());
        this.role = role;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.anchored.getContent() != null && !this.anchored.getContentAnchoragesUnmodifiable().containsEntry(this.contentAnchorage, (Object)this.role)) {
            this.anchored.attachToContentAnchorage(this.contentAnchorage, this.role);
        }
        return Status.OK_STATUS;
    }

    @Override
    public boolean isContentRelevant() {
        return true;
    }

    @Override
    public boolean isNoOp() {
        return this.initialContentAnchorages.containsEntry(this.contentAnchorage, (Object)this.role);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.anchored.getContent() != null && this.anchored.getContentAnchoragesUnmodifiable().containsEntry(this.contentAnchorage, (Object)this.role)) {
            this.anchored.detachFromContentAnchorage(this.contentAnchorage, this.role);
        }
        return Status.OK_STATUS;
    }
}

