/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.transforms;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.equinox.internal.transforms.CSVParser;
import org.eclipse.equinox.internal.transforms.TransformTuple;
import org.eclipse.osgi.internal.log.EquinoxLogServices;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class TransformInstanceListData
extends ServiceTracker<URL, URL> {
    private static final String[] EMPTY_TYPES = new String[0];
    private volatile boolean stale = true;
    private Map<String, TransformTuple[]> transformerToTuple = new HashMap<String, TransformTuple[]>();
    private List<TransformTuple> rawTuples = new ArrayList<TransformTuple>();
    private Map<String, Boolean> bundleIdToTransformPresence = new HashMap<String, Boolean>();
    private final EquinoxLogServices logServices;

    public TransformInstanceListData(BundleContext context, EquinoxLogServices logServices) throws InvalidSyntaxException {
        super(context, context.createFilter("(&(objectClass=" + URL.class.getName() + ")(equinox.transformerType=*))"), null);
        this.logServices = logServices;
        this.open();
    }

    public synchronized String[] getTransformTypes() {
        if (this.stale) {
            this.rebuildTransformMap();
        }
        if (this.transformerToTuple.size() == 0) {
            return EMPTY_TYPES;
        }
        return this.transformerToTuple.keySet().toArray(new String[this.transformerToTuple.size()]);
    }

    public synchronized TransformTuple[] getTransformsFor(String type) {
        if (this.stale) {
            this.rebuildTransformMap();
        }
        return this.transformerToTuple.get(type);
    }

    public synchronized boolean hasTransformsFor(Bundle bundle) {
        String bundleName;
        Boolean hasTransformsFor;
        if (this.stale) {
            this.rebuildTransformMap();
        }
        if ((hasTransformsFor = this.bundleIdToTransformPresence.get(bundleName = bundle.getSymbolicName())) == null) {
            hasTransformsFor = Boolean.FALSE;
            for (TransformTuple tuple : this.rawTuples) {
                if (!tuple.bundlePattern.matcher(bundleName).matches()) continue;
                hasTransformsFor = Boolean.TRUE;
            }
            this.bundleIdToTransformPresence.put(bundleName, hasTransformsFor);
        }
        return hasTransformsFor;
    }

    private void rebuildTransformMap() {
        this.transformerToTuple.clear();
        this.rawTuples.clear();
        this.bundleIdToTransformPresence.clear();
        ServiceReference[] serviceReferences = this.getServiceReferences();
        this.stale = false;
        if (serviceReferences == null) {
            return;
        }
        ServiceReference[] serviceReferenceArray = serviceReferences;
        int n = serviceReferences.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference serviceReference = serviceReferenceArray[n2];
            String type = serviceReference.getProperty("equinox.transformerType").toString();
            URL url = (URL)this.getService(serviceReference);
            try {
                TransformTuple[] transforms = CSVParser.parse(url, this.logServices);
                TransformTuple[] existing = this.transformerToTuple.get(type);
                if (existing != null) {
                    TransformTuple[] newTransforms = new TransformTuple[existing.length + transforms.length];
                    System.arraycopy(existing, 0, newTransforms, 0, existing.length);
                    System.arraycopy(transforms, 0, newTransforms, existing.length, transforms.length);
                    this.transformerToTuple.put(type, newTransforms);
                } else {
                    this.transformerToTuple.put(type, transforms);
                }
                TransformTuple[] transformTupleArray = transforms;
                int n3 = transforms.length;
                int n4 = 0;
                while (n4 < n3) {
                    TransformTuple transform = transformTupleArray[n4];
                    this.rawTuples.add(transform);
                    ++n4;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public URL addingService(ServiceReference<URL> reference) {
        try {
            URL uRL = (URL)super.addingService(reference);
            return uRL;
        }
        finally {
            this.stale = true;
        }
    }

    public void modifiedService(ServiceReference<URL> reference, URL service) {
        super.modifiedService(reference, (Object)service);
        this.stale = true;
    }

    public void removedService(ServiceReference<URL> reference, URL service) {
        super.removedService(reference, (Object)service);
        this.stale = true;
    }
}

