/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoManager;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.lob.CDOLobStore;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.protocol.CDOProtocolConstants;
import org.eclipse.emf.cdo.common.revision.CDOListFactory;
import org.eclipse.emf.cdo.common.revision.CDORevisionFactory;
import org.eclipse.emf.cdo.internal.common.revision.CDOListImpl;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.protocol.CDODataInputImpl;
import org.eclipse.emf.cdo.spi.common.protocol.CDODataOutputImpl;
import org.eclipse.emf.cdo.spi.common.revision.CDORevisionUnchunker;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalStore;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.net4j.signal.IndicationWithMonitoring;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.io.StringIO;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public abstract class CDOServerIndicationWithMonitoring
extends IndicationWithMonitoring {
    private ExtendedDataInputStream indicationStream;
    private ExtendedDataOutputStream responseStream;

    protected CDOServerIndicationWithMonitoring(CDOServerProtocol protocol, short signalID) {
        super((SignalProtocol)protocol, signalID);
    }

    public CDOServerProtocol getProtocol() {
        return (CDOServerProtocol)super.getProtocol();
    }

    protected ExtendedDataInputStream getIndicationStream() {
        return this.indicationStream;
    }

    protected ExtendedDataOutputStream getResponseStream() {
        return this.responseStream;
    }

    protected InternalSession getSession() {
        return this.getProtocol().getSession();
    }

    protected InternalCDOPackageRegistry getPackageRegistry() {
        return this.getRepository().getPackageRegistry(false);
    }

    protected InternalRepository getRepository() {
        InternalRepository repository = this.getSession().getRepository();
        if (!LifecycleUtil.isActive((Object)repository)) {
            throw new IllegalStateException("CDORepositoryInfo has been deactivated");
        }
        return repository;
    }

    protected IStore getStore() {
        InternalStore store = this.getRepository().getStore();
        if (!LifecycleUtil.isActive((Object)store)) {
            throw new IllegalStateException("Store has been deactivated");
        }
        return store;
    }

    protected InternalView getView(int viewID) {
        InternalSession session = this.getSession();
        return session.getView(viewID);
    }

    protected final void indicating(ExtendedDataInputStream in, OMMonitor monitor) throws Exception {
        this.indicationStream = in;
        try {
            this.indicating((CDODataInput)new CDODataInputImpl((ExtendedDataInput)in){

                public CDOPackageRegistry getPackageRegistry() {
                    return CDOServerIndicationWithMonitoring.this.getPackageRegistry();
                }

                protected boolean isXCompression() {
                    return CDOProtocolConstants.X_COMPRESSION;
                }

                protected StringIO getPackageURICompressor() {
                    return CDOServerIndicationWithMonitoring.this.getProtocol().getPackageURICompressor();
                }

                protected CDOBranchManager getBranchManager() {
                    return CDOServerIndicationWithMonitoring.this.getRepository().getBranchManager();
                }

                protected CDOCommitInfoManager getCommitInfoManager() {
                    return CDOServerIndicationWithMonitoring.this.getRepository().getCommitInfoManager();
                }

                protected CDORevisionFactory getRevisionFactory() {
                    return CDOServerIndicationWithMonitoring.this.getRepository().getRevisionManager().getFactory();
                }

                protected CDOLobStore getLobStore() {
                    return null;
                }

                protected CDOListFactory getListFactory() {
                    return CDOListImpl.FACTORY;
                }
            }, monitor);
        }
        catch (Exception ex) {
            this.indicatingFailed();
            throw ex;
        }
        catch (Error ex) {
            this.indicatingFailed();
            throw ex;
        }
    }

    protected final void responding(ExtendedDataOutputStream out, OMMonitor monitor) throws Exception {
        this.responseStream = out;
        this.responding((CDODataOutput)new CDODataOutputImpl((ExtendedDataOutput)out){

            public CDOPackageRegistry getPackageRegistry() {
                return CDOServerIndicationWithMonitoring.this.getPackageRegistry();
            }

            public CDORevisionUnchunker getRevisionUnchunker() {
                return CDOServerIndicationWithMonitoring.this.getRepository();
            }

            public CDOIDProvider getIDProvider() {
                return CDOServerIndicationWithMonitoring.this.getSession();
            }

            protected boolean isXCompression() {
                return CDOProtocolConstants.X_COMPRESSION;
            }

            protected StringIO getPackageURICompressor() {
                return CDOServerIndicationWithMonitoring.this.getProtocol().getPackageURICompressor();
            }
        }, monitor);
    }

    protected void indicatingFailed() {
    }

    protected abstract void indicating(CDODataInput var1, OMMonitor var2) throws Exception;

    protected abstract void responding(CDODataOutput var1, OMMonitor var2) throws Exception;
}

