/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.preferences.PersistentModel;
import org.eclipse.buildship.core.internal.workspace.ManagedModelMergingStrategy;
import org.eclipse.buildship.core.internal.workspace.PersistentModelBuilder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.gradle.tooling.model.eclipse.EclipseProjectNature;

final class ProjectNatureUpdater {
    private ProjectNatureUpdater() {
    }

    public static void update(IProject project, List<EclipseProjectNature> projectNatures, PersistentModelBuilder persistentModel, IProgressMonitor monitor) throws CoreException {
        PersistentModel previousPersistentModel = persistentModel.getPrevious();
        LinkedHashSet managedNatures = previousPersistentModel.isPresent() ? Sets.newLinkedHashSet(previousPersistentModel.getManagedNatures()) : Sets.newLinkedHashSet();
        Set<String> modelNatures = ProjectNatureUpdater.toNatures(projectNatures);
        IProjectDescription description = project.getDescription();
        LinkedHashSet existingNatures = Sets.newLinkedHashSet(Arrays.asList(description.getNatureIds()));
        ManagedModelMergingStrategy.Result<String> result = ManagedModelMergingStrategy.calculate(existingNatures, modelNatures, managedNatures);
        description.setNatureIds(result.getNextElements().toArray(new String[0]));
        project.setDescription(description, monitor);
        persistentModel.managedNatures(result.getNextManaged());
    }

    private static Set<String> toNatures(List<EclipseProjectNature> projectNatures) {
        LinkedHashSet natures = Sets.newLinkedHashSet();
        for (EclipseProjectNature projectNature : projectNatures) {
            String natureId = projectNature.getId();
            if (!CorePlugin.workspaceOperations().isNatureRecognizedByEclipse(natureId)) continue;
            natures.add(natureId);
        }
        natures.add("org.eclipse.buildship.core.gradleprojectnature");
        return natures;
    }
}

