/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.widgets.internal;

import java.util.List;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.IFigure;

public class ZestRootLayer
extends FreeformLayer {
    public static final boolean EDGES_ON_TOP = false;
    private int numberOfNodes = 0;
    private int numberOfConnections = 0;
    private int numberOfHighlightedNodes = 0;
    private int numberOfHighlightedConnections = 0;

    public void addNode(IFigure nodeFigure) {
        int nodePosition = this.getNodePosition();
        ++this.numberOfNodes;
        this.add(nodeFigure, nodePosition);
    }

    public void removeNode(IFigure nodeFigure) {
        if (!this.getChildren().contains(nodeFigure)) {
            throw new RuntimeException("Node not contained on the ZestRootLayer");
        }
        int nodePosition = this.getChildren().indexOf(nodeFigure);
        if (nodePosition > this.getHighlightNodeStartPosition()) {
            --this.numberOfHighlightedNodes;
        } else {
            --this.numberOfNodes;
        }
        this.remove(nodeFigure);
    }

    public void removeConnection(IFigure connectionFigure) {
        int connectionPosition = this.getChildren().indexOf(connectionFigure);
        if (connectionPosition > this.getHighlightConnectionStartPosition()) {
            --this.numberOfHighlightedConnections;
        } else {
            --this.numberOfConnections;
        }
        this.remove(connectionFigure);
    }

    public void addConnection(IFigure connectionFigure) {
        int connectionPosition = this.getConnectionPosition();
        ++this.numberOfConnections;
        this.add(connectionFigure, connectionPosition);
    }

    public void highlightNode(IFigure nodeFigure) {
        --this.numberOfNodes;
        int highlightNodePosition = this.getHighlightNodePosition();
        ++this.numberOfHighlightedNodes;
        this.getChildren().remove(nodeFigure);
        this.getChildren().add(highlightNodePosition, nodeFigure);
        this.invalidate();
        this.repaint();
    }

    public void highlightConnection(IFigure connectionFigure) {
        --this.numberOfConnections;
        int highlightConnectionPosition = this.getHighlightConnectionPosition();
        ++this.numberOfHighlightedConnections;
        this.getChildren().remove(connectionFigure);
        this.getChildren().add(highlightConnectionPosition, connectionFigure);
        this.invalidate();
        this.repaint();
    }

    public void unHighlightNode(IFigure nodeFigure) {
        int nodePosition = this.getChildren().indexOf(nodeFigure);
        if (nodePosition < 0 || nodePosition > this.getHighlightNodePosition()) {
            return;
        }
        --this.numberOfHighlightedNodes;
        nodePosition = this.getNodePosition();
        ++this.numberOfNodes;
        this.getChildren().remove(nodeFigure);
        this.getChildren().add(nodePosition, nodeFigure);
        this.invalidate();
        this.repaint();
    }

    public void unHighlightConnection(IFigure connectionFigure) {
        int connectionPosition = this.getChildren().indexOf(connectionFigure);
        if (connectionPosition < 0 || connectionPosition > this.getHighlightConnectionPosition()) {
            return;
        }
        --this.numberOfHighlightedConnections;
        ++this.numberOfConnections;
        connectionPosition = this.getConnectionPosition();
        List children = this.getChildren();
        children.remove(connectionFigure);
        if (connectionPosition > this.getChildren().size()) {
            children.add(connectionFigure);
        } else {
            children.add(connectionPosition, connectionFigure);
        }
        this.invalidate();
        this.repaint();
    }

    private int getNodePosition() {
        return this.numberOfConnections + this.numberOfNodes;
    }

    private int getConnectionPosition() {
        return 0 + this.numberOfConnections;
    }

    private int getHighlightNodePosition() {
        return this.numberOfConnections + this.numberOfHighlightedConnections + this.numberOfNodes + this.numberOfHighlightedNodes;
    }

    private int getHighlightConnectionPosition() {
        return this.numberOfConnections + this.numberOfNodes + this.numberOfHighlightedConnections;
    }

    private int getHighlightConnectionStartPosition() {
        return this.numberOfConnections + this.numberOfNodes;
    }

    private int getHighlightNodeStartPosition() {
        return this.numberOfConnections + this.numberOfHighlightedConnections + this.numberOfNodes;
    }
}

