import { type LanguagePlugin } from '@volar/language-core';
import type * as ts from 'typescript';
import type { VueCompilerOptions, VueLanguagePlugin } from './types';
import { VueVirtualCode } from './virtualFile/vueFile';
export interface _Plugin extends LanguagePlugin<VueVirtualCode> {
    getCanonicalFileName: (fileName: string) => string;
    pluginContext: Parameters<VueLanguagePlugin>[0];
}
export declare function createVueLanguagePlugin(ts: typeof import('typescript'), getFileName: (scriptId: string) => string, useCaseSensitiveFileNames: boolean, getProjectVersion: () => string, getScriptFileNames: () => string[] | Set<string>, compilerOptions: ts.CompilerOptions, vueCompilerOptions: VueCompilerOptions): _Plugin;
