import { LanguagePlugin, ProviderResult, ServiceEnvironment, TypeScriptProjectHost } from '@volar/language-service';
import { createSys } from '@volar/typescript';
import type * as ts from 'typescript';
import type { ServerBase, ServerProject } from '../types';
import { UriMap } from '../utils/uriMap';
export interface TypeScriptServerProject extends ServerProject {
    askedFiles: UriMap<boolean>;
    tryAddFile(fileName: string): void;
    getParsedCommandLine(): ts.ParsedCommandLine;
}
export declare function createTypeScriptServerProject(ts: typeof import('typescript'), tsLocalized: ts.MapLike<string> | undefined, tsconfig: string | ts.CompilerOptions, server: ServerBase, serviceEnv: ServiceEnvironment, getLanguagePlugins: (serviceEnv: ServiceEnvironment, projectContext: {
    configFileName: string | undefined;
    host: TypeScriptProjectHost;
    sys: ReturnType<typeof createSys>;
}) => ProviderResult<LanguagePlugin[]>): Promise<TypeScriptServerProject>;
