/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.layout;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.JavaInfoSetObjectAfter;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.core.model.broadcast.ObjectInfoChildAddBefore;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.clipboard.IClipboardImplicitCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.IImplicitCreationSupport;
import org.eclipse.wb.internal.core.model.util.TemplateUtils;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.utils.GenericsUtils;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swt.model.layout.ImplicitLayoutVariableSupport;
import org.eclipse.wb.internal.swt.model.layout.LayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.support.ContainerSupport;

public final class ImplicitLayoutCreationSupport
extends CreationSupport
implements IImplicitCreationSupport {
    private final CompositeInfo m_composite;
    private final ObjectInfoChildAddBefore m_objectListener1 = new ObjectInfoChildAddBefore(){

        public void invoke(ObjectInfo parent, ObjectInfo child, ObjectInfo[] nextChild) throws Exception {
            if (this.isAddLayout(parent, child) && parent.getChildren().contains(ImplicitLayoutCreationSupport.this.m_javaInfo)) {
                if (nextChild[0] == ImplicitLayoutCreationSupport.this.m_javaInfo) {
                    nextChild[0] = (ObjectInfo)GenericsUtils.getNextOrNull((List)parent.getChildren(), (Object)ImplicitLayoutCreationSupport.this.m_javaInfo);
                }
                parent.removeChild((ObjectInfo)ImplicitLayoutCreationSupport.this.m_javaInfo);
            }
        }

        private boolean isAddLayout(ObjectInfo parent, ObjectInfo child) {
            return parent == ImplicitLayoutCreationSupport.this.m_composite && child instanceof LayoutInfo && child != ImplicitLayoutCreationSupport.this.m_javaInfo;
        }
    };
    private final ObjectEventListener m_objectListener2 = new ObjectEventListener(){

        public void childRemoveAfter(ObjectInfo parent, ObjectInfo child) throws Exception {
            if (this.useImplicitLayout() && this.isAddLayout(parent, child)) {
                parent.addChild((ObjectInfo)ImplicitLayoutCreationSupport.this.m_javaInfo);
            }
        }

        private boolean useImplicitLayout() {
            return ImplicitLayoutCreationSupport.this.m_composite.getArbitraryValue("KEY_DONT_SET_IMPLICIT_LAYOUT") != Boolean.TRUE;
        }

        private boolean isAddLayout(ObjectInfo parent, ObjectInfo child) {
            return parent == ImplicitLayoutCreationSupport.this.m_composite && child instanceof LayoutInfo && child != ImplicitLayoutCreationSupport.this.m_javaInfo;
        }
    };
    private final Object m_javaListener = new JavaInfoSetObjectAfter(){

        public void invoke(JavaInfo target, Object object) throws Exception {
            if (target == ImplicitLayoutCreationSupport.this.m_composite) {
                Object layout = ContainerSupport.getLayout(object);
                Class layoutClass = ImplicitLayoutCreationSupport.this.m_javaInfo.getDescription().getComponentClass();
                if (layoutClass == null) {
                    ImplicitLayoutCreationSupport.this.m_javaInfo.setObject(layout);
                } else if (layout != null && ReflectionUtils.isAssignableFrom((Class)layoutClass, (Object)layout)) {
                    ImplicitLayoutCreationSupport.this.m_javaInfo.setObject(layout);
                }
            }
        }
    };

    public ImplicitLayoutCreationSupport(CompositeInfo composite) {
        this.m_composite = composite;
        this.m_composite.addBroadcastListener(this.m_objectListener1);
        this.m_composite.addBroadcastListener(this.m_objectListener2);
    }

    public String toString() {
        Class layoutClass = this.getComponentClass();
        if (layoutClass == null) {
            return "implicit-layout: absolute";
        }
        return "implicit-layout: " + layoutClass.getName();
    }

    public void setJavaInfo(JavaInfo javaInfo) throws Exception {
        super.setJavaInfo(javaInfo);
        this.m_composite.addBroadcastListener(this.m_javaListener);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isJavaInfo(ASTNode node) {
        ASTNode aSTNode = node;
        if (aSTNode instanceof MethodInvocation) {
            void invocation;
            MethodInvocation methodInvocation = (MethodInvocation)aSTNode;
            MethodInvocation cfr_ignored_0 = (MethodInvocation)aSTNode;
            return invocation.arguments().isEmpty() && invocation.getName().getIdentifier().equals("getLayout") && this.m_composite.isRepresentedBy((ASTNode)invocation.getExpression());
        }
        return false;
    }

    public ASTNode getNode() {
        return this.m_composite.getCreationSupport().getNode();
    }

    public void removeForever() throws Exception {
        this.m_composite.removeBroadcastListener(this.m_objectListener1);
        this.m_composite.removeBroadcastListener(this.m_objectListener2);
        this.m_composite.removeBroadcastListener(this.m_javaListener);
        this.m_composite.removeChild((ObjectInfo)this.m_javaInfo);
    }

    public String add_getSource(NodeTarget target) throws Exception {
        String layoutClassName = this.m_javaInfo.getDescription().getComponentClass().getName();
        return TemplateUtils.format((String)"({0}) {1}.getLayout()", (Object[])new Object[]{layoutClassName, this.m_composite});
    }

    public void add_setSourceExpression(Expression expression) throws Exception {
    }

    public boolean canDelete() {
        return true;
    }

    public void delete() throws Exception {
        JavaInfoUtils.deleteJavaInfo((JavaInfo)this.m_javaInfo, (boolean)false);
        if (!(this.m_javaInfo.getVariableSupport() instanceof ImplicitLayoutVariableSupport)) {
            this.m_javaInfo.setVariableSupport((VariableSupport)new ImplicitLayoutVariableSupport(this.m_javaInfo));
        }
    }

    public IClipboardImplicitCreationSupport getImplicitClipboard() {
        return null;
    }
}

