/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.single;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.util.Clearable;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.matchers.util.Signed;
import org.eclipse.viatra.query.runtime.matchers.util.TimelyMemory;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Diff;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Timeline;
import org.eclipse.viatra.query.runtime.rete.index.ProjectionIndexer;
import org.eclipse.viatra.query.runtime.rete.index.timely.TimelyMemoryIdentityIndexer;
import org.eclipse.viatra.query.runtime.rete.index.timely.TimelyMemoryNullIndexer;
import org.eclipse.viatra.query.runtime.rete.matcher.TimelyConfiguration;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.communication.CommunicationGroup;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;
import org.eclipse.viatra.query.runtime.rete.network.communication.timely.ResumableNode;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.Mailbox;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.timely.TimelyMailbox;
import org.eclipse.viatra.query.runtime.rete.single.AbstractUniquenessEnforcerNode;

public class TimelyUniquenessEnforcerNode
extends AbstractUniquenessEnforcerNode
implements ResumableNode {
    protected final TimelyMemory<Timestamp> memory;
    protected CommunicationGroup group;

    public TimelyUniquenessEnforcerNode(ReteContainer container, int tupleWidth) {
        super(container, tupleWidth);
        this.memory = new TimelyMemory(container.getTimelyConfiguration().getTimelineRepresentation() == TimelyConfiguration.TimelineRepresentation.FAITHFUL);
        container.registerClearable((Clearable)this.memory);
        this.mailbox = this.instantiateMailbox();
        container.registerClearable(this.mailbox);
    }

    @Override
    protected Mailbox instantiateMailbox() {
        return new TimelyMailbox(this, this.reteContainer);
    }

    @Override
    public void pullInto(Collection<Tuple> collector, boolean flush) {
        for (Tuple tuple : this.memory.getTuplesAtInfinity()) {
            collector.add(tuple);
        }
    }

    @Override
    public CommunicationGroup getCurrentGroup() {
        return this.group;
    }

    @Override
    public void setCurrentGroup(CommunicationGroup group) {
        this.group = group;
    }

    @Override
    public Set<Tuple> getTuples() {
        return this.memory.getTuplesAtInfinity();
    }

    @Override
    public Timestamp getResumableTimestamp() {
        return (Timestamp)this.memory.getResumableTimestamp();
    }

    @Override
    public void resumeAt(Timestamp timestamp) {
        Map diffMap = this.memory.resumeAt((Comparable)timestamp);
        for (Map.Entry entry : diffMap.entrySet()) {
            for (Signed signed : (Diff)entry.getValue()) {
                this.propagate(signed.getDirection(), (Tuple)entry.getKey(), (Timestamp)signed.getPayload());
            }
        }
        Timestamp nextTimestamp = (Timestamp)this.memory.getResumableTimestamp();
        if (nextTimestamp != null) {
            this.group.notifyHasMessage(this.mailbox, nextTimestamp);
        }
    }

    @Override
    public void update(Direction direction, Tuple update, Timestamp timestamp) {
        Diff resultDiff = null;
        if (direction == Direction.INSERT) {
            resultDiff = this.memory.put(update, (Comparable)timestamp);
        } else {
            try {
                resultDiff = this.memory.remove(update, (Comparable)timestamp);
            }
            catch (IllegalStateException e) {
                this.issueError("[INTERNAL ERROR] Duplicate deletion of " + update + " was detected in " + this.getClass().getName() + " " + this + " for pattern(s) " + this.getTraceInfoPatternsEnumerated(), e);
                return;
            }
        }
        for (Signed signed : resultDiff) {
            this.propagate(signed.getDirection(), update, (Timestamp)signed.getPayload());
        }
    }

    @Override
    public void pullIntoWithTimeline(Map<Tuple, Timeline<Timestamp>> collector, boolean flush) {
        collector.putAll(this.memory.asMap());
    }

    @Override
    public ProjectionIndexer getNullIndexer() {
        if (this.memoryNullIndexer == null) {
            this.memoryNullIndexer = new TimelyMemoryNullIndexer(this.reteContainer, this.tupleWidth, this.memory, this, this, this.specializedListeners);
            this.getCommunicationTracker().registerDependency(this, this.memoryNullIndexer);
        }
        return this.memoryNullIndexer;
    }

    @Override
    public ProjectionIndexer getIdentityIndexer() {
        if (this.memoryIdentityIndexer == null) {
            this.memoryIdentityIndexer = new TimelyMemoryIdentityIndexer(this.reteContainer, this.tupleWidth, this.memory, this, this, this.specializedListeners);
            this.getCommunicationTracker().registerDependency(this, this.memoryIdentityIndexer);
        }
        return this.memoryIdentityIndexer;
    }

    @Override
    public void networkStructureChanged() {
        super.networkStructureChanged();
    }
}

