/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.edit.internal.part.layoutmanager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramContainerEditPart;
import org.eclipse.sirius.diagram.ui.tools.internal.util.EditPartQuery;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.SiriusWrapLabel;

public class RegionContainerConstrainedToolbarLayout
extends ConstrainedToolbarLayout {
    private AbstractDiagramContainerEditPart diagramContainerEditPart;

    public RegionContainerConstrainedToolbarLayout(AbstractDiagramContainerEditPart diagramContainerEditPart) {
        this.diagramContainerEditPart = diagramContainerEditPart;
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        List<IFigure> children;
        Insets insets = container.getInsets();
        if (!container.isVisible()) {
            return new Dimension(insets.getWidth(), insets.getHeight());
        }
        if (this.isHorizontal()) {
            wHint = -1;
            if (hHint >= 0) {
                hHint = Math.max(0, hHint - insets.getHeight());
            }
        } else {
            hHint = -1;
            if (wHint >= 0) {
                wHint = Math.max(0, wHint - insets.getWidth());
            }
        }
        List<Object> childrenToConsider = children = this.getChildren(container);
        Dimension prefSize = null;
        if (new EditPartQuery(this.diagramContainerEditPart).isAutoSized(true, false)) {
            prefSize = this.calculateChildrenSize(children, wHint, hHint, true);
        } else {
            childrenToConsider = this.getChildren(container).stream().filter(figure -> !(figure instanceof SiriusWrapLabel)).collect(Collectors.toList());
            prefSize = this.calculateChildrenSize(childrenToConsider, wHint, hHint, true);
            prefSize = this.calculateChildrenSize(children, prefSize.width, hHint, true);
        }
        if (wHint >= 0 && prefSize.width > wHint) {
            prefSize = this.calculateChildrenSize(childrenToConsider, prefSize.width, hHint, true);
        } else if (hHint >= 0 && prefSize.height > hHint) {
            prefSize = this.calculateChildrenSize(childrenToConsider, wHint, prefSize.height, true);
        }
        prefSize.setHeight(prefSize.height + Math.max(0, children.size() - 1) * this.spacing);
        return this.transposer.t(prefSize).expand(insets.getWidth(), insets.getHeight()).union(this.getBorderPreferredSize(container));
    }

    private Dimension calculateChildrenSize(List<IFigure> children, int wHint, int hHint, boolean preferred) {
        int height = 0;
        int width = 0;
        int i = 0;
        while (i < children.size()) {
            IFigure child = children.get(i);
            Dimension childSize = this.transposer.t(preferred ? child.getPreferredSize(wHint, hHint) : child.getMinimumSize(wHint, hHint));
            height += childSize.height;
            width = Math.max(width, childSize.width);
            ++i;
        }
        return new Dimension(width, height);
    }

    private List<IFigure> getChildren(IFigure container) {
        ArrayList<IFigure> children = new ArrayList<IFigure>(container.getChildren());
        if (this.getIgnoreInvisibleChildren()) {
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                IFigure f = (IFigure)iter.next();
                if (f.isVisible()) continue;
                iter.remove();
            }
        }
        if (this.isReversed()) {
            Collections.reverse(children);
        }
        return children;
    }
}

