/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.launching;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.launching.ApplicationFileSelectionDialog;
import org.eclipse.php.internal.debug.ui.launching.ProjectSelectionDialog;
import org.eclipse.php.internal.debug.ui.launching.ResourceSorter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class LaunchUtilities {
    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static Shell getShell() {
        return LaunchUtilities.getStandardDisplay().getActiveShell();
    }

    public static void openError(final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = LaunchUtilities.getShell();
                MessageDialog.openError((Shell)shell, (String)PHPDebugUIMessages.LaunchUtilities_error, (String)message);
            }
        });
    }

    public static void openError(final String message, final IStatus status) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = LaunchUtilities.getShell();
                ErrorDialog.openError((Shell)shell, (String)PHPDebugUIMessages.LaunchUtilities_error, (String)message, (IStatus)status);
            }
        });
    }

    public static void openError(Shell shell, String message) {
        MessageDialog.openError((Shell)shell, (String)PHPDebugUIMessages.LaunchUtilities_error, (String)message);
    }

    public static void openError(Shell shell, String message, IStatus status) {
        ErrorDialog.openError((Shell)shell, (String)PHPDebugUIMessages.LaunchUtilities_error, (String)message, (IStatus)status);
    }

    public static String getProjectFromDialog(Shell shell, String[] requiredNatures) {
        ProjectSelectionDialog dialog = new ProjectSelectionDialog(shell, requiredNatures, PHPDebugUIMessages.LaunchUtilities_projects, PHPDebugUIMessages.LaunchUtilities_selectProject);
        dialog.open();
        Object[] resource = dialog.getResult();
        String text = null;
        if (resource != null && resource.length > 0) {
            Object obj = resource[0];
            IPath path = null;
            if (obj instanceof IPath) {
                path = (IPath)resource[0];
            } else if (obj instanceof IProject) {
                path = ((IProject)obj).getFullPath();
            }
            if (path != null) {
                text = path.makeRelative().toString();
            }
        }
        return text;
    }

    public static IResource getFileFromDialog(IProject project, Shell shell, String[] fileExtensions, String[] requiredNatures, boolean allowExternalFiles) {
        LaunchUtilities inst = new LaunchUtilities();
        ApplicationFileSelectionDialog d = new ApplicationFileSelectionDialog(shell, (ILabelProvider)inst.new WebLaunchLabelProvider(), PHPDebugUIMessages.LaunchUtilities_selectFile, PHPDebugUIMessages.LaunchUtilities_selectProjectFile, fileExtensions, requiredNatures, false, allowExternalFiles);
        if (project != null) {
            d.setInput(project);
            d.setInitialSelection(project);
        } else {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            d.setInput(root);
            d.setInitialSelection(root);
        }
        d.setAllowMultiple(false);
        d.setComparator((ViewerComparator)new ResourceSorter(2));
        d.open();
        if (d.getReturnCode() == 0) {
            Object[] targetFiles = d.getResult();
            Object target = targetFiles[0];
            return (IResource)target;
        }
        return null;
    }

    private class WebLaunchLabelProvider
    extends WorkbenchLabelProvider {
        private WebLaunchLabelProvider() {
        }

        protected String decorateText(String input, Object element) {
            if (element instanceof IFile) {
                IFile file = (IFile)element;
                String filename = file.getName();
                return filename;
            }
            return input;
        }
    }
}

