/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.validation;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.papyrus.infra.services.markerlistener.IPapyrusMarker;
import org.eclipse.papyrus.infra.services.markerlistener.providers.IMarkerProvider;
import org.eclipse.papyrus.infra.services.markerlistener.providers.WorkspaceMarkerProvider;
import org.eclipse.papyrus.infra.services.markerlistener.util.MarkerListenerUtils;
import org.eclipse.papyrus.infra.services.validation.Activator;
import org.eclipse.papyrus.infra.services.validation.ValidationUtils;

public class ValidationTool {
    private EObject eObject;
    protected Resource resource;
    protected IMarkerProvider provider;
    public static int DELETE_PMARKER_RATIO = 50;
    public static int CREATE_PMARKER_RATIO = 20;

    public ValidationTool(EObject eObject) {
        this(eObject, ValidationUtils.getValidationResource(eObject));
    }

    public ValidationTool(EObject eObject, Resource resource) {
        this.resource = resource;
        this.setEObject(eObject);
        this.provider = resource == null ? IMarkerProvider.NULL : MarkerListenerUtils.getMarkerProvider((Resource)resource);
    }

    public void tryChildIfEmpty() {
        this.getEObject();
    }

    public EObject getEObject() {
        return this.eObject;
    }

    public void setEObject(EObject eObject) {
        this.eObject = eObject;
    }

    public Collection<? extends IPapyrusMarker> getMarkers() {
        try {
            return this.provider.getMarkers(this.resource, null, true);
        }
        catch (CoreException coreException) {
            return Collections.emptyList();
        }
    }

    public void deleteSubMarkers() {
        this.deleteSubMarkers((IProgressMonitor)new NullProgressMonitor());
    }

    public void deleteSubMarkers(IProgressMonitor monitor) {
        try {
            this.provider.deleteMarkers(this.getEObject(), monitor, "org.eclipse.core.resources.problemmarker", true);
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
    }

    public IRunnableWithProgress wrap(IRunnableWithProgress runnableWithProgress) {
        IRunnableWithProgress result = runnableWithProgress;
        if (this.isWorkspaceResource() && MarkerListenerUtils.eclipseResourcesUtil != null) {
            result = MarkerListenerUtils.eclipseResourcesUtil.getWorkspaceModifyOperation(result);
        }
        return result;
    }

    protected boolean isWorkspaceResource() {
        return this.provider instanceof WorkspaceMarkerProvider;
    }

    public void createMarkers(Diagnostic diagnostic, IProgressMonitor monitor) {
        try {
            this.provider.createMarkers(this.resource, diagnostic, monitor);
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
    }
}

