/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.m2m.atl.engine.vm.ClassNativeOperation;
import org.eclipse.m2m.atl.engine.vm.InstanceNativeOperation;
import org.eclipse.m2m.atl.engine.vm.Operation;
import org.eclipse.m2m.atl.engine.vm.StackFrame;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMBag;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMBoolean;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMInteger;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMMap;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclType;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMReal;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMSequence;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMSet;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;

public abstract class NativeOperation
extends Operation {
    private static Map trans;
    private List parameters;
    private ASMOclType returnType;
    private ASMOclType contextType;
    private Method method;
    private String name;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;

    private static Map getTrans() {
        if (trans == null) {
            trans = new HashMap();
            trans.put("operatorMinus", "-");
            trans.put("operatorPlus", "+");
            trans.put("operatorMul", "*");
            trans.put("operatorDiv", "/");
            trans.put("operatorEQ", "=");
            trans.put("operatorNE", "<>");
            trans.put("operatorLT", "<");
            trans.put("operatorLE", "<=");
            trans.put("operatorGT", ">");
            trans.put("operatorGE", ">=");
        }
        return trans;
    }

    public NativeOperation(Method method, List parameters, ASMOclType returnType, ASMOclType contextType) {
        this.method = method;
        this.parameters = parameters;
        this.returnType = returnType;
        this.contextType = contextType;
        this.name = method.getName();
        if (NativeOperation.getTrans().containsKey(this.name)) {
            this.name = (String)NativeOperation.getTrans().get(this.name);
        }
    }

    public static void registerOperations(ASMOclType t, Class c) {
        NativeOperation.registerOperations(t, c, true, false, false, false);
    }

    public static void registerOperations(ASMOclType t, Class c, boolean allowClassLevel, boolean allowInstanceLevel, boolean allowTypeTranslation, boolean allowDontUseFrame) {
        boolean debug = false;
        Iterator<Method> i = Arrays.asList(c.getDeclaredMethods()).iterator();
        while (i.hasNext()) {
            Class<?> pt;
            boolean isStatic;
            Method m = i.next();
            boolean bl = isStatic = (8 & m.getModifiers()) != 0;
            if (!allowClassLevel && isStatic || !allowInstanceLevel && !isStatic || (1 & m.getModifiers()) == 0) continue;
            boolean dontUseFrame = false;
            boolean notGood = false;
            Iterator<Class<?>> j = Arrays.asList(m.getParameterTypes()).iterator();
            ArrayList<ASMOclType> parameters = new ArrayList<ASMOclType>();
            if (j.hasNext()) {
                pt = j.next();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.m2m.atl.engine.vm.StackFrame");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!pt.equals(clazz)) {
                    if (allowDontUseFrame) {
                        dontUseFrame = true;
                    } else {
                        notGood = true;
                    }
                    j = Arrays.asList(m.getParameterTypes()).iterator();
                }
                if (!isStatic) {
                    j = Arrays.asList(m.getParameterTypes()).iterator();
                }
            } else if (allowDontUseFrame) {
                dontUseFrame = true;
            } else {
                notGood = true;
            }
            while (j.hasNext() && !notGood) {
                pt = j.next();
                ASMOclType paramType = NativeOperation.getASMType(pt, allowTypeTranslation);
                if (paramType == null) {
                    notGood = true;
                    continue;
                }
                parameters.add(paramType);
            }
            Class<?> rt = m.getReturnType();
            ASMOclType returnType = NativeOperation.getASMType(rt, allowTypeTranslation);
            if (!(returnType != null || rt.isPrimitive() && rt.getName().equals("void"))) {
                notGood = true;
            }
            if (notGood) continue;
            if ((8 & m.getModifiers()) != 0) {
                parameters.remove(0);
                t.registerVMOperation(new ClassNativeOperation(m, parameters, returnType, NativeOperation.getASMType(c, allowTypeTranslation)));
                continue;
            }
            t.registerVMOperation(new InstanceNativeOperation(m, allowTypeTranslation, dontUseFrame, parameters, returnType, NativeOperation.getASMType(c, allowTypeTranslation)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static ASMOclType getASMType(Class pt, boolean allowTypeTranslation) {
        ASMOclType ret = null;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(pt)) {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz2.equals(pt)) {
                return ASMOclAny.getOclAnyType();
            }
            try {
                return (ASMOclType)pt.getField("myType").get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                return ret;
            }
            catch (NoSuchFieldException noSuchFieldException) {}
            return ret;
        }
        if (!allowTypeTranslation) return ret;
        if (pt.equals(Integer.TYPE)) return ASMInteger.myType;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pt.equals(clazz3)) {
            return ASMInteger.myType;
        }
        if (pt.equals(Double.TYPE)) return ASMReal.myType;
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pt.equals(clazz4)) return ASMReal.myType;
        if (pt.equals(Float.TYPE)) return ASMReal.myType;
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pt.equals(clazz5)) {
            return ASMReal.myType;
        }
        if (pt.equals(Boolean.TYPE)) return ASMBoolean.myType;
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pt.equals(clazz6)) {
            return ASMBoolean.myType;
        }
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pt.equals(clazz7)) {
            return ASMString.myType;
        }
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("java.util.List");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pt.equals(clazz8)) {
            return ASMSequence.myType;
        }
        Class<?> clazz9 = class$8;
        if (clazz9 == null) {
            try {
                clazz9 = class$8 = Class.forName("java.util.Set");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pt.equals(clazz9)) {
            return ASMSet.myType;
        }
        Class<?> clazz10 = class$9;
        if (clazz10 == null) {
            try {
                clazz10 = class$9 = Class.forName("java.util.Collection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pt.equals(clazz10)) {
            return ASMBag.myType;
        }
        Class<?> clazz11 = class$10;
        if (clazz11 == null) {
            try {
                clazz11 = class$10 = Class.forName("java.util.Map");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!pt.equals(clazz11)) return ret;
        return ASMMap.myType;
    }

    public String getName() {
        return this.name;
    }

    public String getContextSignature() {
        return null;
    }

    public String getSignature() {
        return null;
    }

    public abstract ASMOclAny exec(StackFrame var1);

    public String toString() {
        return "NativeOperation " + this.method;
    }

    public Method getMethod() {
        return this.method;
    }

    public List getParameters() {
        return this.parameters;
    }

    public ASMOclType getReturnType() {
        return this.returnType;
    }

    public ASMOclType getContextType() {
        return this.contextType;
    }
}

