"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.create = void 0;
const plugin = (context) => {
    if (!context)
        return {};
    return {
        async provideInlayHints(document, range) {
            const settings = {};
            const result = [];
            const [file] = context.documents.getVirtualFileByUri(document.uri);
            if (file) {
                const start = document.offsetAt(range.start);
                const end = document.offsetAt(range.end);
                for (const mapping of file.mappings) {
                    const hint = mapping.data.__hint;
                    if (mapping.generatedRange[0] >= start
                        && mapping.generatedRange[1] <= end
                        && hint) {
                        settings[hint.setting] ??= await context.env.getConfiguration?.(hint.setting) ?? false;
                        if (!settings[hint.setting])
                            continue;
                        result.push({
                            label: hint.label,
                            paddingRight: hint.paddingRight,
                            paddingLeft: hint.paddingLeft,
                            position: document.positionAt(mapping.generatedRange[0]),
                            kind: 2,
                            tooltip: {
                                kind: 'markdown',
                                value: hint.tooltip,
                            },
                        });
                    }
                }
            }
            return result;
        },
    };
};
const create = () => plugin;
exports.create = create;
//# sourceMappingURL=vue-visualize-hidden-callback-param.js.map