/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.json;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.server.ProcessStreamConnectionProvider;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseMessage;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.SchemaAssociationRegistry;
import org.eclipse.wildwebdeveloper.embedder.node.NodeJSManager;
import org.eclipse.wildwebdeveloper.json.JSonLanguageServerInterface;

public class JSonLanguageServer
extends ProcessStreamConnectionProvider {
    public static final String SCHEMA_EXT = "org.eclipse.wildwebdeveloper.json.schema";
    public static final String PATTERN_ATTR = "pattern";
    public static final String URL_ATTR = "url";
    private static final IPreferenceStore PREFERENCE_STORE = Activator.getDefault().getPreferenceStore();
    private static final LanguageServersRegistry.LanguageServerDefinition JSON_LS_DEFINITION = LanguageServersRegistry.getInstance().getDefinition("org.eclipse.wildwebdeveloper.json");
    private static final IPropertyChangeListener PROPERTY_CHANGE_LISTENER = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("wildwebdeveloper.yaml.schema".equals(event.getProperty())) {
                Map<String, List<String>> associations = JSonLanguageServer.getSchemaAssociations();
                ((LanguageServers.LanguageServerProjectExecutor)LanguageServers.forProject(null).withPreferredServer(JSON_LS_DEFINITION)).excludeInactive().collectAll((w, ls) -> CompletableFuture.completedFuture(ls)).thenAccept(lss -> lss.stream().forEach(ls -> ((JSonLanguageServerInterface)ls).sendJSonchemaAssociations(associations)));
            }
        }
    };

    public JSonLanguageServer() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(NodeJSManager.getNodeJsLocation().getAbsolutePath());
        try {
            URL url = FileLocator.toFileURL((URL)((Object)((Object)this)).getClass().getResource("/node_modules/vscode-json-languageserver/dist/node/jsonServerMain.js"));
            commands.add(new File(url.getPath()).getAbsolutePath());
            commands.add("--stdio");
            this.setCommands(commands);
            this.setWorkingDirectory(System.getProperty("user.dir"));
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), e.getMessage(), (Throwable)e));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handleMessage(Message message, LanguageServer languageServer, URI rootUri) {
        Message message2 = message;
        if (message2 instanceof ResponseMessage) {
            void responseMessage;
            ResponseMessage responseMessage2 = (ResponseMessage)message2;
            ResponseMessage cfr_ignored_0 = (ResponseMessage)message2;
            if (responseMessage.getResult() instanceof InitializeResult) {
                JSonLanguageServerInterface server = (JSonLanguageServerInterface)languageServer;
                server.sendJSonchemaAssociations(JSonLanguageServer.getSchemaAssociations());
            }
        }
    }

    private static Map<String, List<String>> getSchemaAssociations() {
        HashMap<String, List<String>> associations = new HashMap<String, List<String>>();
        JSonLanguageServer.fillSchemaAssociationsFromPreferenceStore(associations);
        JSonLanguageServer.fillSchemaAssociationsFromExtensionPoint(associations);
        return associations;
    }

    private static void fillSchemaAssociationsFromPreferenceStore(Map<String, List<String>> associations) {
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        String schemaString = preferenceStore.getString("wildwebdeveloper.yaml.schema");
        Map contentTypeAssociations = (Map)new Gson().fromJson(schemaString, new TypeToken<HashMap<String, String>>(){}.getType());
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType jsonBaseContentType = contentTypeManager.getContentType("org.eclipse.wildwebdeveloper.json");
        contentTypeAssociations.forEach((key, value) -> {
            IContentType contentType = contentTypeManager.getContentType(key);
            if (contentType != null && contentType.getBaseType().equals(jsonBaseContentType)) {
                String[] fileExtensions;
                String[] filePatterns;
                String[] fileNames;
                String[] stringArray = fileNames = contentType.getFileSpecs(4);
                int n = fileNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String fileName = stringArray[n2];
                    associations.put(fileName, Arrays.asList(value));
                    ++n2;
                }
                String[] stringArray2 = filePatterns = contentType.getFileSpecs(16);
                int n3 = filePatterns.length;
                n = 0;
                while (n < n3) {
                    String pattern = stringArray2[n];
                    associations.put(pattern, Arrays.asList(value));
                    ++n;
                }
                String[] stringArray3 = fileExtensions = contentType.getFileSpecs(8);
                int n4 = fileExtensions.length;
                n3 = 0;
                while (n3 < n4) {
                    String extension = stringArray3[n3];
                    associations.put("*." + extension, Arrays.asList(value));
                    ++n3;
                }
            }
        });
    }

    private static void fillSchemaAssociationsFromExtensionPoint(Map<String, List<String>> associations) {
        IConfigurationElement[] conf;
        IConfigurationElement[] iConfigurationElementArray = conf = Platform.getExtensionRegistry().getConfigurationElementsFor(SCHEMA_EXT);
        int n = conf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            String pattern = el.getAttribute(PATTERN_ATTR);
            if (!associations.containsKey(pattern)) {
                associations.put(pattern, new ArrayList());
            }
            associations.get(pattern).add(SchemaAssociationRegistry.translate(el.getAttribute(URL_ATTR)));
            ++n2;
        }
    }

    public Object getInitializationOptions(URI rootUri) {
        return Collections.singletonMap("provideFormatter", true);
    }

    public void start() throws IOException {
        super.start();
        PREFERENCE_STORE.addPropertyChangeListener(PROPERTY_CHANGE_LISTENER);
    }

    public void stop() {
        PREFERENCE_STORE.removePropertyChangeListener(PROPERTY_CHANGE_LISTENER);
        super.stop();
    }
}

