/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.gef.policy;

import java.lang.reflect.Method;
import org.apache.commons.lang3.ObjectUtils;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.Layer;
import org.eclipse.wb.draw2d.border.Border;
import org.eclipse.wb.draw2d.border.CompoundBorder;
import org.eclipse.wb.draw2d.border.LineBorder;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.core.policies.EditPolicy;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.gef.graphical.policies.GraphicalEditPolicy;
import org.eclipse.wb.gef.graphical.policies.LayoutEditPolicy;
import org.eclipse.wb.gef.graphical.policies.SelectionEditPolicy;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

public abstract class PolicyUtils {
    private static final String BORDER_FEEDBACK_KEY = "PolicyUtils.borderFeedback";

    public static void showBorderTargetFeedback(final GraphicalEditPolicy policy) {
        ExecutionUtils.runLog(new RunnableEx(){

            @Override
            public void run() throws Exception {
                Layer layer = (Layer)((Object)ReflectionUtils.invokeMethod2((Object)policy, "getFeedbackLayer"));
                PolicyUtils.showBorderTargetFeedback(layer, policy.getHost());
            }
        });
    }

    public static void showBorderTargetFeedback(GraphicalEditPart part) {
        Layer feedbackLayer = part.getViewer().getLayer("Feedback Layer");
        PolicyUtils.showBorderTargetFeedback(feedbackLayer, part);
    }

    private static void showBorderTargetFeedback(Layer layer, GraphicalEditPart part) {
        PolicyUtils.eraseBorderTargetFeedback(part);
        Border targetBorder = PolicyUtils.createTargetBorder();
        Figure hostFigure = part.getFigure();
        Rectangle bounds = hostFigure.getBounds().getCopy();
        bounds.expand(3, 3);
        FigureUtils.translateFigureToAbsolute((IFigure)hostFigure, (Translatable)bounds);
        Figure borderFeedback = new Figure();
        borderFeedback.setBorder(targetBorder);
        borderFeedback.setBounds(bounds);
        layer.add(borderFeedback);
        part.getViewer().getControl().setData(BORDER_FEEDBACK_KEY, (Object)borderFeedback);
    }

    public static void eraseBorderTargetFeedback(GraphicalEditPolicy policy) {
        GraphicalEditPart part = policy.getHost();
        PolicyUtils.eraseBorderTargetFeedback(part);
    }

    public static void eraseBorderTargetFeedback(GraphicalEditPart part) {
        Figure borderFeedback = (Figure)((Object)part.getViewer().getControl().getData(BORDER_FEEDBACK_KEY));
        if (borderFeedback != null) {
            FigureUtils.removeFigure(borderFeedback);
            borderFeedback = null;
        }
    }

    public static Border createTargetBorder() {
        LineBorder darkBorder = new LineBorder(ColorConstants.darkGreen, 1);
        LineBorder darkBorder2 = new LineBorder(ColorConstants.darkGreen, 1);
        LineBorder lightBorder = new LineBorder(ColorConstants.lightGreen, 1);
        return new CompoundBorder(new CompoundBorder(darkBorder, lightBorder), darkBorder2);
    }

    private static Layer getLayer(GraphicalEditPolicy policy, String name) throws Exception {
        Method method = PolicyUtils.findPolicyMethod(policy, "getLayer(java.lang.String)");
        return (Layer)((Object)method.invoke((Object)policy, name));
    }

    private static Method findPolicyMethod(GraphicalEditPolicy policy, String signature) throws Exception {
        return ReflectionUtils.getMethodBySignature(((Object)((Object)policy)).getClass(), signature);
    }

    public static Rectangle getAbsoluteBounds(GraphicalEditPart editPart) {
        Figure figure = editPart.getFigure();
        Rectangle bounds = figure.getBounds().getCopy();
        FigureUtils.translateFigureToAbsolute((IFigure)figure, (Translatable)bounds);
        return bounds;
    }

    public static void translateAbsoluteToFeedback(GraphicalEditPolicy policy, Translatable t) {
        try {
            Layer layer = PolicyUtils.getLayer(policy, "Feedback Layer");
            FigureUtils.translateAbsoluteToFigure((IFigure)layer, t);
        }
        catch (Throwable e) {
            DesignerPlugin.log(e);
        }
    }

    public static void translateAbsoluteToModel(SelectionEditPolicy policy, Translatable t) {
        try {
            GraphicalEditPart containerEditPart = (GraphicalEditPart)policy.getHost().getParent();
            PolicyUtils.translateAbsoluteToModel(containerEditPart, t);
        }
        catch (Throwable e) {
            DesignerPlugin.log(e);
        }
    }

    public static void translateAbsoluteToModel(LayoutEditPolicy policy, Translatable t) {
        try {
            GraphicalEditPart containerEditPart = policy.getHost();
            PolicyUtils.translateAbsoluteToModel(containerEditPart, t);
        }
        catch (Throwable e) {
            DesignerPlugin.log(e);
        }
    }

    public static void translateAbsoluteToModel(GraphicalEditPart toContainer, Translatable t) {
        try {
            Figure hostFigure = toContainer.getFigure();
            FigureUtils.translateAbsoluteToFigure2(hostFigure, t);
            IAbstractComponentInfo container = (IAbstractComponentInfo)toContainer.getModel();
            PolicyUtils.absoluteToModel_rightToLeft(t, container);
            t.performTranslate(container.getClientAreaInsets().getNegated());
        }
        catch (Throwable e) {
            DesignerPlugin.log(e);
        }
    }

    public static void translateModelToFeedback(GraphicalEditPolicy policy, Translatable t) {
        if (policy instanceof LayoutEditPolicy) {
            PolicyUtils.translateAbsoluteToModel((LayoutEditPolicy)policy, t);
        } else if (policy instanceof SelectionEditPolicy) {
            PolicyUtils.translateAbsoluteToModel((SelectionEditPolicy)policy, t);
        } else {
            throw new IllegalArgumentException(ObjectUtils.toString((Object)((Object)policy)));
        }
    }

    public static void translateModelToFeedback(LayoutEditPolicy policy, Translatable t) {
        try {
            GraphicalEditPart containerEditPart = policy.getHost();
            IAbstractComponentInfo container = (IAbstractComponentInfo)containerEditPart.getModel();
            t.performTranslate(container.getClientAreaInsets());
            PolicyUtils.modelToFeedback_rightToLeft(t, container);
            Figure hostFigure = containerEditPart.getFigure();
            Layer layer = PolicyUtils.getLayer(policy, "Feedback Layer");
            FigureUtils.translateFigureToFigure2(hostFigure, layer, t);
        }
        catch (Throwable e) {
            DesignerPlugin.log(e);
        }
    }

    public static void translateModelToFeedback(SelectionEditPolicy policy, Translatable t) {
        try {
            GraphicalEditPart containerEditPart = (GraphicalEditPart)policy.getHost().getParent();
            IAbstractComponentInfo container = (IAbstractComponentInfo)containerEditPart.getModel();
            t.performTranslate(container.getClientAreaInsets());
            PolicyUtils.modelToFeedback_rightToLeft(t, container);
            Figure hostFigure = containerEditPart.getFigure();
            Layer layer = PolicyUtils.getLayer(policy, "Feedback Layer");
            FigureUtils.translateFigureToFigure2(hostFigure, layer, t);
        }
        catch (Throwable e) {
            DesignerPlugin.log(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void modelToFeedback_rightToLeft(Translatable t, IAbstractComponentInfo container) {
        if (container.isRTL()) {
            Translatable translatable;
            int containerWidth = container.getBounds().width;
            Translatable translatable2 = t;
            if (translatable2 instanceof Point) {
                void point;
                Point point2 = (Point)translatable2;
                Point cfr_ignored_0 = (Point)translatable2;
                point.x = containerWidth - point.x;
            }
            if ((translatable = t) instanceof Rectangle) {
                void rectangle;
                Rectangle rectangle2 = (Rectangle)translatable;
                Rectangle cfr_ignored_1 = (Rectangle)translatable;
                rectangle.x = containerWidth - rectangle.x - rectangle.width;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void absoluteToModel_rightToLeft(Translatable t, IAbstractComponentInfo container) {
        if (container.isRTL()) {
            Translatable translatable;
            int containerWidth = container.getBounds().width;
            Translatable translatable2 = t;
            if (translatable2 instanceof Point) {
                void point;
                Point point2 = (Point)translatable2;
                Point cfr_ignored_0 = (Point)translatable2;
                point.x = containerWidth - point.x;
            }
            if ((translatable = t) instanceof Rectangle) {
                void rectangle;
                Rectangle rectangle2 = (Rectangle)translatable;
                Rectangle cfr_ignored_1 = (Rectangle)translatable;
                rectangle.x = containerWidth - rectangle.x - rectangle.width;
            }
        }
    }

    public static void scheduleSelection(EditPolicy policy, Object model) {
        PolicyUtils.scheduleSelection(policy.getHost(), model);
    }

    public static void scheduleSelection(EditPart host, Object model) {
        PolicyUtils.scheduleSelection(host.getViewer(), model);
    }

    public static void scheduleSelection(final IEditPartViewer viewer, final Object model) {
        ExecutionUtils.runLogLater(new RunnableEx(){

            @Override
            public void run() throws Exception {
                EditPart editPart = (EditPart)((Object)viewer.getEditPartRegistry().get(model));
                if (editPart != null) {
                    viewer.select(editPart);
                }
            }
        });
    }

    public static boolean hasDirection(int direction, int requiredDirection) {
        return (direction & requiredDirection) != 0;
    }
}

