/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.ui.container;

import org.eclipse.net4j.internal.ui.bundle.OM;
import org.eclipse.net4j.tcp.TCPUtil;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.ui.container.ElementWizard;
import org.eclipse.net4j.util.ui.container.ElementWizardFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class TCPConnectorWizard
extends ElementWizard
implements ModifyListener {
    private Text hostText;
    private Text portText;

    protected void create(Composite parent) {
        this.hostText = TCPConnectorWizard.addText((Composite)parent, (String)"Host:");
        this.hostText.addModifyListener((ModifyListener)this);
        this.portText = TCPConnectorWizard.addText((Composite)parent, (String)"Port:");
        this.portText.addModifyListener((ModifyListener)this);
        String description = this.getDefaultDescription();
        if (description != null) {
            try {
                TCPUtil.ConnectorData data = new TCPUtil.ConnectorData(description);
                this.hostText.setText(data.getHost());
                this.portText.setText(Integer.toString(data.getPort()));
            }
            catch (NoClassDefFoundError error) {
                OM.LOG.error((Throwable)error);
            }
        }
    }

    public void modifyText(ModifyEvent e) {
        String host = this.hostText.getText();
        if (host.length() == 0) {
            this.setValidationError(this.hostText, "Host name is empty.");
            return;
        }
        String port = this.portText.getText();
        if (port.length() != 0) {
            host = String.valueOf(host) + ":" + port;
        }
        this.setResultDescription(host);
        this.setValidationError(this.hostText, null);
    }

    public static class Factory
    extends ElementWizardFactory {
        public Factory() {
            super("org.eclipse.net4j.connectors", "tcp");
        }

        public TCPConnectorWizard create(String description) throws ProductCreationException {
            return new TCPConnectorWizard();
        }
    }
}

