/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBConnection;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.db.IDBDatabase;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.delta.IDBSchemaDelta;
import org.eclipse.net4j.internal.db.DBConnection;
import org.eclipse.net4j.internal.db.DBPreparedStatement;
import org.eclipse.net4j.internal.db.DBResultSet;
import org.eclipse.net4j.internal.db.DBSchemaTransaction;
import org.eclipse.net4j.internal.db.ddl.delta.DBSchemaDelta;
import org.eclipse.net4j.spi.db.DBAdapter;
import org.eclipse.net4j.spi.db.ddl.InternalDBSchema;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.container.SetContainer;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.security.IUserAware;

public final class DBDatabase
extends SetContainer<IDBConnection>
implements IDBDatabase {
    private static final long TIMEOUT_SCHEMA_ACCESS = OMPlatform.INSTANCE.getProperty("org.eclipse.net4j.internal.db.DBDatabase.TIMEOUT_SCHEMA_ACCESS", 15000L);
    private static final boolean DEBUG_SCHEMA_ACCESS = OMPlatform.INSTANCE.isProperty("org.eclipse.net4j.internal.db.DBDatabase.DEBUG_SCHEMA_ACCESS");
    private static final boolean TRACK_SCHEMA_ACCESS = OMPlatform.INSTANCE.isProperty("org.eclipse.net4j.internal.db.DBDatabase.TRACK_SCHEMA_ACCESS");
    private DBAdapter adapter;
    private IDBConnectionProvider connectionProvider;
    private int statementCacheCapacity = 200;
    private IDBSchema schema;
    private final LinkedList<SchemaAccess> schemaAccessQueue = new LinkedList();
    private int waitingSchemaWriters;

    public DBDatabase(final DBAdapter adapter, IDBConnectionProvider connectionProvider, final String schemaName, final boolean fixNullableIndexColumns, final boolean qualifiedTableNames) {
        super(IDBConnection.class);
        this.adapter = adapter;
        this.connectionProvider = connectionProvider;
        this.schema = DBUtil.execute(this, new DBUtil.RunnableWithConnection<IDBSchema>(){

            @Override
            public IDBSchema run(Connection connection) throws SQLException {
                return DBUtil.readSchema(adapter, connection, schemaName, fixNullableIndexColumns, qualifiedTableNames);
            }
        });
        ((InternalDBSchema)this.schema).lock();
        this.activate();
    }

    public String getUserID() {
        if (this.connectionProvider instanceof IUserAware) {
            return ((IUserAware)this.connectionProvider).getUserID();
        }
        return null;
    }

    @Override
    public DBAdapter getAdapter() {
        return this.adapter;
    }

    @Override
    public IDBSchema getSchema() {
        return this.schema;
    }

    @Override
    public DBSchemaTransaction openSchemaTransaction() {
        return this.openSchemaTransaction(null);
    }

    @Override
    public DBSchemaTransaction openSchemaTransaction(IDBConnection connection) {
        DBSchemaTransaction schemaTransaction = new DBSchemaTransaction(this);
        schemaTransaction.setConnection((DBConnection)connection);
        return schemaTransaction;
    }

    public void closeSchemaTransaction(DBSchemaDelta delta) {
        if (delta == null || delta.isEmpty()) {
            return;
        }
        Object schemaAccessToken = null;
        try {
            schemaAccessToken = this.beginSchemaAccess(true);
            IDBConnection[] iDBConnectionArray = this.getConnections();
            int n = iDBConnectionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDBConnection transaction = iDBConnectionArray[n2];
                ((DBConnection)transaction).invalidateStatementCache();
                ++n2;
            }
            this.fireEvent(new SchemaChangedEventImpl(this, delta));
        }
        finally {
            this.endSchemaAccess(schemaAccessToken);
        }
    }

    @Override
    @Deprecated
    public DBSchemaTransaction getSchemaTransaction() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateSchema(IDBDatabase.RunnableWithSchema runnable) {
        try (DBSchemaTransaction schemaTransaction = this.openSchemaTransaction();){
            IDBSchema workingCopy = schemaTransaction.getWorkingCopy();
            runnable.run(workingCopy);
            schemaTransaction.commit();
        }
    }

    @Override
    public DBConnection getConnection() {
        Connection delegate = this.connectionProvider.getConnection();
        if (delegate == null) {
            throw new DBException("No connection from connection provider: " + this.connectionProvider);
        }
        delegate = this.adapter.modifyConnection(delegate);
        DBConnection connection = new DBConnection(this, delegate);
        this.addElement(connection);
        return connection;
    }

    public void closeConnection(DBConnection connection) {
        this.removeElement(connection);
    }

    @Override
    public IDBConnection[] getConnections() {
        return (IDBConnection[])this.getElements();
    }

    @Override
    public int getStatementCacheCapacity() {
        return this.statementCacheCapacity;
    }

    @Override
    public void setStatementCacheCapacity(int statementCacheCapacity) {
        this.statementCacheCapacity = statementCacheCapacity;
    }

    public boolean isClosed() {
        return !this.isActive();
    }

    public void close() {
        this.deactivate();
    }

    protected void doDeactivate() throws Exception {
        IDBConnection[] iDBConnectionArray = this.getConnections();
        int n = iDBConnectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDBConnection connection = iDBConnectionArray[n2];
            connection.close();
            ++n2;
        }
        super.doDeactivate();
    }

    /*
     * Exception decompiling
     */
    public Object beginSchemaAccess(boolean write) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 14[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endSchemaAccess(Object token) {
        if (DEBUG_SCHEMA_ACCESS) {
            try {
                throw new Exception("End schema access: " + this.schema.getName());
            }
            catch (Exception ex) {
                ex.printStackTrace(IOUtil.OUT());
            }
        }
        LinkedList<SchemaAccess> linkedList = this.schemaAccessQueue;
        synchronized (linkedList) {
            ReadSchemaAccess readSchemaAccess;
            SchemaAccess activeSchemaAccess = this.schemaAccessQueue.getFirst();
            if (activeSchemaAccess instanceof ReadSchemaAccess && (readSchemaAccess = (ReadSchemaAccess)activeSchemaAccess).removeReader(token)) {
                return;
            }
            this.schemaAccessQueue.removeFirst();
            this.schemaAccessQueue.notifyAll();
        }
    }

    public String convertString(DBPreparedStatement preparedStatement, int parameterIndex, String value) {
        return this.adapter.convertString(preparedStatement, parameterIndex, value);
    }

    public String convertString(DBResultSet resultSet, int columnIndex, String value) {
        return this.adapter.convertString((ResultSet)resultSet, columnIndex, value);
    }

    public String convertString(DBResultSet resultSet, String columnLabel, String value) {
        return this.adapter.convertString((ResultSet)resultSet, columnLabel, value);
    }

    private ReadSchemaAccess createReadSchemaAccess() {
        if (TRACK_SCHEMA_ACCESS) {
            return new ReadSchemaAccess.Tracked();
        }
        return new ReadSchemaAccess(null, null);
    }

    private WriteSchemaAccess createWriteSchemaAccess() {
        if (TRACK_SCHEMA_ACCESS) {
            return new WriteSchemaAccess.Tracked();
        }
        return new WriteSchemaAccess(null, null);
    }

    private static class ReadSchemaAccess
    implements SchemaAccess {
        private int readers;

        private ReadSchemaAccess() {
        }

        public Object addReader() {
            ++this.readers;
            return this;
        }

        public boolean removeReader(Object token) {
            return --this.readers > 0;
        }

        public String toString() {
            return "READERS[" + this.readers + "]";
        }

        /* synthetic */ ReadSchemaAccess(ReadSchemaAccess readSchemaAccess, ReadSchemaAccess readSchemaAccess2) {
            this();
        }

        private static final class Tracked
        extends ReadSchemaAccess {
            private final Map<Object, Exception> stackTraces = new LinkedHashMap<Object, Exception>();

            @Override
            public Object addReader() {
                Object token = new Object();
                try {
                    throw new Exception();
                }
                catch (Exception ex) {
                    Exception stackTrace = ex;
                    this.stackTraces.put(token, stackTrace);
                    super.addReader();
                    return token;
                }
            }

            @Override
            public boolean removeReader(Object token) {
                this.stackTraces.remove(token);
                return super.removeReader(token);
            }

            @Override
            public String toString() {
                StringBuilder builder = new StringBuilder(super.toString());
                builder.append(" --> Read access(es) started here:");
                builder.append(StringUtil.NL);
                for (Exception stackTrace : this.stackTraces.values()) {
                    ReflectUtil.appendStackTrace((StringBuilder)builder, (StackTraceElement[])stackTrace.getStackTrace());
                    builder.append(StringUtil.NL);
                }
                return builder.toString();
            }
        }
    }

    private static interface SchemaAccess {
    }

    private static final class SchemaChangedEventImpl
    extends Event
    implements IDBDatabase.SchemaChangedEvent {
        private static final long serialVersionUID = 1L;
        private final IDBSchemaDelta schemaDelta;

        public SchemaChangedEventImpl(DBDatabase database, IDBSchemaDelta schemaDelta) {
            super((INotifier)database);
            this.schemaDelta = schemaDelta;
        }

        @Override
        public IDBDatabase getSource() {
            return (IDBDatabase)super.getSource();
        }

        @Override
        public IDBSchemaDelta getSchemaDelta() {
            return this.schemaDelta;
        }
    }

    private static class WriteSchemaAccess
    implements SchemaAccess {
        private WriteSchemaAccess() {
        }

        public String toString() {
            return "WRITER";
        }

        /* synthetic */ WriteSchemaAccess(WriteSchemaAccess writeSchemaAccess, WriteSchemaAccess writeSchemaAccess2) {
            this();
        }

        private static final class Tracked
        extends WriteSchemaAccess {
            private final Exception stackTrace;

            public Tracked() {
                try {
                    throw new Exception();
                }
                catch (Exception ex) {
                    this.stackTrace = ex;
                    return;
                }
            }

            @Override
            public String toString() {
                StringBuilder builder = new StringBuilder(super.toString());
                builder.append(" --> Write access started here:");
                builder.append(StringUtil.NL);
                ReflectUtil.appendStackTrace((StringBuilder)builder, (StackTraceElement[])this.stackTrace.getStackTrace());
                builder.append(StringUtil.NL);
                return builder.toString();
            }
        }
    }
}

