/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.index.EntryResult;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.core.search.indexing.IIndexConstants;
import org.eclipse.dltk.internal.core.search.matching.DLTKSearchPattern;

public class MethodDeclarationPattern
extends DLTKSearchPattern
implements IIndexConstants {
    public char[] simpleName;
    public char[] pkg;
    public char[][] enclosingTypeNames;
    public char typeSuffix;
    public int modifiers;
    public boolean secondary = false;
    public char[][] parameterNames;
    protected static char[][] CATEGORIES = new char[][]{METHOD_DECL};

    public static char[] createIndexKey(int modifiers, String methodName, String[] parameterNames, String[] namespace, String[] enclosingTypeNames) {
        int typeNameLength = methodName == null ? 0 : methodName.length();
        int parameterNamesLength = 0;
        if (parameterNames != null) {
            int i = 0;
            int length = parameterNames.length;
            while (i < length) {
                parameterNamesLength += parameterNames[i].length();
                if (++i >= length) continue;
                ++parameterNamesLength;
            }
        }
        int packageLength = MethodDeclarationPattern.indexKeyLength(namespace);
        int enclosingNamesLength = MethodDeclarationPattern.indexKeyLength(enclosingTypeNames);
        int resultLength = typeNameLength + parameterNamesLength + packageLength + enclosingNamesLength + 6;
        char[] result = new char[resultLength];
        int pos = 0;
        if (typeNameLength > 0) {
            methodName.getChars(0, typeNameLength, result, pos);
            pos += typeNameLength;
        }
        result[pos++] = 123;
        if (parameterNames != null && parameterNamesLength > 0) {
            int i = 0;
            int length = parameterNames.length;
            while (i < length) {
                String parameterName = parameterNames[i];
                int itsLength = parameterName.length();
                parameterName.getChars(0, itsLength, result, pos);
                pos += itsLength;
                if (++i >= length) continue;
                result[pos++] = 44;
            }
        }
        result[pos++] = 123;
        pos = MethodDeclarationPattern.encodeNames(namespace, packageLength, result, pos);
        result[pos++] = 123;
        pos = MethodDeclarationPattern.encodeNames(enclosingTypeNames, enclosingNamesLength, result, pos);
        result[pos++] = 123;
        result[pos++] = (char)modifiers;
        result[pos] = (char)(modifiers >> 16);
        return result;
    }

    public MethodDeclarationPattern(char[] simpleName, int matchRule, IDLTKLanguageToolkit toolkit) {
        this(matchRule, toolkit);
        this.simpleName = this.isCaseSensitive() || this.isCamelCase() ? simpleName : CharOperation.toLowerCase(simpleName);
    }

    public MethodDeclarationPattern(char[][] enclosingTypeNames, char[] simpleName, int matchRule, IDLTKLanguageToolkit toolkit) {
        this(simpleName, matchRule, toolkit);
        this.enclosingTypeNames = enclosingTypeNames;
    }

    MethodDeclarationPattern(int matchRule, IDLTKLanguageToolkit toolkit) {
        super(2048, matchRule, toolkit);
    }

    @Override
    public void decodeIndexKey(char[] key) {
        int start;
        int slash = CharOperation.indexOf('{', key, 0);
        this.simpleName = CharOperation.subarray(key, 0, slash);
        this.parameterNames = key[start = ++slash] == '{' ? CharOperation.NO_CHAR_CHAR : (start == (slash = CharOperation.indexOf('{', key, start)) ? CharOperation.NO_CHAR_CHAR : CharOperation.splitOn(',', key, start, slash));
        if (key[start = ++slash] == '{') {
            this.pkg = CharOperation.NO_CHAR;
        } else {
            slash = CharOperation.indexOf('{', key, start);
            this.pkg = internedPackageNames.add(CharOperation.subarray(key, start, slash));
        }
        int last = key.length - 1;
        boolean bl = this.secondary = key[last] == 'S';
        if (this.secondary) {
            last -= 2;
        }
        this.modifiers = last > 0 ? key[last - 1] + (key[last] << 16) : 0;
        this.decodeModifiers();
        start = slash + 1;
        this.enclosingTypeNames = start == (last -= 2) ? CharOperation.NO_CHAR_CHAR : (last == start + 1 && key[start] == '0' ? ONE_ZERO_CHAR : CharOperation.splitOn('$', key, start, last));
    }

    protected void decodeModifiers() {
        this.typeSuffix = (char)67;
    }

    @Override
    public SearchPattern getBlankPattern() {
        return new MethodDeclarationPattern(8, this.getToolkit());
    }

    @Override
    public char[][] getIndexCategories() {
        return CATEGORIES;
    }

    @Override
    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        MethodDeclarationPattern pattern = (MethodDeclarationPattern)decodedPattern;
        if (!this.matchesName(this.simpleName, pattern.simpleName)) {
            return false;
        }
        return this.enclosingTypeNames == null || pattern.enclosingTypeNames != null && pattern.enclosingTypeNames.length != 0 && this.matchesName(this.enclosingTypeNames[this.enclosingTypeNames.length - 1], pattern.enclosingTypeNames[pattern.enclosingTypeNames.length - 1]);
    }

    @Override
    public EntryResult[] queryIn(Index index) throws IOException {
        char[] key = this.simpleName;
        int matchRule = this.getMatchRule();
        switch (this.getMatchMode()) {
            case 1: {
                break;
            }
            case 0: {
                if (this.isCamelCase) break;
                matchRule &= 0xFFFFFFFF;
                matchRule |= 1;
                key = CharOperation.append(this.simpleName, '{');
                break;
            }
            case 2: {
                if (this.simpleName[this.simpleName.length - 1] == '*') break;
                key = CharOperation.concat(this.simpleName, ONE_STAR, '{');
                break;
            }
        }
        return index.query(this.getIndexCategories(), key, matchRule);
    }

    @Override
    protected StringBuilder print(StringBuilder output) {
        output.append("MethodDeclarationPattern: ");
        output.append("name<");
        if (this.simpleName != null) {
            output.append(this.simpleName);
        } else {
            output.append("*");
        }
        output.append(">");
        return super.print(output);
    }
}

