/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.gef.policy.layout.grid.header.layout;

import java.util.List;
import org.eclipse.draw2d.geometry.Interval;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.wb.core.gef.command.EditCommand;
import org.eclipse.wb.core.gef.figure.TextFeedback;
import org.eclipse.wb.core.gef.header.AbstractHeaderLayoutEditPolicy;
import org.eclipse.wb.core.gef.policy.layout.grid.AbstractGridLayoutEditPolicy;
import org.eclipse.wb.core.gef.policy.layout.grid.IGridInfo;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.Layer;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.graphical.policies.LayoutEditPolicy;
import org.eclipse.wb.internal.swt.gef.GefMessages;
import org.eclipse.wb.internal.swt.gef.policy.layout.grid.GridLayoutEditPolicy;
import org.eclipse.wb.internal.swt.gef.policy.layout.grid.header.edit.DimensionHeaderEditPart;
import org.eclipse.wb.internal.swt.gef.policy.layout.grid.header.selection.RowSelectionEditPolicy;
import org.eclipse.wb.internal.swt.model.layout.grid.GridRowInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.IGridLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.IControlInfo;

public final class RowsLayoutEditPolicy<C extends IControlInfo>
extends AbstractHeaderLayoutEditPolicy {
    private final GridLayoutEditPolicy<C> m_mainPolicy;
    private final IGridLayoutInfo<C> m_layout;
    private final Figure m_insertFeedback = AbstractGridLayoutEditPolicy.createInsertFigure();
    private TextFeedback m_feedback;
    private int m_sourceIndex;
    private int m_targetIndex;
    private Command m_moveCommand;

    public RowsLayoutEditPolicy(GridLayoutEditPolicy<C> mainPolicy, IGridLayoutInfo<C> layout) {
        super(mainPolicy);
        this.m_mainPolicy = mainPolicy;
        this.m_layout = layout;
    }

    protected void decorateChild(EditPart child) {
        child.installEditPolicy((Object)"Selection Feedback", new RowSelectionEditPolicy((LayoutEditPolicy)this.m_mainPolicy));
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        if (!this.m_layout.canChangeDimensions()) {
            if (!this.m_layout.isExplicitRow(this.m_sourceIndex)) {
                return null;
            }
            if (!this.m_layout.isExplicitRow(this.m_targetIndex)) {
                return null;
            }
        }
        return this.m_moveCommand;
    }

    protected void showLayoutTargetFeedback(Request request) {
        int size;
        int y;
        ChangeBoundsRequest changeBoundsRequest = (ChangeBoundsRequest)request;
        DimensionHeaderEditPart headerEditPart = (DimensionHeaderEditPart)((Object)changeBoundsRequest.getEditParts().get(0));
        DropRequest dropRequest = (DropRequest)request;
        Point location = dropRequest.getLocation().getCopy();
        DimensionHeaderEditPart target = null;
        List children = this.getHost().getChildren();
        for (EditPart child : children) {
            DimensionHeaderEditPart rowEditPart = (DimensionHeaderEditPart)child;
            Rectangle bounds = rowEditPart.getFigure().getBounds();
            if (location.y >= bounds.getCenter().y) continue;
            target = rowEditPart;
            break;
        }
        IGridInfo gridInfo = this.m_layout.getGridInfo();
        Interval[] columnIntervals = gridInfo.getColumnIntervals();
        Interval[] rowIntervals = gridInfo.getRowIntervals();
        int x1 = columnIntervals[0].begin() - 5;
        int x2 = columnIntervals[columnIntervals.length - 1].end() + 5;
        if (target != null) {
            this.m_targetIndex = target.getDimension().getIndex();
            Interval prevInterval = this.m_targetIndex == 0 ? new Interval(0, 0) : rowIntervals[this.m_targetIndex - 1];
            int[] parameters = GridLayoutEditPolicy.getInsertFeedbackParameters(prevInterval, rowIntervals[this.m_targetIndex], 5);
            y = parameters[1];
            size = parameters[2] - parameters[1];
        } else {
            this.m_targetIndex = this.m_layout.getRows().size();
            this.m_mainPolicy.showInsertFeedbacks(null, null);
            y = rowIntervals[rowIntervals.length - 1].end() + 1;
            size = 5;
        }
        this.m_mainPolicy.showInsertFeedbacks(null, new Rectangle(x1, y, x2 - x1, size));
        if (this.m_insertFeedback.getParent() == null) {
            this.addFeedback(this.m_insertFeedback);
        }
        Point offset = headerEditPart.getOffset();
        Rectangle bounds = new Rectangle(0, y + offset.y, this.getHostFigure().getSize().width, size);
        this.m_insertFeedback.setBounds(bounds);
        Layer feedbackLayer = this.getMainLayer("Feedback Layer");
        if (this.m_feedback == null) {
            this.m_feedback = new TextFeedback(feedbackLayer);
            this.m_feedback.add();
        }
        Point feedbackLocation = new Point(30, location.y + 10);
        FigureUtils.translateAbsoluteToFigure((Figure)feedbackLayer, (Translatable)feedbackLocation);
        this.m_feedback.setLocation(feedbackLocation);
        this.m_feedback.setText(GefMessages.RowsLayoutEditPolicy_feedbackTextPrefix + this.m_targetIndex);
        GridRowInfo row = (GridRowInfo)headerEditPart.getDimension();
        this.m_sourceIndex = row.getIndex();
        this.m_moveCommand = this.m_targetIndex == this.m_sourceIndex || this.m_targetIndex == this.m_sourceIndex + 1 ? new Command(){} : new EditCommand(this.m_layout){

            protected void executeEdit() throws Exception {
                RowsLayoutEditPolicy.this.m_layout.command_MOVE_ROW(RowsLayoutEditPolicy.this.m_sourceIndex, RowsLayoutEditPolicy.this.m_targetIndex);
            }
        };
    }

    protected void eraseLayoutTargetFeedback(Request request) {
        this.m_mainPolicy.eraseInsertFeedbacks();
        FigureUtils.removeFigure((Figure)this.m_insertFeedback);
        if (this.m_feedback != null) {
            this.m_feedback.remove();
            this.m_feedback = null;
        }
    }
}

