/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.part.nonvisual;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.internal.draw2d.Label;

public class BeanFigure
extends Figure {
    private final ImageDescriptor m_imageDescriptor;
    private final Label m_label = new Label();
    private final Point m_imageLocation = new Point();
    private final Dimension m_imageSize;

    public BeanFigure(ImageDescriptor imageDescriptor) {
        ImageData imageData = imageDescriptor.getImageData(100);
        this.m_imageDescriptor = imageDescriptor;
        this.m_imageSize = new Dimension(imageData.width, imageData.height);
        this.add((Figure)this.m_label);
    }

    public void update(String text, Point location) {
        if (this.m_label.getText().equals(text)) {
            this.setLocation(location);
        } else {
            this.m_label.setText(text);
            Dimension textSize = this.m_label.getPreferredSize();
            int width = Math.max(this.m_imageSize.width, textSize.width);
            this.setBounds(new Rectangle(location.x, location.y, width, this.m_imageSize.height + textSize.height));
            this.m_imageLocation.x = width / 2 - this.m_imageSize.width / 2;
            this.m_label.setBounds(new Rectangle(width / 2 - textSize.width / 2, this.m_imageSize.height, textSize.width, textSize.height));
        }
    }

    protected void paintClientArea(Graphics graphics) {
        Image image = this.m_imageDescriptor.createImage();
        graphics.drawImage(image, this.m_imageLocation);
        image.dispose();
    }
}

