/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.eval.evaluators;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.wb.core.eval.AstEvaluationEngine;
import org.eclipse.wb.core.eval.EvaluationContext;
import org.eclipse.wb.core.eval.IExpressionEvaluator;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;

public final class FloatEvaluator
implements IExpressionEvaluator {
    /*
     * WARNING - void declaration
     */
    @Override
    public Object evaluate(EvaluationContext context, Expression expression, ITypeBinding typeBinding, String typeQualifiedName) throws Exception {
        if ("float".equals(typeQualifiedName)) {
            Expression expression2;
            InfixExpression operator;
            Expression expression3 = expression;
            if (expression3 instanceof NumberLiteral) {
                void numberLiteral;
                NumberLiteral numberLiteral2 = (NumberLiteral)expression3;
                NumberLiteral cfr_ignored_0 = (NumberLiteral)expression3;
                String token = numberLiteral.getToken();
                token = StringUtils.stripEnd((String)token, (String)"Ff");
                return Float.valueOf(token);
            }
            Expression expression4 = expression;
            if (expression4 instanceof PrefixExpression) {
                void prefixExpression;
                PrefixExpression token = (PrefixExpression)expression4;
                PrefixExpression cfr_ignored_1 = (PrefixExpression)expression4;
                operator = prefixExpression.getOperator();
                Expression operand = prefixExpression.getOperand();
                float operandValue = FloatEvaluator.getFloatValue(context, operand);
                if (operator == PrefixExpression.Operator.PLUS) {
                    return Float.valueOf(operandValue);
                }
                if (operator == PrefixExpression.Operator.MINUS) {
                    return Float.valueOf(-operandValue);
                }
            }
            if ((expression2 = expression) instanceof InfixExpression) {
                void infixExpression;
                operator = (InfixExpression)expression2;
                InfixExpression cfr_ignored_2 = (InfixExpression)expression2;
                List<Expression> extendedOperands = DomGenerics.extendedOperands((InfixExpression)infixExpression);
                float[] operands = new float[2 + extendedOperands.size()];
                operands[0] = FloatEvaluator.getFloatValue(context, infixExpression.getLeftOperand());
                operands[1] = FloatEvaluator.getFloatValue(context, infixExpression.getRightOperand());
                int i = 0;
                while (i < extendedOperands.size()) {
                    Expression operandExpression = extendedOperands.get(i);
                    operands[2 + i] = FloatEvaluator.getFloatValue(context, operandExpression);
                    ++i;
                }
                float value = operands[0];
                InfixExpression.Operator operator2 = infixExpression.getOperator();
                int i2 = 1;
                while (i2 < operands.length) {
                    float operand = operands[i2];
                    if (operator2 == InfixExpression.Operator.PLUS) {
                        value += operand;
                    } else if (operator2 == InfixExpression.Operator.MINUS) {
                        value -= operand;
                    } else if (operator2 == InfixExpression.Operator.TIMES) {
                        value *= operand;
                    } else if (operator2 == InfixExpression.Operator.DIVIDE) {
                        value /= operand;
                    } else if (operator2 == InfixExpression.Operator.REMAINDER) {
                        value %= operand;
                    }
                    ++i2;
                }
                return Float.valueOf(value);
            }
        }
        return AstEvaluationEngine.UNKNOWN;
    }

    /*
     * WARNING - void declaration
     */
    private static float getFloatValue(EvaluationContext context, Expression expression) throws Exception {
        Object value = AstEvaluationEngine.evaluate(context, expression);
        Object object = value;
        if (object instanceof Character) {
            void character;
            Character c = (Character)object;
            Character cfr_ignored_0 = (Character)object;
            return character.charValue();
        }
        Number number = (Number)value;
        return number.floatValue();
    }
}

