/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.ui;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.wb.internal.core.databinding.model.IBindingInfo;
import org.eclipse.wb.internal.core.databinding.model.IDatabindingsProvider;
import org.eclipse.wb.internal.core.databinding.ui.BindingElementsComposite;
import org.eclipse.wb.internal.core.databinding.ui.ObserveElementsComposite;
import org.eclipse.wb.internal.core.databinding.ui.ObserveType;

public final class EditSelection {
    private int m_currentBindingIndex = -1;
    private final PageSelection m_targetPage = new PageSelection();
    private final PageSelection m_modelPage = new PageSelection();

    public void clearBinding() {
        this.m_currentBindingIndex = -1;
    }

    public void setBinding(IDatabindingsProvider databindingsProvider, IBindingInfo binding) {
        this.m_currentBindingIndex = databindingsProvider.getBindings().indexOf(binding);
    }

    public void setTarget(IDatabindingsProvider databindingsProvider, ObserveElementsComposite observeElementsComposite) {
        EditSelection.setToPage(databindingsProvider, observeElementsComposite, this.m_targetPage);
    }

    public void setModel(IDatabindingsProvider databindingsProvider, ObserveElementsComposite observeElementsComposite) {
        EditSelection.setToPage(databindingsProvider, observeElementsComposite, this.m_modelPage);
    }

    private static void setToPage(IDatabindingsProvider databindingsProvider, ObserveElementsComposite observeElementsComposite, PageSelection page) {
        page.pageIndex = databindingsProvider.getTypes().indexOf(observeElementsComposite.getCurrentType());
        TreeViewer masterViewer = observeElementsComposite.getMasterViewer();
        ITreeContentProvider masterProvider = (ITreeContentProvider)masterViewer.getContentProvider();
        Object[] masterInput = masterProvider.getElements(masterViewer.getInput());
        page.masterSelection = EditSelection.objectToPath(masterProvider, masterInput, observeElementsComposite.getMasterObserve());
        page.masterExpanded = EditSelection.objectsToPaths(masterProvider, masterInput, masterViewer.getExpandedElements());
        TreeViewer propertiesViewer = observeElementsComposite.getPropertiesViewer();
        ITreeContentProvider propertiesProvider = (ITreeContentProvider)propertiesViewer.getContentProvider();
        Object[] propertiesInput = propertiesProvider.getElements(propertiesViewer.getInput());
        page.propertiesSelection = EditSelection.objectToPath(propertiesProvider, propertiesInput, observeElementsComposite.getPropertyObserve());
        page.propertiesExpanded = EditSelection.objectsToPaths(propertiesProvider, propertiesInput, propertiesViewer.getExpandedElements());
    }

    private static int[][] objectsToPaths(ITreeContentProvider provider, Object[] input, Object[] objects) {
        int[][] paths = new int[objects.length][];
        int i = 0;
        while (i < objects.length) {
            paths[i] = EditSelection.objectToPath(provider, input, objects[i]);
            ++i;
        }
        return paths;
    }

    private static int[] objectToPath(ITreeContentProvider provider, Object[] input, Object object) {
        if (object == null) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        ArrayList<Integer> pathList = new ArrayList<Integer>();
        while (true) {
            Object parent;
            if ((parent = provider.getParent(object)) == null) break;
            pathList.add(ArrayUtils.indexOf((Object[])provider.getChildren(parent), (Object)object));
            object = parent;
        }
        pathList.add(ArrayUtils.indexOf((Object[])input, (Object)object));
        int[] path = ArrayUtils.toPrimitive((Integer[])((Integer[])pathList.toArray(Integer[]::new)));
        ArrayUtils.reverse((int[])path);
        return path;
    }

    public boolean setSelection(IDatabindingsProvider databindingsProvider, BindingElementsComposite bindingComposite, ObserveElementsComposite targetComposite, ObserveElementsComposite modelComposite) {
        boolean result = false;
        List<IBindingInfo> bindings = databindingsProvider.getBindings();
        if (this.m_currentBindingIndex > -1 && this.m_currentBindingIndex < bindings.size()) {
            bindingComposite.getViewer().setSelection((ISelection)new StructuredSelection((Object)bindings.get(this.m_currentBindingIndex)), true);
            result = true;
        } else {
            if (EditSelection.setPageSelection(databindingsProvider, targetComposite, this.m_targetPage)) {
                result = true;
            }
            if (EditSelection.setPageSelection(databindingsProvider, modelComposite, this.m_modelPage)) {
                result = true;
            }
        }
        return result;
    }

    private static boolean setPageSelection(IDatabindingsProvider databindingsProvider, ObserveElementsComposite observeElementsComposite, PageSelection page) {
        List<ObserveType> types = databindingsProvider.getTypes();
        if (page.pageIndex < 0 || page.pageIndex >= types.size()) {
            return false;
        }
        try {
            Object[] propertiesExpanded;
            Object[] propertiesInput;
            TreeViewer propertiesViewer;
            ITreeContentProvider propertiesProvider;
            Object propertiesSelection;
            Object[] masterExpanded;
            observeElementsComposite.setRedraw(false);
            observeElementsComposite.showPage(types.get(page.pageIndex));
            TreeViewer masterViewer = observeElementsComposite.getMasterViewer();
            ITreeContentProvider masterProvider = (ITreeContentProvider)masterViewer.getContentProvider();
            Object[] masterInput = masterProvider.getElements(masterViewer.getInput());
            Object masterSelection = EditSelection.pathToObject(masterProvider, masterInput, page.masterSelection);
            if (masterSelection != null) {
                masterViewer.setSelection((ISelection)new StructuredSelection(masterSelection));
            }
            if ((masterExpanded = EditSelection.pathsToObjects(masterProvider, masterInput, page.masterExpanded)).length > 0) {
                masterViewer.collapseAll();
                masterViewer.setExpandedElements(masterExpanded);
            }
            if ((propertiesSelection = EditSelection.pathToObject(propertiesProvider = (ITreeContentProvider)(propertiesViewer = observeElementsComposite.getPropertiesViewer()).getContentProvider(), propertiesInput = propertiesProvider.getElements(propertiesViewer.getInput()), page.propertiesSelection)) != null) {
                propertiesViewer.setSelection((ISelection)new StructuredSelection(propertiesSelection));
            }
            if ((propertiesExpanded = EditSelection.pathsToObjects(propertiesProvider, propertiesInput, page.propertiesExpanded)).length > 0) {
                propertiesViewer.collapseAll();
                propertiesViewer.setExpandedElements(propertiesExpanded);
            }
        }
        finally {
            observeElementsComposite.setRedraw(true);
        }
        return true;
    }

    private static Object[] pathsToObjects(ITreeContentProvider provider, Object[] input, int[][] paths) {
        ArrayList<Object> objects = new ArrayList<Object>();
        int[][] nArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            int[] path = nArray[n2];
            Object object = EditSelection.pathToObject(provider, input, path);
            if (object != null) {
                objects.add(object);
            }
            ++n2;
        }
        return objects.toArray();
    }

    private static Object pathToObject(ITreeContentProvider provider, Object[] input, int[] path) {
        Object[] elements = input;
        Object object = null;
        int[] nArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            if (index < 0 || index >= elements.length) {
                return null;
            }
            object = elements[index];
            elements = provider.getChildren(object);
            ++n2;
        }
        return object;
    }

    private static class PageSelection {
        public int pageIndex = -1;
        public int[] masterSelection;
        public int[][] masterExpanded;
        public int[] propertiesSelection;
        public int[][] propertiesExpanded;

        private PageSelection() {
        }
    }
}

