/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.product;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.pde.internal.core.text.IDocumentAttributeNode;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.util.PDEXMLHelper;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class TextEditUtilities {
    public static TextEdit getInsertOperation(IDocumentElementNode node, IDocument doc) {
        if ((node = TextEditUtilities.getHighestNodeToBeWritten(node, doc)).getParentNode() == null) {
            return new InsertEdit(0, node.write(true));
        }
        if (node.getOffset() > -1) {
            return new ReplaceEdit(node.getOffset(), node.getLength(), node.write(false));
        }
        InsertEdit op = TextEditUtilities.insertAfterSibling(node, doc);
        return op != null ? op : TextEditUtilities.insertAsFirstChild(node, doc);
    }

    public static TextEdit addAttributeOperation(IDocumentAttributeNode attr, String newValue, IDocument doc) {
        int offset = attr.getValueOffset();
        if (offset > -1) {
            return new ReplaceEdit(offset, attr.getValueLength(), PDEXMLHelper.getWritableString((String)newValue));
        }
        IDocumentElementNode node = attr.getEnclosingElement();
        if (node.getOffset() > -1) {
            int len = TextEditUtilities.getNextPosition(doc, node.getOffset(), '>');
            return new ReplaceEdit(node.getOffset(), len + 1, node.writeShallow(TextEditUtilities.shouldTerminateElement(doc, node.getOffset() + len)));
        }
        return TextEditUtilities.getInsertOperation(node, doc);
    }

    private static boolean shouldTerminateElement(IDocument doc, int offset) {
        try {
            return doc.get(offset - 1, 1).toCharArray()[0] == '/';
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private static IDocumentElementNode getHighestNodeToBeWritten(IDocumentElementNode node, IDocument doc) {
        IDocumentElementNode parent = node.getParentNode();
        if (parent == null) {
            return node;
        }
        if (parent.getOffset() > -1) {
            try {
                String endChars = doc.get(parent.getOffset() + parent.getLength() - 2, 2);
                return "/>".equals(endChars) ? parent : node;
            }
            catch (BadLocationException badLocationException) {
                return node;
            }
        }
        return TextEditUtilities.getHighestNodeToBeWritten(parent, doc);
    }

    private static InsertEdit insertAfterSibling(IDocumentElementNode node, IDocument doc) {
        for (IDocumentElementNode sibling = node.getPreviousSibling(); sibling != null; sibling = sibling.getPreviousSibling()) {
            if (sibling.getOffset() <= -1) continue;
            node.setLineIndent(sibling.getLineIndent());
            String sep = TextUtilities.getDefaultLineDelimiter((IDocument)doc);
            return new InsertEdit(sibling.getOffset() + sibling.getLength(), sep + node.write(true));
        }
        return null;
    }

    private static InsertEdit insertAsFirstChild(IDocumentElementNode node, IDocument doc) {
        int offset = node.getParentNode().getOffset();
        int length = TextEditUtilities.getNextPosition(doc, offset, '>');
        node.setLineIndent(node.getParentNode().getLineIndent() + 3);
        String sep = TextUtilities.getDefaultLineDelimiter((IDocument)doc);
        return new InsertEdit(offset + length + 1, sep + node.write(true));
    }

    private static int getNextPosition(IDocument doc, int offset, char ch) {
        int i = 0;
        try {
            i = 0;
            while (i + offset < doc.getLength()) {
                if (ch != doc.get(offset + i, 1).toCharArray()[0]) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException badLocationException) {}
        return i;
    }
}

