/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.plugin;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.NewWizard;
import org.eclipse.pde.internal.ui.wizards.WizardElement;
import org.eclipse.pde.internal.ui.wizards.plugin.LibraryPluginFieldData;
import org.eclipse.pde.internal.ui.wizards.plugin.LibraryPluginJarsPage;
import org.eclipse.pde.internal.ui.wizards.plugin.NewLibraryPluginCreationOperation;
import org.eclipse.pde.internal.ui.wizards.plugin.NewLibraryPluginCreationPage;
import org.eclipse.pde.internal.ui.wizards.plugin.NewLibraryPluginCreationUpdateRefPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class NewLibraryPluginProjectWizard
extends NewWizard
implements IExecutableExtension {
    public static final String DEF_PROJECT_NAME = "project_name";
    public static final String DEF_TEMPLATE_ID = "template-id";
    public static final String PLUGIN_POINT = "pluginContent";
    public static final String TAG_WIZARD = "wizard";
    private IConfigurationElement fConfig;
    private LibraryPluginJarsPage fJarsPage;
    private NewLibraryPluginCreationPage fMainPage;
    private NewLibraryPluginCreationUpdateRefPage fUpdatePage;
    private final LibraryPluginFieldData fPluginData;
    private IProjectProvider fProjectProvider;
    private final Collection<?> fInitialJarPaths;
    private final Collection<?> fInitialSelection;

    public NewLibraryPluginProjectWizard(Collection<?> initialJarPaths, Collection<?> initialSelection) {
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_JAR_TO_PLUGIN_WIZ);
        this.setDialogSettings(PDEPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(PDEUIMessages.NewLibraryPluginProjectWizard_title);
        this.setNeedsProgressMonitor(true);
        PDEPlugin.getDefault().getLabelProvider().connect(this);
        this.fPluginData = new LibraryPluginFieldData();
        this.fInitialJarPaths = initialJarPaths == null ? new ArrayList() : initialJarPaths;
        this.fInitialSelection = initialSelection == null ? new ArrayList() : initialSelection;
    }

    public NewLibraryPluginProjectWizard() {
        this(null, null);
    }

    public void addPages() {
        this.fJarsPage = new LibraryPluginJarsPage("jars", this.fPluginData, this.fInitialJarPaths);
        this.fMainPage = new NewLibraryPluginCreationPage("main", this.fPluginData, this.getSelection());
        this.fUpdatePage = new NewLibraryPluginCreationUpdateRefPage(this.fPluginData, this.fInitialJarPaths, this.fInitialSelection);
        String pname = this.getDefaultValue(DEF_PROJECT_NAME);
        if (pname != null) {
            this.fMainPage.setInitialProjectName(pname);
        }
        this.fProjectProvider = new IProjectProvider(){

            @Override
            public IPath getLocationPath() {
                return NewLibraryPluginProjectWizard.this.fMainPage.getLocationPath();
            }

            @Override
            public IProject getProject() {
                return NewLibraryPluginProjectWizard.this.fMainPage.getProjectHandle();
            }

            @Override
            public String getProjectName() {
                return NewLibraryPluginProjectWizard.this.fMainPage.getProjectName();
            }
        };
        this.addPage((IWizardPage)this.fJarsPage);
        this.addPage((IWizardPage)this.fMainPage);
        this.addPage((IWizardPage)this.fUpdatePage);
    }

    protected WizardElement createWizardElement(IConfigurationElement config) {
        String name = config.getAttribute("name");
        String id = config.getAttribute("id");
        String className = config.getAttribute("class");
        if (name == null || id == null || className == null) {
            return null;
        }
        WizardElement element = new WizardElement(config);
        String imageName = config.getAttribute("icon");
        if (imageName != null) {
            String pluginID = config.getNamespaceIdentifier();
            Image image = PDEPlugin.getDefault().getLabelProvider().getImageFromPlugin(pluginID, imageName);
            element.setImage(image);
        }
        return element;
    }

    public void dispose() {
        super.dispose();
        PDEPlugin.getDefault().getLabelProvider().disconnect(this);
    }

    @Override
    public boolean performFinish() {
        try {
            this.fJarsPage.updateData();
            this.fMainPage.updateData();
            this.fUpdatePage.updateData();
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfig);
            this.getContainer().run(false, true, (IRunnableWithProgress)new NewLibraryPluginCreationOperation(this.fPluginData, this.fProjectProvider, null));
            IWorkingSet[] workingSets = this.fMainPage.getSelectedWorkingSets();
            this.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)this.fProjectProvider.getProject(), workingSets);
            return true;
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
        }
        catch (InterruptedException interruptedException) {}
        return false;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.fConfig = config;
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        this.fMainPage.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Button updateRefsCheck = (Button)e.getSource();
                if (updateRefsCheck.getSelection()) {
                    NewLibraryPluginProjectWizard.this.fUpdatePage.setVisible(true);
                } else {
                    NewLibraryPluginProjectWizard.this.fUpdatePage.setVisible(false);
                }
            }
        });
    }
}

