/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.internal.core.target.RepositoryBundleContainer;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.shared.target.RepositoryLocationWizard;
import org.eclipse.pde.ui.target.ITargetLocationHandler;
import org.eclipse.swt.graphics.Image;
import org.osgi.resource.Requirement;

public class RepositoryBundleContainerAdapterFactory
implements IAdapterFactory {
    private static final Object[] EMPTY_OBJECTS = new Object[0];
    public static final ILabelProvider LABEL_PROVIDER = new LabelProvider(){
        private Image repositoryImage;
        private Image requirementImage;

        /*
         * WARNING - void declaration
         */
        public String getText(Object element) {
            Object object = element;
            if (object instanceof RepositoryBundleContainer) {
                void container;
                RepositoryBundleContainer repositoryBundleContainer = (RepositoryBundleContainer)object;
                RepositoryBundleContainer cfr_ignored_0 = (RepositoryBundleContainer)object;
                try {
                    return container.getLocation(true);
                }
                catch (CoreException coreException) {
                    return container.getUri();
                }
            }
            Object object2 = element;
            if (object2 instanceof RequirementNode) {
                void requirement;
                RequirementNode requirementNode = (RequirementNode)object2;
                RequirementNode cfr_ignored_1 = (RequirementNode)object2;
                return requirement.requirement().toString();
            }
            return null;
        }

        public Image getImage(Object element) {
            if (element instanceof RepositoryBundleContainer) {
                if (this.repositoryImage == null) {
                    this.repositoryImage = PDEPluginImages.DESC_TARGET_REPO.createImage();
                }
                return this.repositoryImage;
            }
            if (element instanceof RequirementNode) {
                if (this.requirementImage == null) {
                    this.requirementImage = PDEPluginImages.DESC_FILTER.createImage();
                }
                return this.requirementImage;
            }
            return null;
        }

        public void dispose() {
            super.dispose();
            if (this.repositoryImage != null) {
                this.repositoryImage.dispose();
                this.repositoryImage = null;
            }
        }
    };
    private static final ITargetLocationHandler LOCATION_HANDLER = new ITargetLocationHandler(){

        /*
         * WARNING - void declaration
         */
        @Override
        public IStatus reload(ITargetDefinition target, ITargetLocation[] targetLocations, IProgressMonitor monitor) {
            ITargetLocation[] iTargetLocationArray = targetLocations;
            int n = targetLocations.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetLocation location = iTargetLocationArray[n2];
                ITargetLocation iTargetLocation = location;
                if (iTargetLocation instanceof RepositoryBundleContainer) {
                    void container;
                    RepositoryBundleContainer cfr_ignored_0 = (RepositoryBundleContainer)iTargetLocation;
                    RepositoryBundleContainer cfr_ignored_1 = (RepositoryBundleContainer)iTargetLocation;
                    container.reload();
                }
                ++n2;
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public IWizard getEditWizard(ITargetDefinition target, TreePath treePath) {
            Object object;
            Object segment = treePath.getLastSegment();
            Object object2 = segment;
            if (object2 instanceof RequirementNode) {
                void node;
                RequirementNode requirementNode = (RequirementNode)object2;
                RequirementNode cfr_ignored_0 = (RequirementNode)object2;
                segment = node.container;
            }
            if ((object = segment) instanceof RepositoryBundleContainer) {
                void container;
                RepositoryBundleContainer repositoryBundleContainer = (RepositoryBundleContainer)object;
                RepositoryBundleContainer cfr_ignored_1 = (RepositoryBundleContainer)object;
                RepositoryLocationWizard wizard = new RepositoryLocationWizard();
                wizard.setTarget(target);
                wizard.setBundleContainer((RepositoryBundleContainer)container);
                return wizard;
            }
            return null;
        }

        @Override
        public boolean canEdit(ITargetDefinition target, TreePath treePath) {
            Object segment = treePath.getLastSegment();
            return segment instanceof RepositoryBundleContainer || segment instanceof RequirementNode;
        }

        @Override
        public boolean canRemove(ITargetDefinition target, TreePath treePath) {
            return treePath.getLastSegment() instanceof RequirementNode;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public IStatus remove(ITargetDefinition target, TreePath[] treePaths) {
            boolean reload = false;
            TreePath[] treePathArray = treePaths;
            int n = treePaths.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath path = treePathArray[n2];
                Object lastSegment = path.getLastSegment();
                Object object = lastSegment;
                if (object instanceof RequirementNode) {
                    void node;
                    RequirementNode cfr_ignored_0 = (RequirementNode)object;
                    RequirementNode cfr_ignored_1 = (RequirementNode)object;
                    RepositoryBundleContainer container = node.container;
                    RepositoryBundleContainer newContainer = new RepositoryBundleContainer(container.getUri(), container.getRequirements().stream().filter(arg_0 -> 2.lambda$0((RequirementNode)node, arg_0)).toList());
                    ITargetLocation[] targetLocations = target.getTargetLocations();
                    int i = 0;
                    while (i < targetLocations.length) {
                        ITargetLocation loc = targetLocations[i];
                        if (loc == container) {
                            targetLocations[i] = newContainer;
                        }
                        ++i;
                    }
                }
                ++n2;
            }
            return reload ? new Status(0, "org.eclipse.pde.ui", 102, "reloaded", null) : Status.OK_STATUS;
        }

        private static /* synthetic */ boolean lambda$0(RequirementNode requirementNode, Requirement req) {
            return req != requirementNode.requirement();
        }
    };
    private static final ITreeContentProvider TREE_CONTENT_PROVIDER = new ITreeContentProvider(){

        /*
         * WARNING - void declaration
         */
        public boolean hasChildren(Object element) {
            Object object = element;
            if (object instanceof RepositoryBundleContainer) {
                void container;
                RepositoryBundleContainer repositoryBundleContainer = (RepositoryBundleContainer)object;
                RepositoryBundleContainer cfr_ignored_0 = (RepositoryBundleContainer)object;
                return !container.getRequirements().isEmpty();
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        public Object getParent(Object element) {
            Object object = element;
            if (object instanceof RequirementNode) {
                void node;
                RequirementNode requirementNode = (RequirementNode)object;
                RequirementNode cfr_ignored_0 = (RequirementNode)object;
                return node.container;
            }
            return null;
        }

        public Object[] getElements(Object inputElement) {
            return EMPTY_OBJECTS;
        }

        /*
         * WARNING - void declaration
         */
        public Object[] getChildren(Object parentElement) {
            Object object = parentElement;
            if (object instanceof RepositoryBundleContainer) {
                void container;
                RepositoryBundleContainer repositoryBundleContainer = (RepositoryBundleContainer)object;
                RepositoryBundleContainer cfr_ignored_0 = (RepositoryBundleContainer)object;
                return container.getRequirements().stream().map(arg_0 -> 3.lambda$0((RepositoryBundleContainer)container, arg_0)).toArray();
            }
            return EMPTY_OBJECTS;
        }

        private static /* synthetic */ RequirementNode lambda$0(RepositoryBundleContainer repositoryBundleContainer, Requirement req) {
            return new RequirementNode(req, repositoryBundleContainer);
        }
    };

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (adaptableObject instanceof RepositoryBundleContainer || adaptableObject instanceof RequirementNode) {
            if (adapterType == ILabelProvider.class) {
                return adapterType.cast(LABEL_PROVIDER);
            }
            if (adapterType == ITargetLocationHandler.class) {
                return adapterType.cast(LOCATION_HANDLER);
            }
            if (adapterType == ITreeContentProvider.class) {
                return adapterType.cast(TREE_CONTENT_PROVIDER);
            }
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{ILabelProvider.class, ITargetLocationHandler.class, ITreeContentProvider.class};
    }

    public record RequirementNode(Requirement requirement, RepositoryBundleContainer container) {
    }
}

