/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.pde.internal.ui.editor.PDEDetails;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public abstract class PDEFormPage
extends FormPage {
    private Control fLastFocusControl = null;

    public PDEFormPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    public void dispose() {
        Menu menu;
        Control c = this.getPartControl();
        if (c != null && !c.isDisposed() && (menu = c.getMenu()) != null) {
            this.resetMenu(menu, c);
        }
        super.dispose();
    }

    /*
     * WARNING - void declaration
     */
    private void resetMenu(Menu menu, Control c) {
        Menu cmenu;
        Control control = c;
        if (control instanceof Composite) {
            void comp;
            Control[] children;
            Composite composite = (Composite)control;
            Composite cfr_ignored_0 = (Composite)control;
            Control[] controlArray = children = comp.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.resetMenu(menu, child);
                ++n2;
            }
        }
        if ((cmenu = c.getMenu()) != null && cmenu.equals(menu)) {
            c.setMenu(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void createFormContent(IManagedForm managedForm) {
        IFormPart[] parts;
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        toolkit.decorateFormHeading(form.getForm());
        IToolBarManager manager = form.getToolBarManager();
        this.getPDEEditor().contributeToToolbar(manager);
        final String helpContextID = this.getHelpResource();
        if (helpContextID != null) {
            Action helpAction = new Action("help"){

                public void run() {
                    PlatformUI.getWorkbench().getHelpSystem().displayHelp(helpContextID);
                }
            };
            helpAction.setToolTipText(PDEUIMessages.PDEFormPage_help);
            helpAction.setImageDescriptor(PDEPluginImages.DESC_HELP);
            manager.add((IAction)helpAction);
        }
        IFormPart[] iFormPartArray = parts = managedForm.getParts();
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            IFormPart part = iFormPartArray[n2];
            IFormPart iFormPart = part;
            if (iFormPart instanceof IAdaptable) {
                void adapter;
                IAdaptable cfr_ignored_0 = (IAdaptable)iFormPart;
                IAdaptable cfr_ignored_1 = (IAdaptable)iFormPart;
                IAction[] actions = (IAction[])adapter.getAdapter(IAction[].class);
                if (actions != null) {
                    IAction[] iActionArray = actions;
                    int n3 = actions.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IAction action = iActionArray[n4];
                        form.getToolBarManager().add(action);
                        ++n4;
                    }
                }
            }
            ++n2;
        }
        form.updateToolBar();
    }

    public PDEFormEditor getPDEEditor() {
        return (PDEFormEditor)this.getEditor();
    }

    protected String getHelpResource() {
        return null;
    }

    public IBaseModel getModel() {
        return this.getPDEEditor().getAggregateModel();
    }

    public void contextMenuAboutToShow(IMenuManager menu) {
    }

    protected static Control getFocusControl(IFormPage page) {
        IManagedForm form = page.getManagedForm();
        if (form == null) {
            return null;
        }
        ScrolledForm control = form.getForm();
        if (control == null || control.isDisposed()) {
            return null;
        }
        Display display = control.getDisplay();
        Control focusControl = display.getFocusControl();
        if (focusControl == null || focusControl.isDisposed()) {
            return null;
        }
        return focusControl;
    }

    public static boolean performGlobalAction(String actionId, IFormPage formPage) {
        Control focusControl = PDEFormPage.getFocusControl(formPage);
        if (focusControl == null) {
            return false;
        }
        if (PDEFormPage.canPerformDirectly(actionId, focusControl)) {
            return true;
        }
        AbstractFormPart focusPart = PDEFormPage.getFocusSection(formPage);
        if (focusPart != null) {
            if (focusPart instanceof PDESection) {
                return ((PDESection)focusPart).doGlobalAction(actionId);
            }
            if (focusPart instanceof PDEDetails) {
                return ((PDEDetails)focusPart).doGlobalAction(actionId);
            }
        }
        return false;
    }

    public boolean canPaste(Clipboard clipboard) {
        AbstractFormPart focusPart = PDEFormPage.getFocusSection((IFormPage)this);
        if (focusPart != null) {
            if (focusPart instanceof PDESection) {
                return ((PDESection)focusPart).canPaste(clipboard);
            }
            if (focusPart instanceof PDEDetails) {
                return ((PDEDetails)focusPart).canPaste(clipboard);
            }
        }
        return false;
    }

    public boolean canCopy(ISelection selection) {
        AbstractFormPart focusPart = PDEFormPage.getFocusSection((IFormPage)this);
        if (focusPart != null) {
            if (focusPart instanceof PDESection) {
                return ((PDESection)focusPart).canCopy(selection);
            }
            if (focusPart instanceof PDEDetails) {
                return ((PDEDetails)focusPart).canCopy(selection);
            }
        }
        return false;
    }

    public boolean canCut(ISelection selection) {
        AbstractFormPart focusPart = PDEFormPage.getFocusSection((IFormPage)this);
        if (focusPart != null) {
            if (focusPart instanceof PDESection) {
                return ((PDESection)focusPart).canCut(selection);
            }
            if (focusPart instanceof PDEDetails) {
                return ((PDEDetails)focusPart).canCut(selection);
            }
        }
        return false;
    }

    private static AbstractFormPart getFocusSection(IFormPage page) {
        Control focusControl = PDEFormPage.getFocusControl(page);
        if (focusControl == null) {
            return null;
        }
        Composite parent = focusControl.getParent();
        AbstractFormPart targetPart = null;
        while (parent != null) {
            Object data = parent.getData("part");
            if (data != null && data instanceof AbstractFormPart) {
                targetPart = (AbstractFormPart)data;
                break;
            }
            parent = parent.getParent();
        }
        return targetPart;
    }

    protected static boolean canPerformDirectly(String id, IFormPage page) {
        Control focusControl = PDEFormPage.getFocusControl(page);
        if (focusControl == null) {
            return false;
        }
        return PDEFormPage.canPerformDirectly(id, focusControl);
    }

    /*
     * WARNING - void declaration
     */
    protected static boolean canPerformDirectly(String id, Control control) {
        Control control2 = control;
        if (control2 instanceof Text) {
            void text;
            Text text2 = (Text)control2;
            Text cfr_ignored_0 = (Text)control2;
            if (id.equals(ActionFactory.CUT.getId())) {
                text.cut();
                return true;
            }
            if (id.equals(ActionFactory.COPY.getId())) {
                text.copy();
                return true;
            }
            if (id.equals(ActionFactory.PASTE.getId())) {
                text.paste();
                return true;
            }
            if (id.equals(ActionFactory.SELECT_ALL.getId())) {
                text.selectAll();
                return true;
            }
            if (id.equals(ActionFactory.DELETE.getId())) {
                int count = text.getSelectionCount();
                if (count == 0) {
                    int caretPos = text.getCaretPosition();
                    text.setSelection(caretPos, caretPos + 1);
                }
                text.insert("");
                return true;
            }
        }
        return false;
    }

    public void cancelEdit() {
        IFormPart[] parts;
        IFormPart[] iFormPartArray = parts = this.getManagedForm().getParts();
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            IFormPart part = iFormPartArray[n2];
            if (part instanceof IContextPart) {
                ((IContextPart)part).cancelEdit();
            }
            ++n2;
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        IManagedForm managedForm = this.getManagedForm();
        if (managedForm != null) {
            this.addLastFocusListeners((Composite)managedForm.getForm());
        }
    }

    public void addLastFocusListeners(Composite composite) {
        Control[] controls;
        Control[] controlArray = controls = composite.getChildren();
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Text || control instanceof Button || control instanceof Combo || control instanceof CCombo || control instanceof Tree || control instanceof Table || control instanceof Spinner || control instanceof Link || control instanceof List || control instanceof TabFolder || control instanceof CTabFolder || control instanceof Hyperlink || control instanceof FilteredTree) {
                this.addLastFocusListener(control);
            }
            if (control instanceof Composite) {
                this.addLastFocusListeners((Composite)control);
            }
            ++n2;
        }
    }

    private void addLastFocusListener(final Control control) {
        control.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                PDEFormPage.this.fLastFocusControl = control;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public void updateFormSelection() {
        if (this.fLastFocusControl != null && !this.fLastFocusControl.isDisposed()) {
            Control lastControl = this.fLastFocusControl;
            lastControl.forceFocus();
            Control control = lastControl;
            if (control instanceof Text) {
                void text;
                Text text2 = (Text)control;
                Text cfr_ignored_0 = (Text)control;
                text.setSelection(0, text.getText().length());
            }
        } else {
            this.setFocus();
        }
    }

    public Control getLastFocusControl() {
        return this.fLastFocusControl;
    }

    public void setLastFocusControl(Control control) {
        this.fLastFocusControl = control;
    }

    protected void createFormErrorContent(IManagedForm managedForm, String errorTitle, String errorMessage, Exception e) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        toolkit.decorateFormHeading(form.getForm());
        Composite parent = form.getBody();
        GridLayout layout = new GridLayout();
        GridData data2 = new GridData(1808);
        layout.marginWidth = 7;
        layout.marginHeight = 7;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)data2);
        form.setText(errorTitle);
        form.setImage(JFaceResources.getImage((String)"dialog_message_error_image"));
        int sectionStyle = 384;
        Section messageSection = this.createUISection(parent, PDEUIMessages.PDEFormPage_titleMessage, errorMessage, sectionStyle);
        Composite messageClient = this.createUISectionContainer((Composite)messageSection, 1);
        toolkit.paintBordersFor(messageClient);
        messageSection.setClient((Control)messageClient);
        if (e == null) {
            return;
        }
        Section detailsSection = this.createUISection(parent, PDEUIMessages.PDEFormPage_titleDetails, e.getMessage(), sectionStyle);
        Composite detailsClient = this.createUISectionContainer((Composite)detailsSection, 1);
        int style = 778;
        Text text = toolkit.createText(detailsClient, this.getStackTrace(e), style);
        GridData data = new GridData(768);
        data.heightHint = 160;
        data.widthHint = 200;
        text.setLayoutData((Object)data);
        toolkit.paintBordersFor(detailsClient);
        detailsSection.setClient((Control)detailsClient);
    }

    public Section createUISection(Composite parent, String text, String description, int style) {
        Section section = this.getManagedForm().getToolkit().createSection(parent, style);
        section.clientVerticalSpacing = 6;
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        section.setText(text);
        section.setDescription(description);
        GridData data = new GridData(768);
        section.setLayoutData((Object)data);
        return section;
    }

    public Composite createUISectionContainer(Composite parent, int columns) {
        Composite container = this.getManagedForm().getToolkit().createComposite(parent);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, columns));
        return container;
    }

    /*
     * Loose catch block
     */
    private String getStackTrace(Throwable throwable) {
        try {
            Throwable throwable2 = null;
            Object var3_4 = null;
            try {
                String string;
                PrintWriter pwriter;
                StringWriter swriter;
                block18: {
                    swriter = new StringWriter();
                    pwriter = new PrintWriter(swriter);
                    throwable.printStackTrace(pwriter);
                    pwriter.flush();
                    pwriter.close();
                    string = swriter.toString();
                    if (pwriter != null) {
                        pwriter.close();
                    }
                    if (swriter == null) break block18;
                    swriter.close();
                }
                return string;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (pwriter != null) {
                                pwriter.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            if (swriter != null) {
                                swriter.close();
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable2 == null) {
                    throwable2 = throwable5;
                } else if (throwable2 != throwable5) {
                    throwable2.addSuppressed(throwable5);
                }
                throw throwable2;
            }
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public void alignSectionHeaders(Section masterSection, Section detailsSection) {
        detailsSection.descriptionVerticalSpacing += masterSection.getTextClientHeightDifference();
    }
}

