/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.dialogs;

import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

public class FeatureSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = "org.eclipse.pde.ui.dialogs.FeatureSelectionDialog";
    private final IFeatureModel[] fModels;
    private FeatureSearchItemsFilter filter;

    public FeatureSelectionDialog(Shell parent, IFeatureModel[] models, boolean multiSelect) {
        super(parent, multiSelect);
        this.setTitle(PDEUIMessages.FeatureSelectionDialog_title);
        this.setMessage(PDEUIMessages.FeatureSelectionDialog_message);
        this.setDetailsLabelProvider((ILabelProvider)new FeatureDetailsLabelProvider());
        this.fModels = models;
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
        this.setListLabelProvider((ILabelProvider)PDEPlugin.getDefault().getLabelProvider());
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.pde.doc.user.feature_selection");
    }

    public boolean close() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        return super.close();
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = PDEPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = PDEPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        this.filter = new FeatureSearchItemsFilter();
        return this.filter;
    }

    protected Comparator<?> getItemsComparator() {
        return new FeatureSearchComparator();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        IFeatureModel[] iFeatureModelArray = this.fModels;
        int n = this.fModels.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureModel model = iFeatureModelArray[n2];
            contentProvider.add((Object)model, itemsFilter);
            progressMonitor.worked(1);
            ++n2;
        }
        progressMonitor.done();
    }

    /*
     * WARNING - void declaration
     */
    public String getElementName(Object item) {
        Object object = item;
        if (object instanceof IFeatureModel) {
            void model;
            IFeatureModel iFeatureModel = (IFeatureModel)object;
            IFeatureModel cfr_ignored_0 = (IFeatureModel)object;
            return model.getFeature().getId();
        }
        return null;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, PDEUIMessages.ManifestEditor_addActionText, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private final class FeatureDetailsLabelProvider
    extends LabelProvider {
        private FeatureDetailsLabelProvider() {
        }

        /*
         * WARNING - void declaration
         */
        public String getText(Object element) {
            Object object = element;
            if (object instanceof IFeatureModel) {
                void featureModel;
                IFeatureModel iFeatureModel = (IFeatureModel)object;
                IFeatureModel cfr_ignored_0 = (IFeatureModel)object;
                if (FeatureSelectionDialog.this.filter.matchesFeatureId((IFeatureModel)featureModel)) {
                    return NLS.bind((String)PDEUIMessages.FeatureSelectionDialog_IdMatched, (Object)featureModel.getFeature().getId());
                }
                String pluginMatch = FeatureSelectionDialog.this.filter.matchesPluginId((IFeatureModel)element);
                if (pluginMatch != null) {
                    return NLS.bind((String)PDEUIMessages.FeatureSelectionDialog_PluginMatched, (Object)pluginMatch);
                }
            }
            return super.getText(element);
        }
    }

    private static class FeatureSearchComparator
    implements Comparator<Object> {
        private FeatureSearchComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            int id2;
            int id1 = this.getId(o1);
            if (id1 != (id2 = this.getId(o2))) {
                return id1 - id2;
            }
            return this.compareSimilarObjects(o1, o2);
        }

        private int getId(Object element) {
            if (element instanceof IFeatureModel) {
                return 100;
            }
            return 0;
        }

        /*
         * WARNING - void declaration
         */
        private int compareSimilarObjects(Object o1, Object o2) {
            Object object = o1;
            if (object instanceof IFeatureModel) {
                IFeatureModel iFeatureModel = (IFeatureModel)object;
                IFeatureModel cfr_ignored_0 = (IFeatureModel)object;
                if (o2 instanceof IFeatureModel) {
                    void ipmb1;
                    IFeatureModel ipmb2 = (IFeatureModel)o2;
                    return this.compareFeatures(ipmb1.getFeature(), ipmb2.getFeature());
                }
            }
            return 0;
        }

        private int compareFeatures(IFeature ipmb1, IFeature ipmb2) {
            return ipmb1.getId().compareTo(ipmb2.getId());
        }
    }

    private class FeatureSearchItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        public FeatureSearchItemsFilter() {
            super((FilteredItemsSelectionDialog)FeatureSelectionDialog.this);
            Object pattern = this.patternMatcher.getPattern();
            if (((String)pattern).indexOf(42) != 0 && ((String)pattern).indexOf(63) != 0 && ((String)pattern).indexOf(46) != 0) {
                pattern = "*" + (String)pattern;
                this.patternMatcher.setPattern((String)pattern);
            }
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public boolean matchItem(Object item) {
            Object object = item;
            if (object instanceof IFeatureModel) {
                void model;
                IFeatureModel iFeatureModel = (IFeatureModel)object;
                IFeatureModel cfr_ignored_0 = (IFeatureModel)object;
                if (this.matchesFeatureId((IFeatureModel)model)) {
                    return true;
                }
                return this.matchesPluginId((IFeatureModel)model) != null;
            }
            return false;
        }

        public String matchesPluginId(IFeatureModel model) {
            IFeaturePlugin[] plugins;
            IFeaturePlugin[] iFeaturePluginArray = plugins = model.getFeature().getPlugins();
            int n = plugins.length;
            int n2 = 0;
            while (n2 < n) {
                IFeaturePlugin plugin = iFeaturePluginArray[n2];
                if (this.matches(plugin.getId())) {
                    return plugin.getId();
                }
                ++n2;
            }
            return null;
        }

        public boolean matchesFeatureId(IFeatureModel model) {
            String id = model.getFeature().getId();
            return this.matches(id);
        }
    }
}

