/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.graphing.ui.wizards.filter;

import org.eclipse.linuxtools.internal.systemtap.graphing.ui.Localization;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.wizards.filter.AggregateFactory;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.wizards.filter.FilterWizardPage;
import org.eclipse.linuxtools.systemtap.graphing.core.filters.UniqueFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.ColumnLayout;

public class UniqueFilterWizardPage
extends FilterWizardPage {
    private final SelectionListener btnSelectionListener = new SelectionAdapter(){

        /*
         * WARNING - void declaration
         */
        public void widgetSelected(SelectionEvent e) {
            Widget widget = e.widget;
            if (widget instanceof Button) {
                Button button = (Button)widget;
                Button cfr_ignored_0 = (Button)widget;
                Button[] buttonArray = UniqueFilterWizardPage.this.btnAggregates;
                int n = UniqueFilterWizardPage.this.btnAggregates.length;
                int n2 = 0;
                while (n2 < n) {
                    void target;
                    Button button2 = buttonArray[n2];
                    if (target == button2) {
                        UniqueFilterWizardPage.this.lblDesc.setText(AggregateFactory.getAggregateName(button2.getData().toString()) + "\n\n" + AggregateFactory.getAggregateDescription(button2.getData().toString()));
                        UniqueFilterWizardPage.this.aggregateID = button2.getData().toString();
                        UniqueFilterWizardPage.this.createFilter();
                        UniqueFilterWizardPage.this.wizard.getContainer().updateButtons();
                    }
                    ++n2;
                }
            }
        }
    };
    private Combo cboColumn;
    private Button[] btnAggregates;
    private Label lblDesc;
    private String aggregateID;

    public UniqueFilterWizardPage() {
        super("selectFilterOptions");
        this.setTitle(Localization.getString("UniqueFilterWizardPage.CreateUniqueFilter"));
        this.aggregateID = "";
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new FormLayout());
        FormData data1 = new FormData();
        data1.left = new FormAttachment(0, 0);
        data1.top = new FormAttachment(0, 0);
        data1.right = new FormAttachment(40, 0);
        data1.bottom = new FormAttachment(100, 0);
        Composite cmpFilterOpts = new Composite(comp, 0);
        cmpFilterOpts.setLayoutData((Object)data1);
        ColumnLayout colLayout = new ColumnLayout();
        colLayout.maxNumColumns = 1;
        cmpFilterOpts.setLayout((Layout)colLayout);
        Label lblColumn = new Label(cmpFilterOpts, 0);
        lblColumn.setText(Localization.getString("UniqueFilterWizardPage.Column"));
        this.cboColumn = new Combo(cmpFilterOpts, 12);
        this.cboColumn.addSelectionListener(this.selectionListener);
        String[] stringArray = this.wizard.series;
        int n = this.wizard.series.length;
        int n2 = 0;
        while (n2 < n) {
            String series = stringArray[n2];
            this.cboColumn.add(series);
            ++n2;
        }
        new Label(cmpFilterOpts, 0);
        Label lblAggregate = new Label(cmpFilterOpts, 0);
        lblAggregate.setText(Localization.getString("UniqueFilterWizardPage.Aggregate"));
        this.btnAggregates = new Button[AggregateFactory.AGGREGATES.length];
        int i = 0;
        while (i < this.btnAggregates.length) {
            this.btnAggregates[i] = new Button(cmpFilterOpts, 16);
            this.btnAggregates[i].setText(AggregateFactory.getAggregateName(AggregateFactory.AGGREGATES[i]));
            this.btnAggregates[i].addSelectionListener(this.btnSelectionListener);
            this.btnAggregates[i].setData((Object)AggregateFactory.AGGREGATES[i]);
            ++i;
        }
        FormData data2 = new FormData();
        data2.left = new FormAttachment((Control)cmpFilterOpts);
        data2.top = new FormAttachment(0, 0);
        data2.right = new FormAttachment(100, 0);
        data2.bottom = new FormAttachment(100, 0);
        this.lblDesc = new Label(comp, 64);
        this.lblDesc.setLayoutData((Object)data2);
        this.cboColumn.select(0);
        this.createFilter();
        this.setControl((Control)comp);
    }

    @Override
    public boolean canFlipToNextPage() {
        return false;
    }

    @Override
    protected void createFilter() {
        int selected = this.cboColumn.getSelectionIndex();
        if (selected >= 0 && selected < this.cboColumn.getItemCount() && this.aggregateID != null && !this.aggregateID.isEmpty()) {
            this.filter = new UniqueFilter(selected, AggregateFactory.createAggregate(this.aggregateID));
        }
    }

    @Override
    public void dispose() {
        if (this.cboColumn != null) {
            this.cboColumn.removeSelectionListener(this.selectionListener);
            this.cboColumn.dispose();
            this.cboColumn = null;
        }
        if (this.lblDesc != null) {
            this.lblDesc.dispose();
        }
        this.lblDesc = null;
        if (this.btnAggregates != null) {
            int i = 0;
            while (i < this.btnAggregates.length) {
                this.btnAggregates[i].removeSelectionListener(this.btnSelectionListener);
                this.btnAggregates[i].dispose();
                this.btnAggregates[i] = null;
                ++i;
            }
            this.btnAggregates = null;
        }
        this.aggregateID = null;
        super.dispose();
    }
}

