/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph.launch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.linuxtools.internal.callgraph.core.PluginConstants;
import org.eclipse.linuxtools.internal.callgraph.core.SystemTapUIErrorMessages;
import org.eclipse.linuxtools.internal.callgraph.launch.Messages;
import org.eclipse.linuxtools.internal.callgraph.launch.SystemTapLaunchShortcut;
import org.eclipse.ui.IEditorPart;

public class LaunchStapGraph
extends SystemTapLaunchShortcut {
    private String partialScriptPath;
    private String funcs = null;
    private List<String> exclusions = new ArrayList<String>();
    private String projectName = null;
    protected static final String ATTR_PARSER = "org.eclipse.linuxtools.callgraph.graphparser";
    protected static final String ATTR_VIEWER = "org.eclipse.linuxtools.callgraph.callgraphview";

    public void launch(IEditorPart ed, String mode) {
        this.resourceToSearchFor = ed.getTitle();
        this.searchForResource = true;
        super.launch(ed, mode);
    }

    @Override
    public void launch(IBinary bin, String mode) {
        this.launch(bin, mode, null);
    }

    public void launch(IBinary bin, String mode, ILaunchConfigurationWorkingCopy wc) {
        super.initialize();
        this.bin = bin;
        this.name = "SystemTapGraph";
        this.binName = this.getName(bin);
        this.partialScriptPath = PluginConstants.getPluginLocation() + "parse_function_partial.stp";
        this.viewID = ATTR_VIEWER;
        this.projectName = bin.getCProject().getElementName();
        try {
            if (wc == null) {
                wc = this.createConfiguration(bin, this.name);
            }
            this.arguments = this.binaryPath = bin.getResource().getLocation().toString();
            this.outputPath = PluginConstants.getDefaultIOPath();
            if (this.writeFunctionListToScript(this.resourceToSearchFor) == null) {
                return;
            }
            if (this.funcs == null || this.funcs.length() < 0) {
                return;
            }
            try {
                this.needToGenerate = true;
                this.finishLaunch(this.name, mode, wc);
            }
            catch (IOException e) {
                SystemTapUIErrorMessages mess = new SystemTapUIErrorMessages("LaunchShortcutScriptGen", Messages.getString("LaunchStapGraph.ScriptGenErr"), Messages.getString("LaunchStapGraph.ScriptGenErrMsg"));
                mess.schedule();
                e.printStackTrace();
            }
        }
        finally {
            this.resourceToSearchFor = "";
            this.searchForResource = false;
        }
    }

    private String generateProbe(String function) {
        return "probe process(@1).function(\"" + function + "\").call ? {    if ( ! isinstr(\"" + function + "\", \"___STAP_MARKER___\")) { callFunction(\"" + function + "\",tid()) }     }    probe process(@1).function(\"" + function + "\").return ? {        if ( ! isinstr(\"" + function + "\", \"___STAP_MARKER___\")) returnFunction(\"" + function + "\",tid())    else { printf(\"?%d,,%s\\n\", tid(), user_string(strtol(tokenize($$return, \"return=\"),16)))}}\n";
    }

    private String writeFunctionListToScript(String resourceToSearchFor) {
        String toWrite = this.getFunctionsFromBinary(this.bin, resourceToSearchFor);
        if (toWrite == null || toWrite.isEmpty()) {
            return null;
        }
        StringBuilder output = new StringBuilder();
        String[] stringArray = toWrite.split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String func = stringArray[n2];
            if (!func.isEmpty() && (this.exclusions == null || this.exclusions.size() < 1 || this.exclusions.contains(func))) {
                output.append(this.generateProbe(func));
            }
            ++n2;
        }
        this.funcs = output.toString();
        return this.funcs;
    }

    private String writeFromPartialScript(String projectName) throws IOException {
        Object toWrite = "";
        String temp = "";
        toWrite = (String)toWrite + "\nprobe begin{\nprintf(\"\\nPROBE_BEGIN\\n\")\nserial=1\nstartTime = 0;\nprintf(\"" + projectName + "\\n\")\n}";
        File partialScript = new File(this.partialScriptPath);
        Throwable throwable = null;
        Object var6_7 = null;
        try (BufferedReader scriptReader = new BufferedReader(new FileReader(partialScript));){
            while ((temp = scriptReader.readLine()) != null) {
                toWrite = (String)toWrite + temp + "\n";
            }
            scriptReader.close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return toWrite;
    }

    @Override
    public String generateScript() throws IOException {
        Object scriptContents = "";
        scriptContents = (String)scriptContents + this.funcs;
        scriptContents = (String)scriptContents + this.writeFromPartialScript(this.projectName);
        return scriptContents;
    }

    @Override
    public String setScriptPath() {
        this.scriptPath = PluginConstants.getDefaultOutput() + "callgraphGen.stp";
        return this.scriptPath;
    }

    @Override
    public String setParserID() {
        this.parserID = ATTR_PARSER;
        return this.parserID;
    }

    @Override
    public String setViewID() {
        return ATTR_VIEWER;
    }
}

