/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;

public class ConfigurationOptionsSetter {
    public static String setOptions(ILaunchConfiguration config) {
        StringBuilder options = new StringBuilder();
        try {
            int verboseLevel = config.getAttribute("org.eclipse.linuxtools.callgraph.launch.COMMAND_VERBOSE", 0);
            if (verboseLevel > 0) {
                StringBuilder builder = new StringBuilder();
                builder.append("-");
                int i = 0;
                while (i < verboseLevel) {
                    builder.append("v");
                    ++i;
                }
                builder.append(" ");
                options.append(builder.toString());
            }
            if (config.getAttribute("org.eclipse.linuxtools.callgraph.launch.PASS", 0) > 0) {
                options.append("-p" + config.getAttribute("org.eclipse.linuxtools.callgraph.launch.PASS", 0) + " ");
            }
            if (config.getAttribute("org.eclipse.linuxtools.callgraph.launch.KEEP_TEMPORARY", false)) {
                options.append("-k ");
            }
            if (config.getAttribute("org.eclipse.linuxtools.callgraph.launch.GURU", false)) {
                options.append("-g ");
            }
            if (config.getAttribute("org.eclipse.linuxtools.callgraph.launch.PROLOGUE_SEARCH", false)) {
                options.append("-P ");
            }
            if (config.getAttribute("org.eclipse.linuxtools.callgraph.launch.NO_CODE_ELISION", false)) {
                options.append("-u ");
            }
            if (config.getAttribute("org.eclipse.linuxtools.callgraph.launch.DISABLE_WARNINGS", false)) {
                options.append("-w ");
            }
            if (config.getAttribute("org.eclipse.linuxtools.callgraph.launch.BULK_MODE", false)) {
                options.append("-b ");
            }
            if (config.getAttribute("org.eclipse.linuxtools.callgraph.launch.TIMING_INFO", false)) {
                options.append("-t ");
            }
            if (config.getAttribute("org.eclipse.linuxtools.callgraph.launch.BUFFER_BYTES", 0) > 0) {
                options.append("-s" + config.getAttribute("org.eclipse.linuxtools.callgraph.launch.BUFFER_BYTES", 0) + " ");
            }
            if (config.getAttribute("org.eclipse.linuxtools.callgraph.launch.TARGET_PID", 0) > 0) {
                options.append("-x" + config.getAttribute("org.eclipse.linuxtools.callgraph.launch.TARGET_PID", 0) + " ");
            }
            if (config.getAttribute("org.eclipse.linuxtools.callgraph.launch.C_DIRECTIVES", "") != "") {
                options.append(config.getAttribute("org.eclipse.linuxtools.callgraph.launch.C_DIRECTIVES", "") + " ");
            }
            if (config.getAttribute("org.eclipse.linuxtools.callgraph.launch.LEAVE_RUNNING", false)) {
                options.append("-F ");
            }
            if (config.getAttribute("org.eclipse.linuxtools.callgraph.launch.SKIP_BADVARS", false)) {
                options.append("--skip-badvars ");
            }
            if (config.getAttribute("org.eclipse.linuxtools.callgraph.launch.IGNORE_DWARF", false)) {
                options.append("--ignore-dwarf ");
            }
            if (config.getAttribute("org.eclipse.linuxtools.callgraph.launch.TAPSET_COVERAGE", false)) {
                options.append("-q ");
            }
            return options.toString();
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }
}

