/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Impact implements Enumerator
{
    MICRO(0, "Micro", "Micro"),
    MINOR(1, "Minor", "Minor"),
    MAJOR(2, "Major", "Major");

    public static final int MICRO_VALUE = 0;
    public static final int MINOR_VALUE = 1;
    public static final int MAJOR_VALUE = 2;
    private static final Impact[] VALUES_ARRAY;
    public static final List<Impact> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Impact[]{MICRO, MINOR, MAJOR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Impact get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Impact result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Impact getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Impact result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Impact get(int value) {
        switch (value) {
            case 0: {
                return MICRO;
            }
            case 1: {
                return MINOR;
            }
            case 2: {
                return MAJOR;
            }
        }
        return null;
    }

    private Impact(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

