/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text;

import org.eclipse.dltk.internal.ui.editor.semantic.highlighting.ContributedSemanticHighlighter;
import org.eclipse.dltk.internal.ui.text.DLTKColorManager;
import org.eclipse.dltk.ui.editor.highlighting.ISemanticHighlighter;
import org.eclipse.dltk.ui.editor.highlighting.ISemanticHighlightingUpdater;
import org.eclipse.dltk.ui.editor.highlighting.SemanticHighlighting;
import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.dltk.ui.text.IPartitioningProvider;
import org.eclipse.dltk.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.dltk.ui.text.templates.TemplateVariableProcessor;
import org.eclipse.dltk.utils.NatureExtensionManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class ScriptTextTools
implements IPartitioningProvider {
    private DLTKColorManager fColorManager;
    private final String fDefaultPartitioning;
    private final String[] fLegalContentTypes;
    private static NatureExtensionManager<ISemanticHighlighter> highlighterManager = null;

    protected ScriptTextTools(String defaultPartitioning, String[] legalContentTypes, boolean autoDisposeOnDisplayDispose) {
        this.fDefaultPartitioning = defaultPartitioning;
        this.fLegalContentTypes = legalContentTypes;
        this.fColorManager = new DLTKColorManager(autoDisposeOnDisplayDispose);
    }

    @Override
    public String getPartitioning() {
        return this.fDefaultPartitioning;
    }

    @Override
    public String[] getPartitionContentTypes() {
        return this.fLegalContentTypes;
    }

    public void dispose() {
        if (this.fColorManager != null) {
            this.fColorManager.dispose();
            this.fColorManager = null;
        }
    }

    public IColorManager getColorManager() {
        return this.fColorManager;
    }

    public final ScriptSourceViewerConfiguration createSourceViewerConfiguraton(IPreferenceStore preferenceStore, ITextEditor editor) {
        return this.createSourceViewerConfiguraton(preferenceStore, editor, this.fDefaultPartitioning);
    }

    public abstract ScriptSourceViewerConfiguration createSourceViewerConfiguraton(IPreferenceStore var1, ITextEditor var2, String var3);

    public ScriptSourceViewerConfiguration createSourceViewerConfiguraton(IPreferenceStore preferenceStore, ITextEditor editor, TemplateVariableProcessor variableProcessor) {
        return this.createSourceViewerConfiguraton(preferenceStore, editor, this.fDefaultPartitioning);
    }

    @Override
    public IPartitionTokenScanner createPartitionScanner() {
        return this.getPartitionScanner();
    }

    @Deprecated
    public IPartitionTokenScanner getPartitionScanner() {
        return null;
    }

    public IDocumentPartitioner createDocumentPartitioner() {
        IPartitionTokenScanner scaner = this.createPartitionScanner();
        if (scaner == null) {
            return null;
        }
        return new FastPartitioner(scaner, this.fLegalContentTypes);
    }

    public void setupDefaultDocumentPartitioner(IDocument document) {
        this.setupDocumentPartitioner(document, "__dftl_partitioning");
    }

    public void setupDocumentPartitioner(IDocument document) {
        this.setupDocumentPartitioner(document, this.fDefaultPartitioning);
    }

    public void setupDocumentPartitioner(IDocument document, String partitioning) {
        IDocumentPartitioner partitioner = this.createDocumentPartitioner();
        if (partitioner != null) {
            partitioner.connect(document);
            if (document instanceof IDocumentExtension3) {
                IDocumentExtension3 extension3 = (IDocumentExtension3)document;
                extension3.setDocumentPartitioner(partitioning, partitioner);
            } else {
                document.setDocumentPartitioner(partitioner);
            }
        }
    }

    @Deprecated
    public SemanticHighlighting[] getSemanticHighlightings() {
        return new SemanticHighlighting[0];
    }

    @Deprecated
    protected final void getSemanticPositionUpdater() {
    }

    public ISemanticHighlightingUpdater getSemanticPositionUpdater(String natureId) {
        ISemanticHighlighter[] highlighters;
        if (highlighterManager == null) {
            highlighterManager = new NatureExtensionManager<ISemanticHighlighter>("org.eclipse.dltk.ui.highlighting", ISemanticHighlighter.class){

                protected void saveInstances(String natureId, ISemanticHighlighter[] resultArray) {
                }
            };
        }
        if ((highlighters = (ISemanticHighlighter[])highlighterManager.getInstances(natureId)) != null && highlighters.length != 0) {
            return new ContributedSemanticHighlighter(natureId, highlighters);
        }
        return null;
    }

    public String getDefaultPartitioning() {
        return this.fDefaultPartitioning;
    }
}

