/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.execute;

import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.dialogs.MultilineInputDialog;
import org.eclipse.datatools.sqltools.sqlbuilder.views.execute.ParameterElement;
import org.eclipse.datatools.sqltools.sqlbuilder.views.execute.ParameterTableViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class InputValueCellEditor
extends ComboBoxCellEditor
implements SelectionListener {
    protected CCombo myCombo;
    private Table myTable;
    private int lastSelectedRow = -1;
    private int lastEditedIndex = -1;
    private ParameterTableViewer myViewer;

    public InputValueCellEditor(Composite parent, ParameterTableViewer viewer, String[] items) {
        super(parent, items);
        this.myViewer = viewer;
        this.myTable = (Table)parent;
        this.myTable.addSelectionListener((SelectionListener)this);
    }

    protected Control createControl(Composite parent) {
        this.myCombo = (CCombo)super.createControl(parent);
        this.myCombo.addSelectionListener((SelectionListener)this);
        return this.myCombo;
    }

    public void focusLost() {
        TableItem tabItem;
        Object obj;
        if (this.lastSelectedRow != this.lastEditedIndex) {
            return;
        }
        String textData = this.myCombo.getText();
        if (this.lastSelectedRow != -1 && textData != null && (obj = (tabItem = this.myTable.getItem(this.lastSelectedRow)).getData()) instanceof ParameterElement) {
            ((ParameterElement)obj).setValue(textData);
            this.refreshViewer();
        }
    }

    protected void refreshViewer() {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                InputValueCellEditor.this.myViewer.refresh();
            }
        });
        this.myViewer.getParameterMarkerPage().updateFinishButton();
    }

    public void widgetDefaultSelected(SelectionEvent evt) {
    }

    public void widgetSelected(SelectionEvent evt) {
        Object source = evt.getSource();
        if (source == this.myCombo) {
            this.showInputEditor();
        } else if (source == this.myTable) {
            this.lastSelectedRow = this.myTable.getSelectionIndex();
        }
    }

    protected void doSetValue(Object value) {
        if (value instanceof ParameterElement) {
            this.lastEditedIndex = this.myTable.getSelectionIndex();
            ParameterElement ele = (ParameterElement)value;
            this.myCombo.setText(ele.getColumnText(2));
        }
    }

    protected String showInputEditor() {
        TableItem tabItem = this.myTable.getItem(this.myTable.getSelectionIndex());
        ParameterElement parm = (ParameterElement)tabItem.getData();
        String initialText = parm.getColumnText(2);
        MultilineInputDialog inputDialog = new MultilineInputDialog(Display.getDefault().getActiveShell(), Messages._UI_SPECIFY_VALUE_TITLE, parm.getColumnText(0));
        inputDialog.setText(initialText);
        inputDialog.open();
        String text = inputDialog.getText();
        parm.setValue(text);
        this.doSetValue(parm);
        this.refreshViewer();
        return text;
    }
}

