/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.RemoteManager;
import org.mandas.docker.client.messages.swarm.SwarmCluster;
import org.mandas.docker.client.messages.swarm.SwarmInfo;

final class ImmutableSwarmInfo
implements SwarmInfo {
    @Nullable
    private final SwarmCluster cluster;
    private final boolean controlAvailable;
    private final String error;
    private final String localNodeState;
    private final String nodeAddr;
    private final String nodeId;
    @Nullable
    private final Integer nodes;
    @Nullable
    private final Integer managers;
    @Nullable
    private final List<RemoteManager> remoteManagers;

    private ImmutableSwarmInfo(@Nullable SwarmCluster cluster, boolean controlAvailable, String error, String localNodeState, String nodeAddr, String nodeId, @Nullable Integer nodes, @Nullable Integer managers, @Nullable List<RemoteManager> remoteManagers) {
        this.cluster = cluster;
        this.controlAvailable = controlAvailable;
        this.error = error;
        this.localNodeState = localNodeState;
        this.nodeAddr = nodeAddr;
        this.nodeId = nodeId;
        this.nodes = nodes;
        this.managers = managers;
        this.remoteManagers = remoteManagers;
    }

    @Override
    @JsonProperty(value="Cluster")
    @Nullable
    public SwarmCluster cluster() {
        return this.cluster;
    }

    @Override
    @JsonProperty(value="ControlAvailable")
    public boolean controlAvailable() {
        return this.controlAvailable;
    }

    @Override
    @JsonProperty(value="Error")
    public String error() {
        return this.error;
    }

    @Override
    @JsonProperty(value="LocalNodeState")
    public String localNodeState() {
        return this.localNodeState;
    }

    @Override
    @JsonProperty(value="NodeAddr")
    public String nodeAddr() {
        return this.nodeAddr;
    }

    @Override
    @JsonProperty(value="NodeID")
    public String nodeId() {
        return this.nodeId;
    }

    @Override
    @JsonProperty(value="Nodes")
    @Nullable
    public Integer nodes() {
        return this.nodes;
    }

    @Override
    @JsonProperty(value="Managers")
    @Nullable
    public Integer managers() {
        return this.managers;
    }

    @Override
    @JsonProperty(value="RemoteManagers")
    @Nullable
    public List<RemoteManager> remoteManagers() {
        return this.remoteManagers;
    }

    public final ImmutableSwarmInfo withCluster(@Nullable SwarmCluster value) {
        if (this.cluster == value) {
            return this;
        }
        return new ImmutableSwarmInfo(value, this.controlAvailable, this.error, this.localNodeState, this.nodeAddr, this.nodeId, this.nodes, this.managers, this.remoteManagers);
    }

    public final ImmutableSwarmInfo withControlAvailable(boolean value) {
        if (this.controlAvailable == value) {
            return this;
        }
        return new ImmutableSwarmInfo(this.cluster, value, this.error, this.localNodeState, this.nodeAddr, this.nodeId, this.nodes, this.managers, this.remoteManagers);
    }

    public final ImmutableSwarmInfo withError(String value) {
        String newValue = Objects.requireNonNull(value, "error");
        if (this.error.equals(newValue)) {
            return this;
        }
        return new ImmutableSwarmInfo(this.cluster, this.controlAvailable, newValue, this.localNodeState, this.nodeAddr, this.nodeId, this.nodes, this.managers, this.remoteManagers);
    }

    public final ImmutableSwarmInfo withLocalNodeState(String value) {
        String newValue = Objects.requireNonNull(value, "localNodeState");
        if (this.localNodeState.equals(newValue)) {
            return this;
        }
        return new ImmutableSwarmInfo(this.cluster, this.controlAvailable, this.error, newValue, this.nodeAddr, this.nodeId, this.nodes, this.managers, this.remoteManagers);
    }

    public final ImmutableSwarmInfo withNodeAddr(String value) {
        String newValue = Objects.requireNonNull(value, "nodeAddr");
        if (this.nodeAddr.equals(newValue)) {
            return this;
        }
        return new ImmutableSwarmInfo(this.cluster, this.controlAvailable, this.error, this.localNodeState, newValue, this.nodeId, this.nodes, this.managers, this.remoteManagers);
    }

    public final ImmutableSwarmInfo withNodeId(String value) {
        String newValue = Objects.requireNonNull(value, "nodeId");
        if (this.nodeId.equals(newValue)) {
            return this;
        }
        return new ImmutableSwarmInfo(this.cluster, this.controlAvailable, this.error, this.localNodeState, this.nodeAddr, newValue, this.nodes, this.managers, this.remoteManagers);
    }

    public final ImmutableSwarmInfo withNodes(@Nullable Integer value) {
        if (Objects.equals(this.nodes, value)) {
            return this;
        }
        return new ImmutableSwarmInfo(this.cluster, this.controlAvailable, this.error, this.localNodeState, this.nodeAddr, this.nodeId, value, this.managers, this.remoteManagers);
    }

    public final ImmutableSwarmInfo withManagers(@Nullable Integer value) {
        if (Objects.equals(this.managers, value)) {
            return this;
        }
        return new ImmutableSwarmInfo(this.cluster, this.controlAvailable, this.error, this.localNodeState, this.nodeAddr, this.nodeId, this.nodes, value, this.remoteManagers);
    }

    public final ImmutableSwarmInfo withRemoteManagers(RemoteManager ... elements) {
        if (elements == null) {
            return new ImmutableSwarmInfo(this.cluster, this.controlAvailable, this.error, this.localNodeState, this.nodeAddr, this.nodeId, this.nodes, this.managers, null);
        }
        List<RemoteManager> newValue = Arrays.asList(elements) == null ? null : ImmutableSwarmInfo.createUnmodifiableList(false, ImmutableSwarmInfo.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSwarmInfo(this.cluster, this.controlAvailable, this.error, this.localNodeState, this.nodeAddr, this.nodeId, this.nodes, this.managers, newValue);
    }

    public final ImmutableSwarmInfo withRemoteManagers(@Nullable Iterable<? extends RemoteManager> elements) {
        if (this.remoteManagers == elements) {
            return this;
        }
        List<RemoteManager> newValue = elements == null ? null : ImmutableSwarmInfo.createUnmodifiableList(false, ImmutableSwarmInfo.createSafeList(elements, true, false));
        return new ImmutableSwarmInfo(this.cluster, this.controlAvailable, this.error, this.localNodeState, this.nodeAddr, this.nodeId, this.nodes, this.managers, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSwarmInfo && this.equalTo((ImmutableSwarmInfo)another);
    }

    private boolean equalTo(ImmutableSwarmInfo another) {
        return Objects.equals(this.cluster, another.cluster) && this.controlAvailable == another.controlAvailable && this.error.equals(another.error) && this.localNodeState.equals(another.localNodeState) && this.nodeAddr.equals(another.nodeAddr) && this.nodeId.equals(another.nodeId) && Objects.equals(this.nodes, another.nodes) && Objects.equals(this.managers, another.managers) && Objects.equals(this.remoteManagers, another.remoteManagers);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.cluster);
        h += (h << 5) + Boolean.hashCode(this.controlAvailable);
        h += (h << 5) + this.error.hashCode();
        h += (h << 5) + this.localNodeState.hashCode();
        h += (h << 5) + this.nodeAddr.hashCode();
        h += (h << 5) + this.nodeId.hashCode();
        h += (h << 5) + Objects.hashCode(this.nodes);
        h += (h << 5) + Objects.hashCode(this.managers);
        h += (h << 5) + Objects.hashCode(this.remoteManagers);
        return h;
    }

    public String toString() {
        return "SwarmInfo{cluster=" + this.cluster + ", controlAvailable=" + this.controlAvailable + ", error=" + this.error + ", localNodeState=" + this.localNodeState + ", nodeAddr=" + this.nodeAddr + ", nodeId=" + this.nodeId + ", nodes=" + this.nodes + ", managers=" + this.managers + ", remoteManagers=" + this.remoteManagers + "}";
    }

    public static ImmutableSwarmInfo copyOf(SwarmInfo instance) {
        if (instance instanceof ImmutableSwarmInfo) {
            return (ImmutableSwarmInfo)instance;
        }
        return ImmutableSwarmInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    static final class Builder {
        private static final long INIT_BIT_CONTROL_AVAILABLE = 1L;
        private static final long INIT_BIT_ERROR = 2L;
        private static final long INIT_BIT_LOCAL_NODE_STATE = 4L;
        private static final long INIT_BIT_NODE_ADDR = 8L;
        private static final long INIT_BIT_NODE_ID = 16L;
        private long initBits = 31L;
        private SwarmCluster cluster;
        private boolean controlAvailable;
        private String error;
        private String localNodeState;
        private String nodeAddr;
        private String nodeId;
        private Integer nodes;
        private Integer managers;
        private List<RemoteManager> remoteManagers = null;

        private Builder() {
        }

        public final Builder from(SwarmInfo instance) {
            List<RemoteManager> remoteManagersValue;
            Integer managersValue;
            Objects.requireNonNull(instance, "instance");
            SwarmCluster clusterValue = instance.cluster();
            if (clusterValue != null) {
                this.cluster(clusterValue);
            }
            this.controlAvailable(instance.controlAvailable());
            this.error(instance.error());
            this.localNodeState(instance.localNodeState());
            this.nodeAddr(instance.nodeAddr());
            this.nodeId(instance.nodeId());
            Integer nodesValue = instance.nodes();
            if (nodesValue != null) {
                this.nodes(nodesValue);
            }
            if ((managersValue = instance.managers()) != null) {
                this.managers(managersValue);
            }
            if ((remoteManagersValue = instance.remoteManagers()) != null) {
                this.addAllRemoteManagers(remoteManagersValue);
            }
            return this;
        }

        @JsonProperty(value="Cluster")
        public final Builder cluster(@Nullable SwarmCluster cluster) {
            this.cluster = cluster;
            return this;
        }

        @JsonProperty(value="ControlAvailable")
        public final Builder controlAvailable(boolean controlAvailable) {
            this.controlAvailable = controlAvailable;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Error")
        public final Builder error(String error) {
            this.error = Objects.requireNonNull(error, "error");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="LocalNodeState")
        public final Builder localNodeState(String localNodeState) {
            this.localNodeState = Objects.requireNonNull(localNodeState, "localNodeState");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="NodeAddr")
        public final Builder nodeAddr(String nodeAddr) {
            this.nodeAddr = Objects.requireNonNull(nodeAddr, "nodeAddr");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="NodeID")
        public final Builder nodeId(String nodeId) {
            this.nodeId = Objects.requireNonNull(nodeId, "nodeId");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="Nodes")
        public final Builder nodes(@Nullable Integer nodes) {
            this.nodes = nodes;
            return this;
        }

        @JsonProperty(value="Managers")
        public final Builder managers(@Nullable Integer managers) {
            this.managers = managers;
            return this;
        }

        public final Builder remoteManager(RemoteManager element) {
            if (this.remoteManagers == null) {
                this.remoteManagers = new ArrayList<RemoteManager>();
            }
            this.remoteManagers.add(Objects.requireNonNull(element, "remoteManagers element"));
            return this;
        }

        public final Builder remoteManagers(RemoteManager ... elements) {
            if (this.remoteManagers == null) {
                this.remoteManagers = new ArrayList<RemoteManager>();
            }
            for (RemoteManager element : elements) {
                this.remoteManagers.add(Objects.requireNonNull(element, "remoteManagers element"));
            }
            return this;
        }

        @JsonProperty(value="RemoteManagers")
        public final Builder remoteManagers(@Nullable Iterable<? extends RemoteManager> elements) {
            if (elements == null) {
                this.remoteManagers = null;
                return this;
            }
            this.remoteManagers = new ArrayList<RemoteManager>();
            return this.addAllRemoteManagers(elements);
        }

        public final Builder addAllRemoteManagers(Iterable<? extends RemoteManager> elements) {
            Objects.requireNonNull(elements, "remoteManagers element");
            if (this.remoteManagers == null) {
                this.remoteManagers = new ArrayList<RemoteManager>();
            }
            for (RemoteManager remoteManager : elements) {
                this.remoteManagers.add(Objects.requireNonNull(remoteManager, "remoteManagers element"));
            }
            return this;
        }

        public ImmutableSwarmInfo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSwarmInfo(this.cluster, this.controlAvailable, this.error, this.localNodeState, this.nodeAddr, this.nodeId, this.nodes, this.managers, this.remoteManagers == null ? null : ImmutableSwarmInfo.createUnmodifiableList(true, this.remoteManagers));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("controlAvailable");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("error");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("localNodeState");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("nodeAddr");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("nodeId");
            }
            return "Cannot build SwarmInfo, some of required attributes are not set " + attributes;
        }
    }
}

