/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.GlobalJob;
import org.mandas.docker.client.messages.swarm.GlobalService;
import org.mandas.docker.client.messages.swarm.ReplicatedJob;
import org.mandas.docker.client.messages.swarm.ReplicatedService;
import org.mandas.docker.client.messages.swarm.ServiceMode;

final class ImmutableServiceMode
implements ServiceMode {
    @Nullable
    private final ReplicatedService replicated;
    @Nullable
    private final ReplicatedJob replicatedJob;
    @Nullable
    private final GlobalService global;
    @Nullable
    private final GlobalJob globalJob;

    private ImmutableServiceMode(@Nullable ReplicatedService replicated, @Nullable ReplicatedJob replicatedJob, @Nullable GlobalService global, @Nullable GlobalJob globalJob) {
        this.replicated = replicated;
        this.replicatedJob = replicatedJob;
        this.global = global;
        this.globalJob = globalJob;
    }

    @Override
    @JsonProperty(value="Replicated")
    @Nullable
    public ReplicatedService replicated() {
        return this.replicated;
    }

    @Override
    @JsonProperty(value="ReplicatedJob")
    @Nullable
    public ReplicatedJob replicatedJob() {
        return this.replicatedJob;
    }

    @Override
    @JsonProperty(value="Global")
    @Nullable
    public GlobalService global() {
        return this.global;
    }

    @Override
    @JsonProperty(value="GlobalJob")
    @Nullable
    public GlobalJob globalJob() {
        return this.globalJob;
    }

    public final ImmutableServiceMode withReplicated(@Nullable ReplicatedService value) {
        if (this.replicated == value) {
            return this;
        }
        return new ImmutableServiceMode(value, this.replicatedJob, this.global, this.globalJob);
    }

    public final ImmutableServiceMode withReplicatedJob(@Nullable ReplicatedJob value) {
        if (this.replicatedJob == value) {
            return this;
        }
        return new ImmutableServiceMode(this.replicated, value, this.global, this.globalJob);
    }

    public final ImmutableServiceMode withGlobal(@Nullable GlobalService value) {
        if (this.global == value) {
            return this;
        }
        return new ImmutableServiceMode(this.replicated, this.replicatedJob, value, this.globalJob);
    }

    public final ImmutableServiceMode withGlobalJob(@Nullable GlobalJob value) {
        if (this.globalJob == value) {
            return this;
        }
        return new ImmutableServiceMode(this.replicated, this.replicatedJob, this.global, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableServiceMode && this.equalTo((ImmutableServiceMode)another);
    }

    private boolean equalTo(ImmutableServiceMode another) {
        return Objects.equals(this.replicated, another.replicated) && Objects.equals(this.replicatedJob, another.replicatedJob) && Objects.equals(this.global, another.global) && Objects.equals(this.globalJob, another.globalJob);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.replicated);
        h += (h << 5) + Objects.hashCode(this.replicatedJob);
        h += (h << 5) + Objects.hashCode(this.global);
        h += (h << 5) + Objects.hashCode(this.globalJob);
        return h;
    }

    public String toString() {
        return "ServiceMode{replicated=" + this.replicated + ", replicatedJob=" + this.replicatedJob + ", global=" + this.global + ", globalJob=" + this.globalJob + "}";
    }

    public static ImmutableServiceMode copyOf(ServiceMode instance) {
        if (instance instanceof ImmutableServiceMode) {
            return (ImmutableServiceMode)instance;
        }
        return ImmutableServiceMode.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder
    implements ServiceMode.Builder {
        private ReplicatedService replicated;
        private ReplicatedJob replicatedJob;
        private GlobalService global;
        private GlobalJob globalJob;

        private Builder() {
        }

        public final Builder from(ServiceMode instance) {
            GlobalJob globalJobValue;
            GlobalService globalValue;
            ReplicatedJob replicatedJobValue;
            Objects.requireNonNull(instance, "instance");
            ReplicatedService replicatedValue = instance.replicated();
            if (replicatedValue != null) {
                this.replicated(replicatedValue);
            }
            if ((replicatedJobValue = instance.replicatedJob()) != null) {
                this.replicatedJob(replicatedJobValue);
            }
            if ((globalValue = instance.global()) != null) {
                this.global(globalValue);
            }
            if ((globalJobValue = instance.globalJob()) != null) {
                this.globalJob(globalJobValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="Replicated")
        public final Builder replicated(@Nullable ReplicatedService replicated) {
            this.replicated = replicated;
            return this;
        }

        @Override
        @JsonProperty(value="ReplicatedJob")
        public final Builder replicatedJob(@Nullable ReplicatedJob replicatedJob) {
            this.replicatedJob = replicatedJob;
            return this;
        }

        @Override
        @JsonProperty(value="Global")
        public final Builder global(@Nullable GlobalService global) {
            this.global = global;
            return this;
        }

        @Override
        @JsonProperty(value="GlobalJob")
        public final Builder globalJob(@Nullable GlobalJob globalJob) {
            this.globalJob = globalJob;
            return this;
        }

        @Override
        public ImmutableServiceMode build() {
            return new ImmutableServiceMode(this.replicated, this.replicatedJob, this.global, this.globalJob);
        }
    }
}

