/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal;

import org.eclipse.wst.xml.xpath2.api.ResultBuffer;
import org.eclipse.wst.xml.xpath2.processor.internal.ForwardAxis;
import org.eclipse.wst.xml.xpath2.processor.internal.types.DocType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.ElementType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ChildAxis
extends ForwardAxis {
    @Override
    public void iterate(NodeType node, ResultBuffer copyInto, Node limitNode) {
        this.addChildren(node, copyInto, false);
    }

    protected void addChildren(NodeType node, ResultBuffer copyInto, boolean recurse) {
        NodeList nl = null;
        if (node instanceof DocType) {
            nl = ((DocType)node).value().getChildNodes();
        }
        if (node instanceof ElementType) {
            nl = ((ElementType)node).value().getChildNodes();
        }
        if (nl != null) {
            int i = 0;
            while (i < nl.getLength()) {
                Node dnode = nl.item(i);
                NodeType n = NodeType.dom_to_xpath(dnode, node.getTypeModel());
                if (n != null) {
                    copyInto.add(n);
                    if (recurse) {
                        this.addChildren(n, copyInto, recurse);
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public String name() {
        return "child";
    }
}

