/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.IPerformanceMonitor;
import org.eclipse.wst.validation.PerformanceCounters;
import org.eclipse.wst.validation.internal.Tracing;
import org.eclipse.wst.validation.internal.ValMessages;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public class PerformanceMonitor
implements IPerformanceMonitor {
    private IPerformanceMonitor.CollectionLevel _level = IPerformanceMonitor.CollectionLevel.None;
    private boolean _summaryOnly;

    public static PerformanceMonitor create(boolean traceTimes, String file, boolean logInSeconds) {
        PerformanceMonitor pm = null;
        pm = file == null || file.length() == 0 ? new PerformanceMonitor() : new ToFile(file, logInSeconds);
        if (traceTimes) {
            pm.setCollectionLevel(IPerformanceMonitor.CollectionLevel.Default);
        }
        return pm;
    }

    private PerformanceMonitor() {
    }

    @Override
    public IPerformanceMonitor.CollectionLevel getCollectionLevel() {
        return this._level;
    }

    @Override
    public void setCollectionLevel(IPerformanceMonitor.CollectionLevel level) {
        this._level = level;
    }

    @Override
    public List<PerformanceCounters> getPerformanceCounters(boolean asSummary) {
        return new LinkedList<PerformanceCounters>();
    }

    @Override
    public void resetPerformanceCounters() {
    }

    @Override
    public boolean isCollecting() {
        return this._level != IPerformanceMonitor.CollectionLevel.None;
    }

    @Override
    public boolean isSummaryOnly() {
        return this._summaryOnly;
    }

    @Override
    public void add(PerformanceCounters counters) {
        Tracing.write(counters.toString());
    }

    public static class Collecting
    extends PerformanceMonitor {
        private List<PerformanceCounters> _counters = new LinkedList<PerformanceCounters>();

        @Override
        public void add(PerformanceCounters counters) {
            this._counters.add(counters);
        }

        @Override
        public List<PerformanceCounters> getPerformanceCounters(boolean asSummary) {
            if (asSummary) {
                HashMap<String, Counters> map = new HashMap<String, Counters>(40);
                for (PerformanceCounters pc : this._counters) {
                    Counters c = (Counters)map.get(pc.getValidatorId());
                    if (c == null) {
                        c = new Counters();
                        c.name = pc.getValidatorName();
                        map.put(pc.getValidatorId(), c);
                    }
                    c.numberInvocations += pc.getNumberInvocations();
                    c.elapsedTime += pc.getElapsedTime();
                    if (pc.getCpuTime() != -1L) {
                        c.cpuTime += pc.getCpuTime();
                        continue;
                    }
                    c.cpuTime = -1L;
                }
                LinkedList<PerformanceCounters> list = new LinkedList<PerformanceCounters>();
                for (Map.Entry me : map.entrySet()) {
                    Counters c = (Counters)me.getValue();
                    list.add(new PerformanceCounters((String)me.getKey(), c.name, null, c.numberInvocations, c.elapsedTime, c.cpuTime));
                }
                return list;
            }
            return this._counters;
        }

        @Override
        public void resetPerformanceCounters() {
            this._counters.clear();
        }
    }

    public static class Counters {
        String name;
        int numberInvocations;
        long elapsedTime;
        long cpuTime;
    }

    public static class ToFile
    extends PerformanceMonitor {
        private String _fileName;
        private boolean _logInSeconds;
        private PrintWriter _pw;
        private static final String Comma = ",";
        private static DateFormat _df = new SimpleDateFormat("HH:mm:ss.SSSS");

        private ToFile(String fileName, boolean logInSeconds) {
            this._fileName = fileName;
            this._logInSeconds = logInSeconds;
        }

        @Override
        public synchronized void add(PerformanceCounters pc) {
            try {
                PrintWriter pw = this.getWriter();
                pw.print(String.valueOf(_df.format(pc.getWhen())) + Comma + pc.getValidatorId() + Comma + pc.getNumberInvocations() + Comma);
                if (this._logInSeconds) {
                    double sec = (double)pc.getElapsedTime() / 1000.0;
                    pw.print(sec);
                    pw.print(Comma);
                    sec = (double)pc.getCpuTime() / 1.0E9;
                    pw.print(sec);
                } else {
                    pw.print(String.valueOf(pc.getElapsedTime()) + Comma + pc.getCpuTime());
                }
                pw.println(Comma + pc.getResourceName());
                pw.flush();
            }
            catch (IOException e) {
                ValidationPlugin.getPlugin().handleException(e);
            }
        }

        private PrintWriter getWriter() throws IOException {
            if (this._pw == null) {
                this._pw = new PrintWriter(new FileOutputStream(this._fileName, true));
                DateFormat df = DateFormat.getDateTimeInstance();
                this._pw.println("# " + NLS.bind((String)ValMessages.LogSession, (Object)df.format(new Date(System.currentTimeMillis()))));
                if (this._logInSeconds) {
                    this._pw.println("# when, id, invocation count, elapsed time (seconds), cpu time (seconds), resource");
                } else {
                    this._pw.println("# when, id, invocation count, elapsed time (ms), cpu time (ns), resource");
                }
            }
            return this._pw;
        }
    }
}

