/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.openon;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.internal.openon.IOpenOn;
import org.eclipse.wst.sse.ui.internal.openon.OpenOnBuilder;
import org.eclipse.wst.sse.ui.internal.openon.OpenOnDefinition;

public class OpenOnProvider {
    private static OpenOnProvider fInstance;

    public static synchronized OpenOnProvider getInstance() {
        if (fInstance == null) {
            fInstance = new OpenOnProvider();
        }
        return fInstance;
    }

    protected String getContentType(IDocument document) {
        String type = null;
        IModelManager mgr = StructuredModelManager.getModelManager();
        IStructuredModel model = null;
        try {
            model = mgr.getExistingModelForRead(document);
            if (model != null) {
                type = model.getContentTypeIdentifier();
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return type;
    }

    public IOpenOn getOpenOn(IDocument document, int offset) {
        IOpenOn openOn = null;
        if (document != null) {
            String contentTypeID = this.getContentType(document);
            String partitionType = this.getPartitionType(document, offset);
            IContentType contentType = Platform.getContentTypeManager().getContentType(contentTypeID);
            while (openOn == null && contentType != null) {
                OpenOnDefinition[] defs = OpenOnBuilder.getInstance().getOpenOnDefinitions(contentType.getId(), partitionType);
                contentType = contentType.getBaseType();
                if (defs == null || defs.length <= 0) continue;
                openOn = defs[0].createOpenOn();
            }
        }
        return openOn;
    }

    protected String getPartitionType(IDocument document, int offset) {
        String type;
        block17: {
            type = null;
            try {
                try {
                    if (document instanceof IStructuredDocument) {
                        type = TextUtilities.getContentType((IDocument)document, (String)"org.eclipse.wst.sse.core.default_structured_text_partitioning", (int)offset, (boolean)false);
                    }
                }
                catch (BadLocationException badLocationException) {
                    if (type != null) break block17;
                    try {
                        ITypedRegion region = document.getPartition(offset);
                        if (region != null) {
                            type = region.getType();
                        }
                        break block17;
                    }
                    catch (BadLocationException badLocationException2) {
                        type = null;
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (type == null) {
                    try {
                        ITypedRegion region = document.getPartition(offset);
                        if (region != null) {
                            type = region.getType();
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        type = null;
                    }
                }
                throw throwable;
            }
            if (type == null) {
                try {
                    ITypedRegion region = document.getPartition(offset);
                    if (region != null) {
                        type = region.getType();
                    }
                }
                catch (BadLocationException badLocationException) {
                    type = null;
                }
            }
        }
        return type;
    }
}

