/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.internal.preferences.ui;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.templates.TemplatePreferencePage;
import org.eclipse.wst.css.core.internal.provisional.contenttype.ContentTypeIdForCSS;
import org.eclipse.wst.css.ui.StructuredTextViewerConfigurationCSS;
import org.eclipse.wst.css.ui.internal.CSSUIPlugin;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.StructuredTextViewerConfiguration;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;

public class CSSTemplatePreferencePage
extends TemplatePreferencePage {
    public CSSTemplatePreferencePage() {
        CSSUIPlugin cssUIPlugin = CSSUIPlugin.getDefault();
        this.setPreferenceStore(cssUIPlugin.getPreferenceStore());
        this.setTemplateStore(cssUIPlugin.getTemplateStore());
        this.setContextTypeRegistry(cssUIPlugin.getTemplateContextRegistry());
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        CSSUIPlugin.getDefault().savePluginPreferences();
        return ok;
    }

    protected boolean isShowFormatterSetting() {
        return false;
    }

    protected Control createContents(Composite ancestor) {
        Control c = super.createContents(ancestor);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(c, "org.eclipse.wst.css.ui.webx0013");
        return c;
    }

    protected SourceViewer createViewer(Composite parent) {
        StructuredTextViewerConfiguration sourceViewerConfiguration = new StructuredTextViewerConfiguration(){
            StructuredTextViewerConfiguration baseConfiguration = new StructuredTextViewerConfigurationCSS();

            public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
                return this.baseConfiguration.getConfiguredContentTypes(sourceViewer);
            }

            public LineStyleProvider[] getLineStyleProviders(ISourceViewer sourceViewer, String partitionType) {
                return this.baseConfiguration.getLineStyleProviders(sourceViewer, partitionType);
            }
        };
        return this.doCreateViewer(parent, (SourceViewerConfiguration)sourceViewerConfiguration);
    }

    SourceViewer doCreateViewer(Composite parent, SourceViewerConfiguration viewerConfiguration) {
        StructuredTextViewer viewer = null;
        String contentTypeID = ContentTypeIdForCSS.ContentTypeID_CSS;
        viewer = new StructuredTextViewer(parent, null, null, false, 2816);
        viewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.wst.sse.ui.textfont"));
        IStructuredModel scratchModel = StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(contentTypeID);
        IStructuredDocument document = scratchModel.getStructuredDocument();
        viewer.configure(viewerConfiguration);
        viewer.setDocument((IDocument)document);
        return viewer;
    }

    protected Template editTemplate(Template template, boolean edit, boolean isNameModifiable) {
        CSSEditTemplateDialog dialog = new CSSEditTemplateDialog(this.getShell(), template, edit, isNameModifiable, this.getContextTypeRegistry());
        if (dialog.open() == 0) {
            return dialog.getTemplate();
        }
        return null;
    }

    class CSSEditTemplateDialog
    extends TemplatePreferencePage.EditTemplateDialog {
        public CSSEditTemplateDialog(Shell parent, Template template, boolean edit, boolean isNameModifiable, ContextTypeRegistry registry) {
            super(parent, template, edit, isNameModifiable, registry);
        }

        protected SourceViewer createViewer(Composite parent) {
            StructuredTextViewerConfiguration sourceViewerConfiguration = new StructuredTextViewerConfiguration(){
                StructuredTextViewerConfiguration baseConfiguration = new StructuredTextViewerConfigurationCSS();

                public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
                    return this.baseConfiguration.getConfiguredContentTypes(sourceViewer);
                }

                public LineStyleProvider[] getLineStyleProviders(ISourceViewer sourceViewer, String partitionType) {
                    return this.baseConfiguration.getLineStyleProviders(sourceViewer, partitionType);
                }

                public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
                    ContentAssistant assistant = new ContentAssistant();
                    assistant.enableAutoActivation(true);
                    assistant.enableAutoInsert(true);
                    assistant.setContentAssistProcessor(CSSEditTemplateDialog.this.getTemplateProcessor(), "__dftl_partition_content_type");
                    return assistant;
                }
            };
            return CSSTemplatePreferencePage.this.doCreateViewer(parent, (SourceViewerConfiguration)sourceViewerConfiguration);
        }
    }
}

