/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IActionDefinition;
import org.eclipse.wst.common.project.facet.core.IConstraint;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IGroup;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.IVersion;
import org.eclipse.wst.common.project.facet.core.IVersionExpr;
import org.eclipse.wst.common.project.facet.core.internal.Constraint;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacet;
import org.eclipse.wst.common.project.facet.core.util.internal.Versionable;

public final class ProjectFacetVersion
implements IProjectFacetVersion {
    private ProjectFacet facet;
    private String version;
    private final Set<String> aliases;
    private final Set<String> aliasesReadOnly;
    private IConstraint constraint;
    private String plugin;
    private Map<IProjectFacetVersion, Integer> compTable = Collections.emptyMap();
    private final Map<String, Object> properties;
    private final Map<String, Object> propertiesReadOnly;

    ProjectFacetVersion() {
        this.aliases = new HashSet<String>();
        this.aliasesReadOnly = Collections.unmodifiableSet(this.aliases);
        this.properties = new HashMap<String, Object>();
        this.propertiesReadOnly = Collections.unmodifiableMap(this.properties);
    }

    @Override
    public IProjectFacet getProjectFacet() {
        return this.facet;
    }

    void setProjectFacet(ProjectFacet facet) {
        this.facet = facet;
    }

    @Override
    public String getVersionString() {
        return this.version;
    }

    void setVersionString(String version) {
        this.version = version;
    }

    @Override
    public Set<String> getAliases() {
        return this.aliasesReadOnly;
    }

    void addAlias(String alias) {
        this.aliases.add(alias);
    }

    public Versionable<IProjectFacetVersion> getVersionable() {
        return this.facet;
    }

    @Override
    public IConstraint getConstraint() {
        if (this.constraint == null) {
            this.constraint = new Constraint(this, IConstraint.Type.AND, new Object[0]);
        }
        return this.constraint;
    }

    void setConstraint(IConstraint constraint) {
        this.constraint = constraint;
    }

    @Override
    public String getPluginId() {
        return this.plugin;
    }

    void setPluginId(String plugin) {
        this.plugin = plugin;
    }

    void setComparisonTable(Map<IProjectFacetVersion, Integer> compTable) {
        this.compTable = compTable;
    }

    @Override
    public boolean supports(Set<IProjectFacetVersion> base, IFacetedProject.Action.Type type) {
        try {
            return this.getActionDefinitionInternal(base, type) != null;
        }
        catch (CoreException e) {
            FacetCorePlugin.log((Exception)((Object)e));
            return false;
        }
    }

    @Override
    public boolean supports(IFacetedProject.Action.Type type) {
        try {
            return this.getActionDefinition(type) != null;
        }
        catch (CoreException e) {
            FacetCorePlugin.log((Exception)((Object)e));
            return false;
        }
    }

    @Override
    public Set<IActionDefinition> getActionDefinitions() {
        return this.facet.getActionDefinitions(this);
    }

    @Override
    public Set<IActionDefinition> getActionDefinitions(IFacetedProject.Action.Type type) {
        HashSet<IActionDefinition> result = new HashSet<IActionDefinition>();
        for (IActionDefinition def : this.getActionDefinitions()) {
            if (def.getActionType() != type) continue;
            result.add(def);
        }
        if (result.size() > 1 && type != IFacetedProject.Action.Type.VERSION_CHANGE) {
            String msg = Resources.bind(Resources.multipleActionDefinitions, this.facet.getId(), this.version, type.toString());
            FacetCorePlugin.logWarning(msg, true);
        }
        return result;
    }

    @Override
    public IActionDefinition getActionDefinition(Set<IProjectFacetVersion> base, IFacetedProject.Action.Type type) throws CoreException {
        IActionDefinition def = this.getActionDefinitionInternal(base, type);
        if (def == null) {
            String msg = NLS.bind((String)Resources.actionNotSupported, (Object)this.toString(), (Object)type.toString());
            throw new CoreException(FacetCorePlugin.createErrorStatus(msg));
        }
        return def;
    }

    private IActionDefinition getActionDefinitionInternal(Set<IProjectFacetVersion> base, IFacetedProject.Action.Type type) throws CoreException {
        Set<IActionDefinition> definitions = this.getActionDefinitions(type);
        if (definitions.size() > 0) {
            if (type == IFacetedProject.Action.Type.VERSION_CHANGE) {
                IProjectFacetVersion fromVersion = null;
                for (IProjectFacetVersion x : base) {
                    if (x.getProjectFacet() != this.facet) continue;
                    fromVersion = x;
                    break;
                }
                if (fromVersion != null) {
                    for (IActionDefinition def : definitions) {
                        IVersionExpr vexpr = (IVersionExpr)def.getProperty("from.versions");
                        if (vexpr != null && !vexpr.check(fromVersion)) continue;
                        return def;
                    }
                }
            } else {
                return definitions.iterator().next();
            }
        }
        return null;
    }

    public IActionDefinition getActionDefinition(IFacetedProject.Action.Type type) throws CoreException {
        Set<IActionDefinition> definitions = this.getActionDefinitions(type);
        if (definitions.size() == 0) {
            return null;
        }
        return definitions.iterator().next();
    }

    @Override
    public Object createActionConfig(IFacetedProject.Action.Type type, String pjname) throws CoreException {
        if (!this.supports(type)) {
            String msg = NLS.bind((String)Resources.actionNotSupported, (Object)this.toString(), (Object)type.toString());
            throw new CoreException(FacetCorePlugin.createErrorStatus(msg));
        }
        IActionDefinition def = this.getActionDefinition(type);
        if (def == null) {
            return null;
        }
        return def.createConfigObject(this, pjname);
    }

    @Override
    public boolean isSameActionConfig(IFacetedProject.Action.Type type, IProjectFacetVersion fv) throws CoreException {
        return ((ProjectFacetVersion)fv).getActionDefinition(type) == this.getActionDefinition(type);
    }

    @Override
    public boolean isValidFor(Set<IProjectFacet> fixed) {
        for (IProjectFacet f : fixed) {
            if (this.facet != f) continue;
            return true;
        }
        for (IProjectFacet f : fixed) {
            if (f.getVersions().size() <= 0) continue;
            boolean conflictsWithAllVersions = true;
            for (IProjectFacetVersion fv : f.getVersions()) {
                if (this.conflictsWith(fv)) continue;
                conflictsWithAllVersions = false;
                break;
            }
            if (!conflictsWithAllVersions) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean conflictsWith(IProjectFacetVersion fv) {
        if (this == fv) {
            return false;
        }
        if (this.facet == fv.getProjectFacet()) {
            return true;
        }
        return this.conflictsWith(fv, this.getConstraint()) || this.conflictsWith(this, fv.getConstraint());
    }

    private boolean conflictsWith(IProjectFacetVersion fv, IConstraint op) {
        if (op.getType() == IConstraint.Type.AND) {
            for (Object operand : op.getOperands()) {
                if (!this.conflictsWith(fv, (IConstraint)operand)) continue;
                return true;
            }
            return false;
        }
        if (op.getType() == IConstraint.Type.OR) {
            boolean allBranchesConflict = true;
            for (Object operand : op.getOperands()) {
                if (this.conflictsWith(fv, (IConstraint)operand)) continue;
                allBranchesConflict = false;
                break;
            }
            return allBranchesConflict;
        }
        if (op.getType() == IConstraint.Type.CONFLICTS) {
            Object firstOperand = op.getOperand(0);
            if (firstOperand instanceof IGroup) {
                IGroup group = (IGroup)firstOperand;
                return group.getMembers().contains(fv);
            }
            IProjectFacet f = (IProjectFacet)firstOperand;
            IVersionExpr vexpr = (IVersionExpr)op.getOperand(1);
            return fv.getProjectFacet() == f && vexpr.check(fv);
        }
        if (op.getType() == IConstraint.Type.REQUIRES) {
            Boolean soft = (Boolean)op.getOperand(op.getOperands().size() - 1);
            if (soft.equals(Boolean.TRUE)) {
                return false;
            }
            Object firstOperand = op.getOperand(0);
            boolean conflictsWithAll = true;
            if (firstOperand instanceof IGroup) {
                IGroup group = (IGroup)firstOperand;
                for (IProjectFacetVersion member : group.getMembers()) {
                    if (member.conflictsWith(fv)) continue;
                    conflictsWithAll = false;
                    break;
                }
            } else {
                IProjectFacet rf = (IProjectFacet)firstOperand;
                IVersionExpr vexpr = (IVersionExpr)op.getOperand(1);
                try {
                    String vexprstr = vexpr.toString();
                    for (IProjectFacetVersion rfv : rf.getVersions(vexprstr)) {
                        if (rfv.conflictsWith(fv)) continue;
                        conflictsWithAll = false;
                    }
                }
                catch (CoreException e) {
                    FacetCorePlugin.log((Exception)((Object)e));
                    return false;
                }
            }
            return conflictsWithAll;
        }
        throw new IllegalStateException();
    }

    public int compareTo(Object obj) {
        if (obj == this) {
            return 0;
        }
        if (obj instanceof IProjectFacetVersion) {
            IProjectFacetVersion fv = (IProjectFacetVersion)obj;
            if (fv.getProjectFacet() != this.facet) {
                String msg = Resources.bind(Resources.cannotCompareVersionsOfDifferentFacets, this.facet.getId(), this.version, fv.getProjectFacet().getId(), fv.getVersionString());
                throw new RuntimeException(msg);
            }
            Integer cachedResult = this.compTable.get(fv);
            if (cachedResult != null) {
                return cachedResult;
            }
        }
        try {
            Comparator<String> comp = this.facet.getVersionComparator();
            return comp.compare(this.version, ((IVersion)obj).getVersionString());
        }
        catch (Exception e) {
            FacetCorePlugin.log(e);
            return 0;
        }
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.propertiesReadOnly;
    }

    @Override
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public String toString() {
        if (this.facet.isVersionHidden()) {
            return this.facet.getLabel();
        }
        return String.valueOf(this.facet.getLabel()) + " " + this.version;
    }

    private static final class Resources
    extends NLS {
        public static String actionNotSupported;
        public static String multipleActionDefinitions;
        public static String cannotCompareVersionsOfDifferentFacets;

        static {
            Resources.initializeMessages((String)ProjectFacetVersion.class.getName(), Resources.class);
        }

        private Resources() {
        }

        public static String bind(String template, Object arg1, Object arg2, Object arg3) {
            return NLS.bind((String)template, (Object[])new Object[]{arg1, arg2, arg3});
        }

        public static String bind(String template, Object arg1, Object arg2, Object arg3, Object arg4) {
            return NLS.bind((String)template, (Object[])new Object[]{arg1, arg2, arg3, arg4});
        }
    }
}

