/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.layout.form;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.core.model.association.EmptyAssociation;
import org.eclipse.wb.core.model.broadcast.JavaInfoTreeAlmostComplete;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.property.ComplexProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.util.PropertyUtils;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.swt.model.layout.LayoutDataInfo;
import org.eclipse.wb.internal.swt.model.layout.form.FormAttachmentInfo;
import org.eclipse.wb.internal.swt.model.layout.form.FormSide;
import org.eclipse.wb.internal.swt.model.layout.form.IFormDataInfo;
import org.eclipse.wb.internal.swt.model.layout.form.VirtualFormAttachmentCreationSupport;
import org.eclipse.wb.internal.swt.model.layout.form.VirtualFormAttachmentVariableSupport;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.internal.swt.support.FormLayoutSupport;

public final class FormDataInfo
extends LayoutDataInfo
implements IFormDataInfo<ControlInfo> {
    private ComplexProperty m_propertyLeft;
    private ComplexProperty m_propertyRight;
    private ComplexProperty m_propertyTop;
    private ComplexProperty m_propertyBottom;

    public FormDataInfo(AstEditor editor, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(editor, description, creationSupport);
        this.addBroadcastListener(new JavaInfoTreeAlmostComplete(){

            public void invoke(JavaInfo root, List<JavaInfo> components) throws Exception {
                FormDataInfo.this.removeBroadcastListener(this);
                FormDataInfo.this.initAttachments(components);
            }
        });
    }

    private void initAttachments(List<JavaInfo> components) throws Exception {
        this.initAttachment(FormSide.LEFT, components);
        this.initAttachment(FormSide.RIGHT, components);
        this.initAttachment(FormSide.TOP, components);
        this.initAttachment(FormSide.BOTTOM, components);
    }

    private void initAttachment(FormSide side, List<JavaInfo> components) throws Exception {
        Assignment fieldAssignment = this.getFieldAssignment(side.getField());
        if (fieldAssignment != null) {
            Expression attachmentExpression = fieldAssignment.getRightHandSide();
            for (JavaInfo component : components) {
                if (!(component instanceof FormAttachmentInfo) || !component.isRepresentedBy((ASTNode)attachmentExpression)) continue;
                FormAttachmentInfo attachment = (FormAttachmentInfo)component;
                attachment.setSide(side);
                attachment.setAssociation((Association)new EmptyAssociation());
                this.addChild((ObjectInfo)component);
                attachment.readPropertiesValue();
                return;
            }
        }
        this.addVirtualAttachment(side);
    }

    private FormAttachmentInfo addVirtualAttachment(FormSide side) throws Exception {
        FormAttachmentInfo attachment = (FormAttachmentInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.getEditor(), FormLayoutSupport.getFormAttachmentClass(), (CreationSupport)new VirtualFormAttachmentCreationSupport(this, FormLayoutSupport.createFormAttachment()));
        attachment.setSide(side);
        attachment.setVariableSupport((VariableSupport)new VirtualFormAttachmentVariableSupport(attachment, side));
        attachment.setAssociation((Association)new EmptyAssociation());
        this.addChild((ObjectInfo)attachment);
        return attachment;
    }

    /*
     * WARNING - void declaration
     */
    public FormAttachmentInfo getAttachment(int sideInt) throws Exception {
        this.materialize();
        FormSide side = FormSide.get(sideInt);
        for (ObjectInfo child : this.getChildren()) {
            void attachment;
            ObjectInfo objectInfo = child;
            if (!(objectInfo instanceof FormAttachmentInfo)) continue;
            FormAttachmentInfo cfr_ignored_0 = (FormAttachmentInfo)objectInfo;
            FormAttachmentInfo cfr_ignored_1 = (FormAttachmentInfo)objectInfo;
            if (attachment.getSide() != side) continue;
            return attachment;
        }
        return this.addVirtualAttachment(side);
    }

    @Override
    public void setWidth(int value) throws Exception {
        this.getPropertyByTitle("width").setValue((Object)value);
    }

    @Override
    public void setHeight(int value) throws Exception {
        this.getPropertyByTitle("height").setValue((Object)value);
    }

    protected void refresh_finish() throws Exception {
        super.refresh_finish();
        this.ensureAttachmentProperties();
        this.updateAttachmentPropertyText(1, this.m_propertyLeft);
        this.updateAttachmentPropertyText(4, this.m_propertyRight);
        this.updateAttachmentPropertyText(8, this.m_propertyTop);
        this.updateAttachmentPropertyText(32, this.m_propertyBottom);
    }

    protected List<Property> getPropertyList() throws Exception {
        this.ensureAttachmentProperties();
        return super.getPropertyList();
    }

    private void updateAttachmentPropertyText(int side, ComplexProperty property) throws Exception {
        FormAttachmentInfo attachment = this.getAttachment(side);
        property.setText(attachment.toString());
    }

    private void ensureAttachmentProperties() throws Exception {
        if (this.m_propertyLeft == null) {
            this.m_propertyLeft = this.createAttachmentProperty(1, "left");
            this.m_propertyRight = this.createAttachmentProperty(4, "right");
            this.m_propertyTop = this.createAttachmentProperty(8, "top");
            this.m_propertyBottom = this.createAttachmentProperty(32, "bottom");
        }
    }

    protected void sortPropertyList(List<Property> properties) {
        ArrayList sorted = Lists.newArrayList();
        Property variableProperty = PropertyUtils.getByTitle(properties, (String)"Variable");
        if (variableProperty != null) {
            sorted.add(variableProperty);
        }
        sorted.add(this.m_propertyLeft);
        sorted.add(this.m_propertyRight);
        sorted.add(this.m_propertyTop);
        sorted.add(this.m_propertyBottom);
        sorted.add(PropertyUtils.getByTitle(properties, (String)"width"));
        sorted.add(PropertyUtils.getByTitle(properties, (String)"height"));
        properties.clear();
        properties.addAll(sorted);
    }

    private ComplexProperty createAttachmentProperty(int side, String title) throws Exception {
        final FormAttachmentInfo attachment = this.getAttachment(side);
        ComplexProperty attachmentProperty = new ComplexProperty(title, attachment.toString()){

            public void setValue(Object value) throws Exception {
                if (value == Property.UNKNOWN_VALUE) {
                    attachment.delete();
                }
            }
        };
        Collection selectedProperties = CollectionUtils.select(Arrays.asList(attachment.getProperties()), (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                Property property = (Property)object;
                return !property.getTitle().equals("Class") && !property.getTitle().equals("Constructor");
            }
        });
        attachmentProperty.setProperties(selectedProperties.toArray(new Property[selectedProperties.size()]));
        return attachmentProperty;
    }
}

