/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.layout;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.NotImplementedException;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.core.model.association.EmptyAssociation;
import org.eclipse.wb.core.model.association.ImplicitObjectAssociation;
import org.eclipse.wb.core.model.broadcast.JavaEventListener;
import org.eclipse.wb.core.model.broadcast.JavaInfoAddProperties;
import org.eclipse.wb.core.model.broadcast.ObjectInfoChildAddAfter;
import org.eclipse.wb.core.model.broadcast.ObjectInfoChildAddBefore;
import org.eclipse.wb.core.model.broadcast.ObjectInfoDelete;
import org.eclipse.wb.core.model.broadcast.ObjectInfoTreeComplete;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.clipboard.ClipboardCommand;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.IImplicitCreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.presentation.IObjectPresentation;
import org.eclipse.wb.internal.core.model.property.ComplexProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.editor.presentation.ButtonPropertyEditorPresentation;
import org.eclipse.wb.internal.core.model.property.editor.presentation.PropertyEditorPresentation;
import org.eclipse.wb.internal.core.model.property.table.PropertyTable;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;
import org.eclipse.wb.internal.swt.model.layout.ILayoutDataInfo;
import org.eclipse.wb.internal.swt.model.layout.ILayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.ImplicitLayoutDataCreationSupport;
import org.eclipse.wb.internal.swt.model.layout.ImplicitLayoutDataVariableSupport;
import org.eclipse.wb.internal.swt.model.layout.LayoutDataInfo;
import org.eclipse.wb.internal.swt.model.layout.LayoutNameSupport;
import org.eclipse.wb.internal.swt.model.layout.LayoutPresentation;
import org.eclipse.wb.internal.swt.model.layout.VirtualLayoutDataCreationSupport;
import org.eclipse.wb.internal.swt.model.layout.VirtualLayoutDataVariableSupport;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.internal.swt.model.widgets.IControlInfo;
import org.eclipse.wb.internal.swt.support.ContainerSupport;
import org.eclipse.wb.internal.swt.support.ControlSupport;

public class LayoutInfo
extends JavaInfo
implements ILayoutInfo<ControlInfo> {
    private ComplexProperty m_layoutComplexProperty;
    private static String KEY_EXPOSED_HAS_DATA = "exposed control: already has LayoutData";
    private static String KEY_EXPOSED_DATA = "exposed control: its LayoutData";
    private static String KEY_DONT_CREATE_VIRTUAL_DATA = "don't create virtual LayoutData for this ControlInfo";
    private static final String KEY_LAYOUT_DATA_HAS = "layout-data.has";
    private static final String KEY_LAYOUT_DATA_CLASS = "layout-data.class";
    private Class<?> m_layoutDataClass;

    public LayoutInfo(AstEditor editor, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(editor, description, creationSupport);
        this.addBroadcastListeners();
        new LayoutNameSupport(this);
    }

    private void addBroadcastListeners() {
        this.addBroadcastListener(new ObjectInfoTreeComplete(){

            public void invoke() throws Exception {
                CompositeInfo composite = LayoutInfo.this.getComposite();
                if (LayoutInfo.this.isActiveOnComposite((ObjectInfo)composite)) {
                    LayoutInfo.this.validateCorrespondence_Layout_LayoutData();
                }
                if (LayoutInfo.this.isActiveOnComposite((ObjectInfo)composite)) {
                    for (ControlInfo control : composite.getChildrenControls()) {
                        LayoutInfo.this.ensureLayoutData(control);
                    }
                }
            }
        });
        this.addBroadcastListener(new ObjectInfoChildAddBefore(){

            /*
             * WARNING - void declaration
             */
            public void invoke(ObjectInfo parent, ObjectInfo child, ObjectInfo[] nextChild) throws Exception {
                ObjectInfo objectInfo = parent;
                if (objectInfo instanceof ControlInfo) {
                    void control;
                    LayoutDataInfo existingLayoutData;
                    ControlInfo controlInfo = (ControlInfo)objectInfo;
                    ControlInfo cfr_ignored_0 = (ControlInfo)objectInfo;
                    if (child instanceof LayoutDataInfo && LayoutInfo.this.isActiveOnComposite(parent.getParent()) && (existingLayoutData = LayoutInfo.getLayoutData((ControlInfo)control)) != null) {
                        control.removeChild((ObjectInfo)existingLayoutData);
                    }
                }
            }
        });
        this.addBroadcastListener(new ObjectInfoChildAddAfter(){

            public void invoke(ObjectInfo parent, ObjectInfo child) throws Exception {
                CompositeInfo composite = LayoutInfo.this.getComposite();
                if (child == LayoutInfo.this) {
                    if (LayoutInfo.this.getCreationSupport() instanceof IImplicitCreationSupport) {
                        LayoutInfo.this.targetBroadcastListener(parent);
                    }
                    for (ControlInfo control : composite.getChildrenControls()) {
                        LayoutInfo.this.ensureLayoutData(control);
                    }
                }
            }
        });
        this.addBroadcastListener(new ObjectInfoDelete(){

            public void before(ObjectInfo parent, ObjectInfo child) throws Exception {
                if (child == LayoutInfo.this) {
                    LayoutInfo.this.onDelete();
                }
                if (LayoutInfo.this.isActiveOnComposite(parent) && child instanceof ControlInfo) {
                    LayoutInfo.this.onControlRemoveBefore((ControlInfo)child);
                }
            }

            /*
             * WARNING - void declaration
             */
            public void after(ObjectInfo parent, ObjectInfo child) throws Exception {
                ObjectInfo objectInfo;
                ObjectInfo objectInfo2 = parent;
                if (objectInfo2 instanceof ControlInfo) {
                    ControlInfo controlInfo = (ControlInfo)objectInfo2;
                    ControlInfo cfr_ignored_0 = (ControlInfo)objectInfo2;
                    if (child instanceof LayoutDataInfo && LayoutInfo.this.shouldCreateLayoutData((ControlInfo)parent) && LayoutInfo.this.isActiveOnComposite(parent.getParent())) {
                        void control;
                        LayoutInfo.this.ensureLayoutData((ControlInfo)control);
                    }
                }
                if (LayoutInfo.this.isActiveOnComposite(parent) && (objectInfo = child) instanceof ControlInfo) {
                    void control;
                    ControlInfo controlInfo = (ControlInfo)objectInfo;
                    ControlInfo cfr_ignored_1 = (ControlInfo)objectInfo;
                    if (control.isDeleted()) {
                        LayoutInfo.this.onControlRemoveAfter((ControlInfo)control);
                    }
                }
            }
        });
        this.addBroadcastListener(new JavaEventListener(){

            public void addAfter(JavaInfo parent, JavaInfo child) throws Exception {
                if (LayoutInfo.this.isActiveOnComposite((ObjectInfo)parent) && child instanceof ControlInfo) {
                    LayoutInfo.this.ensureLayoutData((ControlInfo)child);
                }
            }

            /*
             * WARNING - void declaration
             */
            public void moveBefore(JavaInfo child, ObjectInfo oldParent, JavaInfo newParent) throws Exception {
                JavaInfo javaInfo;
                if (LayoutInfo.this.isActiveOnComposite(oldParent) && (javaInfo = child) instanceof ControlInfo) {
                    ControlInfo controlInfo = (ControlInfo)javaInfo;
                    ControlInfo cfr_ignored_0 = (ControlInfo)javaInfo;
                    if (newParent != oldParent) {
                        void control;
                        LayoutInfo.this.onControlRemoveBefore((ControlInfo)control);
                        LayoutInfo.this.deleteLayoutData((ControlInfo)control);
                    }
                }
            }

            public void moveAfter(JavaInfo child, ObjectInfo oldParent, JavaInfo newParent) throws Exception {
                if (LayoutInfo.this.isActiveOnComposite(oldParent) && child instanceof ControlInfo && newParent != oldParent) {
                    LayoutInfo.this.onControlRemoveAfter((ControlInfo)child);
                }
                if (LayoutInfo.this.isActiveOnComposite((ObjectInfo)newParent) && child instanceof ControlInfo && newParent != oldParent) {
                    LayoutInfo.this.ensureLayoutData((ControlInfo)child);
                }
            }

            public void clipboardCopy(JavaInfo javaInfo, List<ClipboardCommand> commands) throws Exception {
                if (LayoutInfo.this.isActiveOnComposite((ObjectInfo)javaInfo)) {
                    LayoutInfo.this.clipboardCopy_addCompositeCommands(commands);
                }
            }
        });
        this.addBroadcastListener(new JavaInfoAddProperties(){

            public void invoke(JavaInfo javaInfo, List<Property> properties) throws Exception {
                if (LayoutInfo.this.isActiveOnComposite((ObjectInfo)javaInfo)) {
                    LayoutInfo.this.addLayoutProperties(properties);
                }
            }
        });
    }

    private void validateCorrespondence_Layout_LayoutData() throws Exception {
        CompositeInfo composite = this.getComposite();
        Object[] controls = ContainerSupport.getChildren(composite.getObject());
        if (this.hasLayoutData()) {
            Class<?> expectedLayoutDataClass = this.getLayoutDataClass();
            Object[] objectArray = controls;
            int n = controls.length;
            int n2 = 0;
            while (n2 < n) {
                Object control = objectArray[n2];
                Object layoutData = ControlSupport.getLayoutData(control);
                if (!ReflectionUtils.isAssignableFrom(expectedLayoutDataClass, (Object)layoutData)) {
                    throw new DesignerException(2003, new String[]{LayoutInfo.getShortClassName(layoutData), LayoutInfo.getShortComponentName(composite.getChildByObject(control)), LayoutInfo.getShortComponentName((JavaInfo)composite), LayoutInfo.getShortClassName(this.getDescription().getComponentClass()), LayoutInfo.getShortClassName(expectedLayoutDataClass)});
                }
                ++n2;
            }
        }
    }

    private static String getShortClassName(Object o) {
        Class<?> clazz = o.getClass();
        return LayoutInfo.getShortClassName(clazz);
    }

    private static String getShortClassName(Class<?> clazz) {
        if (clazz == null) {
            return "<null>";
        }
        return CodeUtils.getShortClass((String)clazz.getName());
    }

    private static String getShortComponentName(JavaInfo javaInfo) {
        if (javaInfo == null) {
            return "<null>";
        }
        return javaInfo.getVariableSupport().getComponentName();
    }

    public final IObjectPresentation getPresentation() {
        return new LayoutPresentation(this);
    }

    @Override
    public final CompositeInfo getComposite() {
        return (CompositeInfo)this.getParent();
    }

    @Override
    public final boolean isActive() {
        CompositeInfo composite = this.getComposite();
        return this.isActiveOnComposite((ObjectInfo)composite);
    }

    protected final boolean isActiveOnComposite(ObjectInfo composite) {
        return composite != null && composite.getChildren().contains(this);
    }

    @Override
    public final List<ControlInfo> getControls() {
        ArrayList controls = Lists.newArrayList();
        CompositeInfo composite = this.getComposite();
        if (this.isActiveOnComposite((ObjectInfo)composite)) {
            for (ControlInfo control : composite.getChildrenControls()) {
                if (!this.isManagedObject(control)) continue;
                controls.add(control);
            }
        }
        return controls;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isManagedObject(Object object) {
        Object object2 = object;
        if (object2 instanceof ControlInfo) {
            ControlInfo controlInfo = (ControlInfo)object2;
            ControlInfo cfr_ignored_0 = (ControlInfo)object2;
            if (this.isActive() && this.getComposite().getChildren().contains(object)) {
                void control;
                return !JavaInfoUtils.isIndirectlyExposed((JavaInfo)control);
            }
        }
        return false;
    }

    private void addLayoutProperties(List<Property> properties) throws Exception {
        Property[] layoutProperties = this.getProperties();
        if (this.m_layoutComplexProperty == null) {
            Class componentClass = this.getDescription().getComponentClass();
            String text = componentClass != null ? "(" + componentClass.getName() + ")" : "(absolute)";
            this.m_layoutComplexProperty = new ComplexProperty("Layout", text){

                public boolean isModified() throws Exception {
                    return true;
                }

                public void setValue(Object value) throws Exception {
                    if (value == UNKNOWN_VALUE) {
                        LayoutInfo.this.delete();
                    }
                }
            };
            this.m_layoutComplexProperty.setCategory(PropertyCategory.system((int)5));
            this.m_layoutComplexProperty.setEditorPresentation((PropertyEditorPresentation)new ButtonPropertyEditorPresentation(){

                protected Image getImage() {
                    return DesignerPlugin.getImage((String)"properties/down.png");
                }

                protected void onClick(PropertyTable propertyTable, Property property) throws Exception {
                    MenuManager manager = new MenuManager();
                    LayoutInfo.this.getComposite().fillLayoutsManager((IMenuManager)manager);
                    Menu menu = manager.createContextMenu((Control)propertyTable);
                    UiUtils.showAndDisposeOnHide((Menu)menu);
                }
            });
        }
        this.m_layoutComplexProperty.setProperties(layoutProperties);
        properties.add((Property)this.m_layoutComplexProperty);
    }

    public void onSet() throws Exception {
    }

    protected void onDelete() throws Exception {
        for (ControlInfo control : this.getComposite().getChildrenControls()) {
            this.deleteLayoutData(control);
        }
    }

    protected void onControlRemoveBefore(ControlInfo control) throws Exception {
    }

    protected void onControlRemoveAfter(ControlInfo control) throws Exception {
    }

    private boolean shouldCreateLayoutData(ControlInfo control) {
        return control.getArbitraryValue(KEY_DONT_CREATE_VIRTUAL_DATA) == null;
    }

    protected void deleteLayoutData(ControlInfo control) throws Exception {
        control.putArbitraryValue(KEY_DONT_CREATE_VIRTUAL_DATA, Boolean.TRUE);
        try {
            LayoutDataInfo layoutData = LayoutInfo.getLayoutData(control);
            if (layoutData != null) {
                this.storeLayoutData(control, layoutData);
                layoutData.delete();
                if (!layoutData.isDeleted()) {
                    control.removeChild((ObjectInfo)layoutData);
                }
            }
        }
        finally {
            control.removeArbitraryValue(KEY_DONT_CREATE_VIRTUAL_DATA);
        }
    }

    public static LayoutDataInfo getLayoutData(ControlInfo control) {
        ArrayList objects = Lists.newArrayList();
        for (ObjectInfo object : control.getChildren()) {
            if (!(object instanceof LayoutDataInfo)) continue;
            objects.add((LayoutDataInfo)object);
        }
        if (objects.isEmpty()) {
            return null;
        }
        Assert.isTrue((objects.size() == 1 ? 1 : 0) != 0);
        return (LayoutDataInfo)objects.get(0);
    }

    @Override
    public ILayoutDataInfo getLayoutData2(IControlInfo control) {
        return LayoutInfo.getLayoutData((ControlInfo)control);
    }

    private void ensureLayoutData(ControlInfo control) throws Exception {
        if (JavaInfoUtils.isIndirectlyExposed((JavaInfo)control)) {
            return;
        }
        if (this.hasLayoutData()) {
            LayoutDataInfo layoutData = LayoutInfo.getLayoutData(control);
            if (layoutData != null) {
                return;
            }
            if (control.getCreationSupport() instanceof IImplicitCreationSupport) {
                Object layoutDataObject;
                if (control.getArbitraryValue(KEY_EXPOSED_HAS_DATA) != null) {
                    layoutDataObject = control.getArbitraryValue(KEY_EXPOSED_DATA);
                } else {
                    layoutDataObject = ControlSupport.getLayoutData(control.getObject());
                    control.putArbitraryValue(KEY_EXPOSED_HAS_DATA, Boolean.TRUE);
                    control.putArbitraryValue(KEY_EXPOSED_DATA, layoutDataObject);
                }
                if (layoutDataObject == null) {
                    this.createVirtualLayoutData(control);
                } else {
                    this.createImplicitLayoutData(control);
                }
            } else {
                this.createVirtualLayoutData(control);
            }
        }
    }

    private void createImplicitLayoutData(ControlInfo control) throws Exception {
        ImplicitLayoutDataCreationSupport creationSupport = new ImplicitLayoutDataCreationSupport(control);
        JavaInfo layoutData = JavaInfoUtils.createJavaInfo((AstEditor)this.getEditor(), this.getLayoutDataClass(), (CreationSupport)creationSupport);
        layoutData.setVariableSupport((VariableSupport)new ImplicitLayoutDataVariableSupport(layoutData));
        layoutData.setAssociation((Association)new ImplicitObjectAssociation((JavaInfo)control));
        control.addChild((ObjectInfo)layoutData);
    }

    private void createVirtualLayoutData(ControlInfo control) throws Exception {
        Object dataObject = this.getDefaultVirtualDataObject();
        VirtualLayoutDataCreationSupport creationSupport = new VirtualLayoutDataCreationSupport(control, dataObject);
        JavaInfo layoutData = JavaInfoUtils.createJavaInfo((AstEditor)this.getEditor(), this.getLayoutDataClass(), (CreationSupport)creationSupport);
        layoutData.setVariableSupport((VariableSupport)new VirtualLayoutDataVariableSupport(layoutData));
        layoutData.setAssociation((Association)new EmptyAssociation());
        control.addChild((ObjectInfo)layoutData);
    }

    protected Object getDefaultVirtualDataObject() throws Exception {
        throw new NotImplementedException(this.getClass());
    }

    private boolean hasLayoutData() {
        return JavaInfoUtils.hasTrueParameter((JavaInfo)this, (String)KEY_LAYOUT_DATA_HAS);
    }

    private Class<?> getLayoutDataClass() throws Exception {
        if (this.m_layoutDataClass == null) {
            String layoutDataClassName = JavaInfoUtils.getParameter((JavaInfo)this, (String)KEY_LAYOUT_DATA_CLASS);
            Assert.isNotNull((Object)layoutDataClassName);
            Assert.isTrue((layoutDataClassName.length() != 0 ? 1 : 0) != 0);
            this.m_layoutDataClass = JavaInfoUtils.getClassLoader((JavaInfo)this).loadClass(layoutDataClassName);
        }
        return this.m_layoutDataClass;
    }

    public final void command_CREATE(ControlInfo control, ControlInfo nextControl) throws Exception {
        this.startEdit();
        try {
            JavaInfoUtils.add((JavaInfo)control, null, (JavaInfo)this.getComposite(), (JavaInfo)nextControl);
        }
        finally {
            this.endEdit();
        }
    }

    public final void command_MOVE(ControlInfo control, ControlInfo nextControl) throws Exception {
        this.startEdit();
        try {
            JavaInfoUtils.move((JavaInfo)control, null, (JavaInfo)this.getComposite(), (JavaInfo)nextControl);
        }
        finally {
            this.endEdit();
        }
    }

    protected void clipboardCopy_addCompositeCommands(List<ClipboardCommand> commands) throws Exception {
        for (ControlInfo control : this.getComposite().getChildrenControls()) {
            if (JavaInfoUtils.isImplicitlyCreated((JavaInfo)control)) continue;
            this.clipboardCopy_addControlCommands(control, commands);
        }
    }

    protected void clipboardCopy_addControlCommands(ControlInfo control, List<ClipboardCommand> commands) throws Exception {
    }

    protected void storeLayoutData(ControlInfo control, LayoutDataInfo layoutData) throws Exception {
    }
}

