/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.hierarchy;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.TextDisplayPropertyEditor;
import org.eclipse.wb.internal.core.model.property.table.IPropertyTooltipSite;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipProvider;

public final class ComponentClassPropertyEditor
extends TextDisplayPropertyEditor {
    private final IJavaProject m_javaProject;
    private final Class<?> m_componentClass;

    public ComponentClassPropertyEditor(IJavaProject javaProject, Class<?> componentClass) {
        this.m_javaProject = javaProject;
        this.m_componentClass = componentClass;
    }

    protected String getText(Property property) throws Exception {
        return this.m_componentClass.getName();
    }

    protected PropertyTooltipProvider createPropertyTooltipProvider() {
        return new PropertyTooltipProvider(){

            public Control createTooltipControl(Property property, Composite parent, int availableWidth, final IPropertyTooltipSite site) {
                ArrayList classes = Lists.newArrayList();
                Class<?> clazz = ComponentClassPropertyEditor.this.m_componentClass;
                while (clazz != null) {
                    classes.add(clazz);
                    clazz = clazz.getSuperclass();
                }
                Tree tree = new Tree(parent, 0){

                    public Point computeSize(int wHint, int hHint, boolean changed) {
                        Point minLocation = new Point(0, 0);
                        Point maxLocation = new Point(0, 0);
                        this.updateMaxSize(minLocation, maxLocation, this.getItems());
                        Point size = new Point(maxLocation.x - minLocation.x, maxLocation.y - minLocation.y);
                        int verticalBarSize = this.getVerticalBar().getSize().x;
                        int horizontalBarSize = this.getHorizontalBar().getSize().y;
                        size.x = size.x + (EnvironmentUtils.IS_WINDOWS ? verticalBarSize + 10 : verticalBarSize * 3);
                        size.y = size.y + (EnvironmentUtils.IS_WINDOWS ? horizontalBarSize : horizontalBarSize * 2);
                        return size;
                    }

                    private void updateMaxSize(Point minLocation, Point maxLocation, TreeItem[] rootItems) {
                        int i = 0;
                        while (i < rootItems.length) {
                            TreeItem item = rootItems[i];
                            Rectangle bounds = item.getBounds();
                            minLocation.x = Math.min(minLocation.x, bounds.x);
                            minLocation.y = Math.min(minLocation.y, bounds.y);
                            maxLocation.x = Math.max(maxLocation.x, bounds.x + bounds.width);
                            maxLocation.y = Math.max(maxLocation.y, bounds.y + bounds.height);
                            this.updateMaxSize(minLocation, maxLocation, item.getItems());
                            ++i;
                        }
                    }

                    protected void checkSubclass() {
                    }
                };
                tree.setForeground(parent.getForeground());
                tree.setBackground(parent.getBackground());
                TreeViewer treeViewer = new TreeViewer(tree);
                treeViewer.setContentProvider((IContentProvider)new ComponentClassContentProvider());
                treeViewer.setLabelProvider((IBaseLabelProvider)new ComponentClassLabelProvider(tree));
                treeViewer.setInput((Object)classes);
                treeViewer.expandAll();
                treeViewer.addDoubleClickListener(new IDoubleClickListener(){

                    public void doubleClick(DoubleClickEvent event) {
                        try {
                            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                            Class clazz = (Class)selection.getFirstElement();
                            String className = clazz.getName();
                            IType type = (this).ComponentClassPropertyEditor.this.m_javaProject.findType(className);
                            if (type != null) {
                                site.hideTooltip();
                                JavaUI.openInEditor((IJavaElement)type);
                            }
                        }
                        catch (Throwable e) {
                            DesignerPlugin.log((Throwable)e);
                        }
                    }
                });
                PropertyTooltipProvider.HideListener listener = new PropertyTooltipProvider.HideListener(site);
                tree.addListener(7, (Listener)listener);
                return tree;
            }
        };
    }

    private static class ComponentClassContentProvider
    implements ITreeContentProvider {
        private List<?> m_classes;

        private ComponentClassContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return new Object[]{this.m_classes.get(this.m_classes.size() - 1)};
        }

        public Object[] getChildren(Object parentElement) {
            int index = this.m_classes.indexOf(parentElement);
            if (index == 0) {
                return null;
            }
            return new Object[]{this.m_classes.get(index - 1)};
        }

        public Object getParent(Object element) {
            int index = this.m_classes.indexOf(element);
            return this.m_classes.get(index + 1);
        }

        public boolean hasChildren(Object element) {
            return this.m_classes.indexOf(element) != 0;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.m_classes = (List)newInput;
        }
    }

    private class ComponentClassLabelProvider
    extends LabelProvider
    implements IFontProvider {
        private final Font m_treeFont;

        public ComponentClassLabelProvider(Tree tree) {
            this.m_treeFont = FontDescriptor.createFrom((Font)tree.getFont()).setStyle(1).createFont(null);
        }

        public String getText(Object element) {
            Class clazz = (Class)element;
            return clazz.getName();
        }

        public Image getImage(Object element) {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.class_obj.gif");
        }

        public Font getFont(Object element) {
            Class clazz = (Class)element;
            if (clazz == ComponentClassPropertyEditor.this.m_componentClass) {
                return this.m_treeFont;
            }
            return null;
        }
    }
}

