/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.ModelMessages;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.GenericPropertyImpl;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.accessor.ExpressionAccessor;
import org.eclipse.wb.internal.core.model.property.accessor.SetterAccessor;
import org.eclipse.wb.internal.core.model.property.editor.IObjectPropertyProcessor;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.TextDialogPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.complex.IComplexPropertyEditor;
import org.eclipse.wb.internal.core.model.util.ObjectsLabelProvider;
import org.eclipse.wb.internal.core.model.util.ObjectsTreeContentProvider;
import org.eclipse.wb.internal.core.model.util.TemplateUtils;
import org.eclipse.wb.internal.core.model.variable.LazyVariableSupport;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.core.utils.dialogfields.StatusUtils;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;

public final class ObjectPropertyEditor
extends TextDialogPropertyEditor
implements IComplexPropertyEditor {
    public static final PropertyEditor INSTANCE = new ObjectPropertyEditor();

    private ObjectPropertyEditor() {
    }

    public JavaInfo getValueComponent(Property property) throws Exception {
        Object value = property.getValue();
        GenericProperty genericProperty = (GenericProperty)property;
        return genericProperty.getJavaInfo().getRootJava().getChildByObject(value);
    }

    protected String getText(Property property) throws Exception {
        JavaInfo component = this.getValueComponent(property);
        if (component != null) {
            return ObjectInfo.getText((ObjectInfo)component);
        }
        return null;
    }

    protected void openDialog(Property property_) throws Exception {
        GenericProperty property = (GenericProperty)property_;
        JavaInfo thisComponent = property.getJavaInfo();
        final Class propertyType = property.getType();
        ISelectionStatusValidator validator = new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 1 && ObjectPropertyEditor.this.isValidComponent(propertyType, selection[0])) {
                    return StatusUtils.OK_STATUS;
                }
                return StatusUtils.ERROR_STATUS;
            }
        };
        ITreeContentProvider contentProvider = this.createContentProvider(propertyType);
        ElementTreeSelectionDialog selectionDialog = new ElementTreeSelectionDialog(DesignerPlugin.getShell(), (ILabelProvider)new ObjectsLabelProvider(), contentProvider){

            public void create() {
                super.create();
                this.getTreeViewer().expandAll();
            }
        };
        selectionDialog.setAllowMultiple(false);
        selectionDialog.setTitle(property_.getTitle());
        selectionDialog.setMessage(ModelMessages.ObjectPropertyEditor_chooseMessage);
        selectionDialog.setValidator(validator);
        selectionDialog.setInput((Object)new Object[]{thisComponent.getRoot()});
        JavaInfo component = this.getValueComponent((Property)property);
        selectionDialog.setInitialSelection((Object)component);
        if (selectionDialog.open() == 0) {
            JavaInfo component2 = (JavaInfo)((Object)selectionDialog.getFirstResult());
            this.setComponent(property, component2);
        }
    }

    private ITreeContentProvider createContentProvider(final Class<?> propertyType) {
        ITreeContentProvider[] contentProvider;
        contentProvider = new ITreeContentProvider[]{new ObjectsTreeContentProvider((Predicate)new Predicate<ObjectInfo>(){

            public boolean apply(ObjectInfo t) {
                return ObjectPropertyEditor.this.isValidComponent(propertyType, t) || this.hasValidComponents(t);
            }

            private boolean hasValidComponents(ObjectInfo t) {
                return contentProvider[0].getChildren((Object)t).length != 0;
            }
        })};
        return contentProvider[0];
    }

    /*
     * WARNING - void declaration
     */
    private boolean isValidComponent(Class<?> propertyType, Object element) {
        Object object = element;
        if (object instanceof JavaInfo) {
            void component;
            JavaInfo javaInfo = (JavaInfo)((Object)object);
            JavaInfo cfr_ignored_0 = (JavaInfo)((Object)object);
            Class<?> componentClass = component.getDescription().getComponentClass();
            return componentClass != null && propertyType.isAssignableFrom(componentClass);
        }
        return false;
    }

    public void setComponent(final GenericProperty property, final JavaInfo component) throws Exception {
        ExecutionUtils.run((ObjectInfo)property.getJavaInfo(), (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                ObjectPropertyEditor.this.setComponent0(property, component);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void setComponent0(GenericProperty property, JavaInfo component) throws Exception {
        JavaInfo thisComponent = property.getJavaInfo();
        property.setValue(Property.UNKNOWN_VALUE);
        if (component != null) {
            Method setter = ObjectPropertyEditor.getSetter((Property)property);
            if (setter != null) {
                StatementTarget target = null;
                JavaInfo javaInfo = thisComponent;
                if (javaInfo instanceof IObjectPropertyProcessor) {
                    void objectPropertyProcessor;
                    IObjectPropertyProcessor iObjectPropertyProcessor = (IObjectPropertyProcessor)((Object)javaInfo);
                    IObjectPropertyProcessor cfr_ignored_0 = (IObjectPropertyProcessor)((Object)javaInfo);
                    target = objectPropertyProcessor.getObjectPropertyStatementTarget(property, component);
                }
                if (target == null) {
                    if (component.getVariableSupport() instanceof LazyVariableSupport) {
                        property.setExpression(TemplateUtils.getExpression(component), (Object)component);
                        return;
                    }
                    ImmutableList allComponents = ImmutableList.of((Object)((Object)thisComponent), (Object)((Object)component));
                    target = JavaInfoUtils.getStatementTarget_whenAllCreated((List<? extends JavaInfo>)allComponents);
                }
                String source = TemplateUtils.format("{0}.{1}({2})", new Object[]{thisComponent, setter.getName(), component});
                Expression expression = thisComponent.addExpressionStatement(target, source);
                component.addRelatedNodes((ASTNode)expression);
                return;
            }
            property.setExpression(TemplateUtils.getExpression(component), (Object)component);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Method getSetter(Property property) throws Exception {
        Property property2 = property;
        if (property2 instanceof GenericPropertyImpl) {
            void genericProperty;
            GenericPropertyImpl genericPropertyImpl = (GenericPropertyImpl)property2;
            GenericPropertyImpl cfr_ignored_0 = (GenericPropertyImpl)property2;
            List<ExpressionAccessor> accessors = genericProperty.getAccessors();
            for (ExpressionAccessor accessor : accessors) {
                if (!(accessor instanceof SetterAccessor)) continue;
                return ((SetterAccessor)accessor).getSetter();
            }
        }
        return null;
    }

    public Property[] getProperties(Property property) throws Exception {
        JavaInfo component = this.getValueComponent(property);
        if (component != null) {
            return component.getProperties();
        }
        return new Property[0];
    }
}

